/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.Platform;

public class NewInstanceDependencySupport
extends AbstractDependencyListener {
    private DependencyNode allClassesNode;

    public void started(DependencyAgent agent) {
        this.allClassesNode = agent.createNode();
    }

    public void classReached(DependencyAgent agent, String className, CallLocation location) {
        ClassReader cls = agent.getClassSource().get(className);
        if (cls == null) {
            return;
        }
        if (cls.hasModifier(ElementModifier.ABSTRACT) || cls.hasModifier(ElementModifier.INTERFACE)) {
            return;
        }
        MethodReader method = cls.getMethod(new MethodDescriptor("<init>", new Class[]{Void.TYPE}));
        if (method != null) {
            this.allClassesNode.propagate(agent.getType(className));
        }
    }

    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        MethodReader reader = method.getMethod();
        if (reader.getOwnerName().equals(Platform.class.getName()) && reader.getName().equals("newInstanceImpl")) {
            this.allClassesNode.connect(method.getResult());
            MethodReference methodRef = reader.getReference();
            method.getResult().addConsumer(type -> this.attachConstructor(agent, type.getName(), new CallLocation(methodRef)));
        }
    }

    private void attachConstructor(DependencyAgent checker, String type, CallLocation location) {
        MethodReference ref = new MethodReference(type, "<init>", new ValueType[]{ValueType.VOID});
        MethodDependency methodDep = checker.linkMethod(ref, location);
        methodDep.getVariable(0).propagate(checker.getType(type));
        methodDep.use();
    }
}

