/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.ResourceWriter;
import org.teavm.platform.plugin.ResourceWriterHelper;

class BuildTimeResourceMap<T extends Resource>
implements ResourceMap<T>,
ResourceWriter {
    private Map<String, T> data = new HashMap<String, T>();

    BuildTimeResourceMap() {
    }

    @Override
    public boolean has(String key) {
        return this.data.containsKey(key);
    }

    @Override
    public T get(String key) {
        return (T)((Resource)this.data.get(key));
    }

    @Override
    public void put(String key, T value) {
        this.data.put(key, value);
    }

    @Override
    public void write(SourceWriter writer) throws IOException {
        writer.append('{');
        boolean first = true;
        for (Map.Entry<String, T> entry : this.data.entrySet()) {
            if (!first) {
                writer.append(",").ws();
            }
            first = false;
            ResourceWriterHelper.writeString(writer, entry.getKey());
            writer.ws().append(':').ws();
            ResourceWriterHelper.write(writer, entry.getValue());
        }
        writer.append('}').tokenBoundary();
    }

    @Override
    public String[] keys() {
        return this.data.keySet().toArray(new String[this.data.size()]);
    }
}

