/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.backend.javascript.spi.GeneratedBy;
import org.teavm.dependency.PluggableDependency;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Async;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.ValueType;
import org.teavm.platform.async.AsyncCallback;
import org.teavm.platform.plugin.AsyncMethodGenerator;

public class AsyncMethodProcessor
implements ClassHolderTransformer {
    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        for (MethodHolder method : cls.getMethods()) {
            if (!method.hasModifier(ElementModifier.NATIVE) || method.getAnnotations().get(Async.class.getName()) == null || method.getAnnotations().get(GeneratedBy.class.getName()) != null) continue;
            ValueType[] signature = new ValueType[method.parameterCount() + 2];
            for (int i = 0; i < method.parameterCount(); ++i) {
                signature[i] = method.parameterType(i);
            }
            signature[method.parameterCount()] = ValueType.parse(AsyncCallback.class);
            signature[method.parameterCount() + 1] = ValueType.VOID;
            MethodDescriptor asyncDesc = new MethodDescriptor(method.getName(), signature);
            MethodHolder asyncMethod = cls.getMethod(asyncDesc);
            if (asyncMethod == null) continue;
            if (asyncMethod.hasModifier(ElementModifier.STATIC) != method.hasModifier(ElementModifier.STATIC)) {
                diagnostics.error(new CallLocation(method.getReference()), "Methods {{m0}} and {{m1}} must both be either static or non-static", new Object[]{method.getReference(), asyncMethod.getReference()});
            }
            AnnotationHolder annot = new AnnotationHolder(GeneratedBy.class.getName());
            annot.getValues().put("value", new AnnotationValue(ValueType.parse(AsyncMethodGenerator.class)));
            method.getAnnotations().add(annot);
            annot = new AnnotationHolder(PluggableDependency.class.getName());
            annot.getValues().put("value", new AnnotationValue(ValueType.parse(AsyncMethodGenerator.class)));
            method.getAnnotations().add(annot);
        }
    }
}

