/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.io.IOException;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.platform.plugin.ResourceWriter;

final class ResourceWriterHelper {
    private ResourceWriterHelper() {
    }

    public static void write(SourceWriter writer, Object resource) throws IOException {
        if (resource == null) {
            writer.append("null");
        } else if (resource instanceof ResourceWriter) {
            ((ResourceWriter)resource).write(writer);
        } else if (resource instanceof Number) {
            writer.append(resource);
        } else if (resource instanceof Boolean) {
            writer.append(resource == Boolean.TRUE ? "true" : "false");
        } else if (resource instanceof String) {
            ResourceWriterHelper.writeString(writer, (String)resource);
        } else {
            throw new RuntimeException("Error compiling resources. Value of illegal type found: " + resource.getClass());
        }
    }

    public static void writeIdentifier(SourceWriter writer, String id) throws IOException {
        if (id.isEmpty() || !ResourceWriterHelper.isIdentifierStart(id.charAt(0))) {
            ResourceWriterHelper.writeString(writer, id);
            return;
        }
        for (int i = 1; i < id.length(); ++i) {
            if (!ResourceWriterHelper.isIdentifierPart(id.charAt(i))) continue;
            ResourceWriterHelper.writeString(writer, id);
            return;
        }
        writer.append(id);
    }

    private static boolean isIdentifierStart(char c) {
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            return true;
        }
        return c == '$' || c == '_';
    }

    private static boolean isIdentifierPart(char c) {
        if (ResourceWriterHelper.isIdentifierStart(c)) {
            return true;
        }
        return c >= '0' && c <= '9';
    }

    public static void writeString(SourceWriter writer, String s) throws IOException {
        writer.append('\"');
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    writer.append("\\0");
                    continue block6;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block6;
                }
                case '\r': {
                    writer.append("\\r");
                    continue block6;
                }
                case '\t': {
                    writer.append("\\t");
                    continue block6;
                }
                default: {
                    if (c < ' ') {
                        writer.append("\\u00").append(Character.forDigit(c / 16, 16)).append(Character.forDigit(c % 16, 16));
                        continue block6;
                    }
                    writer.append(c);
                }
            }
        }
        writer.append('\"');
    }
}

