/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform;

import java.lang.annotation.Annotation;
import org.teavm.dependency.PluggableDependency;
import org.teavm.javascript.spi.GeneratedBy;
import org.teavm.javascript.spi.InjectedBy;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSObject;
import org.teavm.jso.browser.Window;
import org.teavm.platform.PlatformClass;
import org.teavm.platform.PlatformConsole;
import org.teavm.platform.PlatformHelper;
import org.teavm.platform.PlatformObject;
import org.teavm.platform.PlatformPrimitives;
import org.teavm.platform.PlatformQueue;
import org.teavm.platform.PlatformRunnable;
import org.teavm.platform.PlatformSequence;
import org.teavm.platform.PlatformString;
import org.teavm.platform.metadata.ClassResource;
import org.teavm.platform.metadata.StaticFieldResource;
import org.teavm.platform.plugin.PlatformGenerator;

public final class Platform {
    private Platform() {
    }

    @InjectedBy(value=PlatformGenerator.class)
    public static native PlatformObject getPlatformObject(Object var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Object clone(Object var0);

    public static boolean isInstance(PlatformObject obj, PlatformClass cls) {
        return obj != null && !Platform.isUndefined(obj.getPlatformClass().getMetadata()) && Platform.isAssignable(obj.getPlatformClass(), cls);
    }

    @JSBody(params={"object"}, script="return typeof object === 'undefined';")
    private static native boolean isUndefined(JSObject var0);

    public static boolean isAssignable(PlatformClass from, PlatformClass to) {
        if (from == to) {
            return true;
        }
        PlatformSequence<PlatformClass> supertypes = from.getMetadata().getSupertypes();
        for (int i = 0; i < supertypes.getLength(); ++i) {
            if (!Platform.isAssignable(supertypes.get(i), to)) continue;
            return true;
        }
        return false;
    }

    @InjectedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Class<?> asJavaClass(PlatformObject var0);

    public static PlatformPrimitives getPrimitives() {
        return (PlatformPrimitives)Window.current();
    }

    public static PlatformConsole getConsole() {
        return (PlatformConsole)Window.current();
    }

    public static int nextObjectId() {
        return ((PlatformHelper)Window.current()).nextId();
    }

    public static <T> T newInstance(PlatformClass cls) {
        Platform.prepareNewInstance();
        return Platform.newInstanceImpl(cls);
    }

    @GeneratedBy(value=PlatformGenerator.class)
    private static native void prepareNewInstance();

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    private static native <T> T newInstanceImpl(PlatformClass var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native PlatformClass lookupClass(String var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native void initClass(PlatformClass var0);

    @InjectedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native PlatformClass classFromResource(ClassResource var0);

    @InjectedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Object objectFromResource(StaticFieldResource var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Enum<?>[] getEnumConstants(PlatformClass var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native Annotation[] getAnnotations(PlatformClass var0);

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native void startThread(PlatformRunnable var0);

    private static void launchThread(PlatformRunnable runnable) {
        runnable.run();
    }

    public static void postpone(PlatformRunnable runnable) {
        Platform.schedule(runnable, 0);
    }

    @GeneratedBy(value=PlatformGenerator.class)
    @PluggableDependency(value=PlatformGenerator.class)
    public static native int schedule(PlatformRunnable var0, int var1);

    public static void killSchedule(int id) {
        ((PlatformHelper)Window.current()).killSchedule(id);
    }

    @JSBody(params={}, script="return [];")
    public static native <T> PlatformQueue<T> createQueue();

    public static PlatformString stringFromCharCode(int charCode) {
        return ((PlatformHelper)Window.current()).getStringClass().fromCharCode(charCode);
    }
}

