/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.teavm.common.ServiceRepository;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.platform.metadata.ClassResource;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StaticFieldResource;
import org.teavm.platform.plugin.BuildTimeClassResource;
import org.teavm.platform.plugin.BuildTimeResourceArray;
import org.teavm.platform.plugin.BuildTimeResourceMap;
import org.teavm.platform.plugin.BuildTimeResourceProxyBuilder;
import org.teavm.platform.plugin.BuildTimeStaticFieldResource;
import org.teavm.platform.plugin.ResourceWriter;

class DefaultMetadataGeneratorContext
implements MetadataGeneratorContext {
    private ListableClassReaderSource classSource;
    private ClassLoader classLoader;
    private Properties properties;
    private BuildTimeResourceProxyBuilder proxyBuilder = new BuildTimeResourceProxyBuilder();
    private ServiceRepository services;

    public DefaultMetadataGeneratorContext(ListableClassReaderSource classSource, ClassLoader classLoader, Properties properties, ServiceRepository services) {
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.properties = properties;
        this.services = services;
    }

    @Override
    public ListableClassReaderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    @Override
    public <T extends Resource> T createResource(Class<T> resourceType) {
        return (T)((Resource)resourceType.cast(Proxy.newProxyInstance(this.classLoader, new Class[]{resourceType, ResourceWriter.class}, (InvocationHandler)this.proxyBuilder.buildProxy(resourceType))));
    }

    @Override
    public <T extends Resource> ResourceArray<T> createResourceArray() {
        return new BuildTimeResourceArray();
    }

    @Override
    public ClassResource createClassResource(String className) {
        return new BuildTimeClassResource(className);
    }

    @Override
    public StaticFieldResource createFieldResource(FieldReference field) {
        return new BuildTimeStaticFieldResource(field);
    }

    @Override
    public <T extends Resource> ResourceMap<T> createResourceMap() {
        return new BuildTimeResourceMap();
    }

    public <T> T getService(Class<T> type) {
        return (T)this.services.getService(type);
    }
}

