/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.teavm.codegen.SourceWriter;
import org.teavm.common.ServiceRepository;
import org.teavm.javascript.spi.Generator;
import org.teavm.javascript.spi.GeneratorContext;
import org.teavm.model.AnnotationReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataProvider;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.MetadataProviderRef;
import org.teavm.platform.plugin.ResourceWriterHelper;

public class MetadataProviderNativeGenerator
implements Generator {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        MetadataGenerator generator;
        Constructor<?> cons;
        Class<?> generatorClass;
        ClassReader cls = context.getClassSource().get(methodRef.getClassName());
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        AnnotationReader providerAnnot = method.getAnnotations().get(MetadataProvider.class.getName());
        AnnotationReader refAnnot = method.getAnnotations().get(MetadataProviderRef.class.getName());
        methodRef = MethodReference.parse((String)refAnnot.getValue("value").getString());
        ValueType generatorType = providerAnnot.getValue("value").getJavaClass();
        String generatorClassName = ((ValueType.Object)generatorType).getClassName();
        try {
            generatorClass = Class.forName(generatorClassName, true, context.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            context.getDiagnostics().error(new CallLocation(methodRef), "Can't find metadata provider class {{c0}}", new Object[]{generatorClassName});
            return;
        }
        try {
            cons = generatorClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            context.getDiagnostics().error(new CallLocation(methodRef), "Metadata generator {{c0}} does not have a public no-arg constructor", new Object[]{generatorClassName});
            return;
        }
        try {
            generator = (MetadataGenerator)cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            context.getDiagnostics().error(new CallLocation(methodRef), "Error instantiating metadata generator {{c0}}", new Object[]{generatorClassName});
            return;
        }
        DefaultMetadataGeneratorContext metadataContext = new DefaultMetadataGeneratorContext(context.getClassSource(), context.getClassLoader(), context.getProperties(), (ServiceRepository)context);
        Resource resource = generator.generateMetadata(metadataContext, methodRef);
        writer.append("return ");
        ResourceWriterHelper.write(writer, resource);
        writer.append(';').softNewLine();
    }
}

