/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.javascript.spi.Generator;
import org.teavm.javascript.spi.Injector;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.platform.plugin.ResourceAccessor;
import org.teavm.platform.plugin.ResourceAccessorGenerator;
import org.teavm.platform.plugin.ResourceAccessorInjector;
import org.teavm.vm.spi.TeaVMHost;

class ResourceAccessorTransformer
implements ClassHolderTransformer {
    private TeaVMHost vm;

    public ResourceAccessorTransformer(TeaVMHost vm) {
        this.vm = vm;
    }

    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        if (cls.getName().equals(ResourceAccessor.class.getName())) {
            ResourceAccessorInjector injector = new ResourceAccessorInjector();
            for (MethodHolder method : cls.getMethods()) {
                if (!method.hasModifier(ElementModifier.NATIVE)) continue;
                if (method.getName().equals("keys")) {
                    this.vm.add(method.getReference(), (Generator)new ResourceAccessorGenerator());
                    continue;
                }
                this.vm.add(method.getReference(), (Injector)injector);
            }
        }
    }
}

