/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.io.IOException;
import org.teavm.codegen.SourceWriter;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.DependencyTypeFilter;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.spi.Generator;
import org.teavm.javascript.spi.GeneratorContext;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.async.AsyncCallback;
import org.teavm.platform.plugin.AsyncCallbackWrapper;

public class AsyncMethodGenerator
implements Generator,
DependencyPlugin {
    private static final MethodReference completeMethod = new MethodReference(AsyncCallback.class, "complete", new Class[]{Object.class, Void.TYPE});
    private static final MethodReference errorMethod = new MethodReference(AsyncCallback.class, "error", new Class[]{Throwable.class, Void.TYPE});

    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        int start;
        MethodReference asyncRef = this.getAsyncReference(methodRef);
        writer.append("var thread").ws().append('=').ws().append("$rt_nativeThread();").softNewLine();
        writer.append("var javaThread").ws().append('=').ws().append("$rt_getThread();").softNewLine();
        writer.append("if").ws().append("(thread.isResuming())").ws().append("{").indent().softNewLine();
        writer.append("thread.status").ws().append("=").ws().append("0;").softNewLine();
        writer.append("var result").ws().append("=").ws().append("thread.attribute;").softNewLine();
        writer.append("if").ws().append("(result instanceof Error)").ws().append("{").indent().softNewLine();
        writer.append("throw result;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return result;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("var callback").ws().append("=").ws().append("function()").ws().append("{};").softNewLine();
        writer.append("callback.").appendMethod(completeMethod.getDescriptor()).ws().append("=").ws().append("function(val)").ws().append("{").indent().softNewLine();
        writer.append("thread.attribute").ws().append('=').ws().append("val;").softNewLine();
        writer.append("$rt_setThread(javaThread);").softNewLine();
        writer.append("thread.resume();").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.append("callback.").appendMethod(errorMethod.getDescriptor()).ws().append("=").ws().append("function(e)").ws().append("{").indent().softNewLine();
        writer.append("thread.attribute").ws().append('=').ws().append("$rt_exception(e);").softNewLine();
        writer.append("$rt_setThread(javaThread);").softNewLine();
        writer.append("thread.resume();").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.append("callback").ws().append("=").ws().appendMethodBody(AsyncCallbackWrapper.class, "create", new Class[]{AsyncCallback.class, AsyncCallbackWrapper.class}).append("(callback);").softNewLine();
        writer.append("return thread.suspend(function()").ws().append("{").indent().softNewLine();
        writer.append("try").ws().append("{").indent().softNewLine();
        writer.appendMethodBody(asyncRef).append('(');
        ClassReader cls = context.getClassSource().get(methodRef.getClassName());
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        for (int i = start = method.hasModifier(ElementModifier.STATIC) ? 1 : 0; i <= methodRef.parameterCount(); ++i) {
            writer.append(context.getParameterName(i));
            writer.append(',').ws();
        }
        writer.append("callback);").softNewLine();
        writer.outdent().append("}").ws().append("catch($e)").ws().append("{").indent().softNewLine();
        writer.append("callback.").appendMethod(errorMethod.getDescriptor()).append("($rt_exception($e));").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.outdent().append("});").softNewLine();
    }

    private MethodReference getAsyncReference(MethodReference methodRef) {
        ValueType[] signature = new ValueType[methodRef.parameterCount() + 2];
        for (int i = 0; i < methodRef.parameterCount(); ++i) {
            signature[i] = methodRef.getDescriptor().parameterType(i);
        }
        signature[methodRef.parameterCount()] = ValueType.parse(AsyncCallback.class);
        signature[methodRef.parameterCount() + 1] = ValueType.VOID;
        return new MethodReference(methodRef.getClassName(), methodRef.getName(), signature);
    }

    public void methodAchieved(final DependencyAgent checker, final MethodDependency method, CallLocation location) {
        MethodReference asyncRef = this.getAsyncReference(method.getReference());
        MethodDependency asyncMethod = checker.linkMethod(asyncRef, location);
        int paramCount = method.getReference().parameterCount();
        for (int i = 0; i <= paramCount; ++i) {
            method.getVariable(i).connect(asyncMethod.getVariable(i));
        }
        asyncMethod.getVariable(paramCount + 1).propagate(checker.getType(AsyncCallbackWrapper.class.getName()));
        MethodDependency completeMethod = checker.linkMethod(new MethodReference(AsyncCallbackWrapper.class, "complete", new Class[]{Object.class, Void.TYPE}), null);
        if (method.getResult() != null) {
            completeMethod.getVariable(1).connect(method.getResult(), new DependencyTypeFilter(){

                public boolean match(DependencyType type) {
                    return AsyncMethodGenerator.this.isSubtype(checker.getClassSource(), type.getName(), method.getReference().getReturnType());
                }
            });
        }
        completeMethod.use();
        MethodDependency errorMethod = checker.linkMethod(new MethodReference(AsyncCallbackWrapper.class, "error", new Class[]{Throwable.class, Void.TYPE}), null);
        errorMethod.getVariable(1).connect(method.getThrown());
        errorMethod.use();
        checker.linkMethod(new MethodReference(AsyncCallbackWrapper.class, "create", new Class[]{AsyncCallback.class, AsyncCallbackWrapper.class}), null).use();
        asyncMethod.use();
    }

    private boolean isSubtype(ClassReaderSource classSource, String className, ValueType returnType) {
        if (returnType instanceof ValueType.Primitive) {
            return false;
        }
        if (returnType instanceof ValueType.Array) {
            return className.startsWith("[");
        }
        return this.isSubclass(classSource, className, ((ValueType.Object)returnType).getClassName());
    }

    private boolean isSubclass(ClassReaderSource classSource, String className, String baseClass) {
        if (className.equals(baseClass)) {
            return true;
        }
        ClassReader cls = classSource.get(className);
        if (cls == null) {
            return false;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && this.isSubclass(classSource, cls.getParent(), baseClass)) {
            return true;
        }
        for (String iface : cls.getInterfaces()) {
            if (!this.isSubclass(classSource, iface, baseClass)) continue;
            return true;
        }
        return false;
    }
}

