/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.teavm.codegen.SourceWriter;
import org.teavm.common.ServiceRepository;
import org.teavm.javascript.ni.Generator;
import org.teavm.javascript.ni.GeneratorContext;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.MetadataProvider;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.ResourceWriterHelper;

public class MetadataProviderNativeGenerator
implements Generator {
    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        MetadataGenerator generator;
        Constructor<?> cons;
        Class<?> generatorClass;
        ClassReader cls = context.getClassSource().get(methodRef.getClassName());
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        AnnotationReader providerAnnot = method.getAnnotations().get(MetadataProvider.class.getName());
        if (providerAnnot == null) {
            return;
        }
        if (!method.hasModifier(ElementModifier.NATIVE)) {
            throw new IllegalStateException("Method " + method.getReference() + " was marked with " + MetadataProvider.class.getName() + " but it is not native");
        }
        ValueType generatorType = providerAnnot.getValue("value").getJavaClass();
        String generatorClassName = ((ValueType.Object)generatorType).getClassName();
        try {
            generatorClass = Class.forName(generatorClassName, true, context.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't find metadata generator class: " + generatorClassName, e);
        }
        try {
            cons = generatorClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Metadata generator " + generatorClassName + " does not have a public " + "no-arg constructor", e);
        }
        try {
            generator = (MetadataGenerator)cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error instantiating metadata generator " + generatorClassName, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error instantiating metadata generator " + generatorClassName, e.getTargetException());
        }
        DefaultMetadataGeneratorContext metadataContext = new DefaultMetadataGeneratorContext(context.getClassSource(), context.getClassLoader(), context.getProperties(), (ServiceRepository)context);
        Resource resource = generator.generateMetadata(metadataContext, methodRef);
        writer.append("if (!window.hasOwnProperty(\"").appendMethodBody(methodRef).append("$$resource\")) {").indent().softNewLine();
        writer.appendMethodBody(methodRef).append("$$resource = ");
        ResourceWriterHelper.write(writer, resource);
        writer.append(';').softNewLine();
        writer.outdent().append('}').softNewLine();
        writer.append("return ").appendMethodBody(methodRef).append("$$resource;").softNewLine();
    }
}

