/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.codegen.SourceWriter;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.BuildTimeResourceGetter;
import org.teavm.platform.plugin.BuildTimeResourceMethod;
import org.teavm.platform.plugin.BuildTimeResourceProxy;
import org.teavm.platform.plugin.BuildTimeResourceProxyFactory;
import org.teavm.platform.plugin.BuildTimeResourceSetter;
import org.teavm.platform.plugin.BuildTimeResourceWriterMethod;
import org.teavm.platform.plugin.ResourceWriter;

class BuildTimeResourceProxyBuilder {
    private Map<Class<?>, BuildTimeResourceProxyFactory> factories = new HashMap();
    private static Set<Class<?>> allowedPropertyTypes = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Float.TYPE, Double.TYPE, String.class, ResourceArray.class, ResourceMap.class));
    private static Map<Class<?>, Object> defaultValues = new HashMap();

    BuildTimeResourceProxyBuilder() {
    }

    public BuildTimeResourceProxy buildProxy(Class<?> iface) {
        BuildTimeResourceProxyFactory factory = this.factories.get(iface);
        if (factory == null) {
            factory = this.createFactory(iface);
            this.factories.put(iface, factory);
        }
        return factory.create();
    }

    private BuildTimeResourceProxyFactory createFactory(Class<?> iface) {
        return new ProxyFactoryCreation(iface).create();
    }

    static {
        defaultValues.put(Boolean.TYPE, false);
        defaultValues.put(Byte.TYPE, (byte)0);
        defaultValues.put(Short.TYPE, (short)0);
        defaultValues.put(Integer.TYPE, 0);
        defaultValues.put(Float.TYPE, Float.valueOf(0.0f));
        defaultValues.put(Double.TYPE, 0.0);
    }

    private static class ProxyFactoryCreation {
        private Class<?> rootIface;
        Map<String, Class<?>> getters = new HashMap();
        Map<String, Class<?>> setters = new HashMap();
        Map<Method, BuildTimeResourceMethod> methods = new HashMap<Method, BuildTimeResourceMethod>();
        private Map<String, Integer> propertyIndexes = new HashMap<String, Integer>();
        private Object[] initialData;
        private Map<String, Class<?>> propertyTypes = new HashMap();

        public ProxyFactoryCreation(Class<?> iface) {
            this.rootIface = iface;
        }

        BuildTimeResourceProxyFactory create() {
            Method writeMethod;
            if (!this.rootIface.isInterface()) {
                throw new IllegalArgumentException("Error creating a new resource of type " + this.rootIface.getName() + " that is not an interface");
            }
            this.scanIface(this.rootIface);
            this.initialData = new Object[this.propertyIndexes.size()];
            for (Map.Entry<String, Class<?>> property : this.propertyTypes.entrySet()) {
                String propertyName = property.getKey();
                Class<?> propertyType = property.getValue();
                this.initialData[this.propertyIndexes.get((Object)propertyName).intValue()] = defaultValues.get(propertyType);
            }
            try {
                writeMethod = ResourceWriter.class.getMethod("write", SourceWriter.class);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError("Method must exist", e);
            }
            String[] properties = new String[this.propertyIndexes.size()];
            for (Map.Entry<String, Integer> entry : this.propertyIndexes.entrySet()) {
                properties[entry.getValue().intValue()] = entry.getKey();
            }
            this.methods.put(writeMethod, new BuildTimeResourceWriterMethod(properties));
            return new BuildTimeResourceProxyFactory(this.methods, this.initialData);
        }

        private void scanIface(Class<?> iface) {
            if (!Resource.class.isAssignableFrom(iface)) {
                throw new IllegalArgumentException("Error creating a new resource of type " + iface.getName() + ". This type does not implement the " + Resource.class.getName() + " interface");
            }
            this.getters.clear();
            this.setters.clear();
            for (Method method : iface.getDeclaredMethods()) {
                if (method.getName().startsWith("get")) {
                    this.scanGetter(method);
                    continue;
                }
                if (method.getName().startsWith("is")) {
                    this.scanBooleanGetter(method);
                    continue;
                }
                if (method.getName().startsWith("set")) {
                    this.scanSetter(method);
                    continue;
                }
                this.throwInvalidMethod(method);
            }
            for (Map.Entry<String, Class<?>> entry : this.getters.entrySet()) {
                String propertyName = entry.getKey();
                Class<?> clazz = entry.getValue();
                Class<?> setterType = this.setters.get(propertyName);
                if (setterType == null) {
                    throw new IllegalArgumentException("Property " + iface.getName() + "." + propertyName + " has a getter, but does not have a setter");
                }
                if (setterType.equals(clazz)) continue;
                throw new IllegalArgumentException("Property " + iface.getName() + "." + propertyName + " has a getter and a setter of different types");
            }
            for (String string : this.setters.keySet()) {
                if (this.getters.containsKey(string)) continue;
                throw new IllegalArgumentException("Property " + iface.getName() + "." + string + " has a setter, but does not have a getter");
            }
            for (Map.Entry entry : this.getters.entrySet()) {
                String propertyName = (String)entry.getKey();
                Class clazz = (Class)entry.getValue();
                if (!(allowedPropertyTypes.contains(clazz) || clazz.isInterface() && Resource.class.isAssignableFrom(clazz))) {
                    throw new IllegalArgumentException("Property " + this.rootIface.getName() + "." + propertyName + " has an illegal type " + clazz.getName());
                }
                if (this.propertyTypes.containsKey(propertyName)) continue;
                this.propertyTypes.put(propertyName, clazz);
            }
            for (GenericDeclaration genericDeclaration : iface.getInterfaces()) {
                this.scanIface((Class<?>)genericDeclaration);
            }
        }

        private void throwInvalidMethod(Method method) {
            throw new IllegalArgumentException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " is not likely to be either getter or setter");
        }

        private void scanGetter(Method method) {
            String propertyName = this.extractPropertyName(method.getName().substring(3));
            if (propertyName == null || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length > 0) {
                this.throwInvalidMethod(method);
            }
            if (this.getters.put(propertyName, method.getReturnType()) != null) {
                throw new IllegalArgumentException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " is a duplicate getter for property " + propertyName);
            }
            this.methods.put(method, new BuildTimeResourceGetter(this.getPropertyIndex(propertyName)));
        }

        private void scanBooleanGetter(Method method) {
            String propertyName = this.extractPropertyName(method.getName().substring(2));
            if (propertyName == null || !method.getReturnType().equals(Boolean.TYPE) || method.getParameterTypes().length > 0) {
                this.throwInvalidMethod(method);
            }
            if (this.getters.put(propertyName, method.getReturnType()) != null) {
                throw new IllegalArgumentException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " is a duplicate getter for property " + propertyName);
            }
            this.methods.put(method, new BuildTimeResourceGetter(this.getPropertyIndex(propertyName)));
        }

        private void scanSetter(Method method) {
            String propertyName = this.extractPropertyName(method.getName().substring(3));
            if (propertyName == null || !method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 1) {
                this.throwInvalidMethod(method);
            }
            if (this.setters.put(propertyName, method.getParameterTypes()[0]) != null) {
                throw new IllegalArgumentException("Method " + method.getDeclaringClass().getName() + "." + method.getName() + " is a duplicate setter for property " + propertyName);
            }
            this.methods.put(method, new BuildTimeResourceSetter(this.getPropertyIndex(propertyName)));
        }

        private String extractPropertyName(String propertyName) {
            if (propertyName.isEmpty()) {
                return null;
            }
            char c = propertyName.charAt(0);
            if (c != Character.toUpperCase(c)) {
                return null;
            }
            if (propertyName.length() == 1) {
                return propertyName.toLowerCase();
            }
            c = propertyName.charAt(1);
            if (c == Character.toUpperCase(c)) {
                return propertyName;
            }
            return Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
        }

        private int getPropertyIndex(String propertyName) {
            Integer index = this.propertyIndexes.get(propertyName);
            if (index == null) {
                index = this.propertyIndexes.size();
                this.propertyIndexes.put(propertyName, index);
            }
            return index;
        }
    }
}

