/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.teavm.common.ServiceRepository;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.platform.metadata.MetadataGeneratorContext;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StaticFieldResource;
import org.teavm.platform.plugin.BuildTimeResourceArray;
import org.teavm.platform.plugin.BuildTimeResourceMap;
import org.teavm.platform.plugin.BuildTimeResourceProxyBuilder;
import org.teavm.platform.plugin.BuildTimeStaticFieldResource;
import org.teavm.platform.plugin.ResourceTypeDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptorProvider;
import org.teavm.platform.plugin.ResourceWriter;

class DefaultMetadataGeneratorContext
implements MetadataGeneratorContext {
    private ClassReaderSource classSource;
    private ClassLoader classLoader;
    private Properties properties;
    private BuildTimeResourceProxyBuilder proxyBuilder;
    private ServiceRepository services;

    DefaultMetadataGeneratorContext(ClassReaderSource classSource, ClassLoader classLoader, Properties properties, ServiceRepository services) {
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.properties = properties;
        this.services = services;
    }

    private BuildTimeResourceProxyBuilder getProxyBuilder() {
        if (this.proxyBuilder == null) {
            this.proxyBuilder = new BuildTimeResourceProxyBuilder();
        }
        return this.proxyBuilder;
    }

    @Override
    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    @Override
    public <T extends Resource> T createResource(Class<T> resourceType) {
        return (T)((Resource)resourceType.cast(Proxy.newProxyInstance(this.classLoader, new Class[]{resourceType, ResourceWriter.class, ResourceTypeDescriptorProvider.class}, (InvocationHandler)this.getProxyBuilder().buildProxy(resourceType))));
    }

    @Override
    public ResourceTypeDescriptor getTypeDescriptor(Class<? extends Resource> type) {
        return this.getProxyBuilder().getProxyFactory(type).typeDescriptor;
    }

    @Override
    public <T extends Resource> ResourceArray<T> createResourceArray() {
        return new BuildTimeResourceArray();
    }

    @Override
    public StaticFieldResource createFieldResource(FieldReference field) {
        return new BuildTimeStaticFieldResource(field);
    }

    @Override
    public <T extends Resource> ResourceMap<T> createResourceMap() {
        return new BuildTimeResourceMap();
    }

    public <T> T getService(Class<T> type) {
        return (T)this.services.getService(type);
    }
}

