/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.ArrayList;
import java.util.List;
import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.TeaVMCHost;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.MethodContributor;
import org.teavm.backend.wasm.TeaVMWasmHost;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.dependency.DependencyListener;
import org.teavm.interop.Async;
import org.teavm.interop.PlatformMarker;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformQueue;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.plugin.AsyncDependencyListener;
import org.teavm.platform.plugin.AsyncMethodGenerator;
import org.teavm.platform.plugin.AsyncMethodProcessor;
import org.teavm.platform.plugin.ClassLookupDependencySupport;
import org.teavm.platform.plugin.EnumDependencySupport;
import org.teavm.platform.plugin.MetadataCIntrinsic;
import org.teavm.platform.plugin.MetadataIntrinsic;
import org.teavm.platform.plugin.MetadataProviderNativeGenerator;
import org.teavm.platform.plugin.MetadataProviderTransformer;
import org.teavm.platform.plugin.MetadataRegistration;
import org.teavm.platform.plugin.NewInstanceDependencySupport;
import org.teavm.platform.plugin.PlatformDependencyListener;
import org.teavm.platform.plugin.ResourceAccessorDependencyListener;
import org.teavm.platform.plugin.ResourceAccessorTransformer;
import org.teavm.platform.plugin.ResourceLowLevelTransformer;
import org.teavm.platform.plugin.ResourceReadCIntrinsic;
import org.teavm.platform.plugin.ResourceReadIntrinsic;
import org.teavm.platform.plugin.ResourceTransformer;
import org.teavm.platform.plugin.StringAmplifier;
import org.teavm.platform.plugin.StringAmplifierTransformer;
import org.teavm.vm.TeaVMPluginUtil;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

public class PlatformPlugin
implements TeaVMPlugin,
MetadataRegistration {
    private MetadataProviderTransformer metadataTransformer = new MetadataProviderTransformer();
    private List<MetadataGeneratorConsumer> metadataGeneratorConsumers = new ArrayList<MetadataGeneratorConsumer>();

    public void install(TeaVMHost host) {
        host.add((ClassHolderTransformer)this.metadataTransformer);
        if (host.getExtension(TeaVMJavaScriptHost.class) != null) {
            host.add((ClassHolderTransformer)new ResourceTransformer());
            host.add((ClassHolderTransformer)new ResourceAccessorTransformer(host));
            host.add((DependencyListener)new ResourceAccessorDependencyListener());
            TeaVMJavaScriptHost jsHost = (TeaVMJavaScriptHost)host.getExtension(TeaVMJavaScriptHost.class);
            jsHost.addGeneratorProvider(context -> {
                ClassReader cls = context.getClassSource().get(context.getMethod().getClassName());
                if (cls == null) {
                    return null;
                }
                MethodReader method = cls.getMethod(context.getMethod().getDescriptor());
                if (method == null) {
                    return null;
                }
                return method.getAnnotations().get(Async.class.getName()) != null ? new AsyncMethodGenerator() : null;
            });
            host.add((DependencyListener)new AsyncDependencyListener());
            jsHost.addVirtualMethods((MethodContributor)new AsyncMethodGenerator());
            this.metadataGeneratorConsumers.add((method, constructor, generator) -> jsHost.add(method, (Generator)new MetadataProviderNativeGenerator(generator, constructor)));
        } else if (!PlatformPlugin.isBootstrap()) {
            host.add((ClassHolderTransformer)new StringAmplifierTransformer());
        }
        if (!PlatformPlugin.isBootstrap()) {
            TeaVMCHost cHost;
            TeaVMWasmHost wasmHost = (TeaVMWasmHost)host.getExtension(TeaVMWasmHost.class);
            if (wasmHost != null) {
                host.add((ClassHolderTransformer)new ResourceLowLevelTransformer());
                this.metadataGeneratorConsumers.add((constructor, method, generator) -> wasmHost.add(ctx -> new MetadataIntrinsic(ctx.getClassSource(), ctx.getClassLoader(), ctx.getServices(), ctx.getProperties(), constructor, method, generator)));
                wasmHost.add(ctx -> new ResourceReadIntrinsic(ctx.getClassSource(), ctx.getClassLoader()));
                wasmHost.add(ctx -> new WasmIntrinsic(){

                    public boolean isApplicable(MethodReference methodReference) {
                        return methodReference.getClassName().equals(StringAmplifier.class.getName());
                    }

                    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
                        return manager.generate((Expr)invocation.getArguments().get(0));
                    }
                });
            }
            if ((cHost = (TeaVMCHost)host.getExtension(TeaVMCHost.class)) != null) {
                host.add((ClassHolderTransformer)new ResourceLowLevelTransformer());
                MetadataCIntrinsic metadataCIntrinsic = new MetadataCIntrinsic();
                cHost.addGenerator(ctx -> {
                    metadataCIntrinsic.init(ctx.getClassSource(), ctx.getClassLoader(), ctx.getServices(), ctx.getProperties());
                    return metadataCIntrinsic;
                });
                this.metadataGeneratorConsumers.add(metadataCIntrinsic::addGenerator);
                cHost.addIntrinsic(ctx -> new ResourceReadCIntrinsic(ctx.getClassSource()));
                cHost.addIntrinsic(ctx -> new Intrinsic(){

                    public boolean canHandle(MethodReference method) {
                        return method.getClassName().equals(StringAmplifier.class.getName());
                    }

                    public void apply(IntrinsicContext context, InvocationExpr invocation) {
                        context.emit((Expr)invocation.getArguments().get(0));
                    }
                });
            }
        }
        host.add((ClassHolderTransformer)new AsyncMethodProcessor(host.getExtension(TeaVMJavaScriptHost.class) == null));
        host.add((DependencyListener)new NewInstanceDependencySupport());
        host.add((DependencyListener)new ClassLookupDependencySupport());
        host.add((DependencyListener)new EnumDependencySupport());
        host.add((DependencyListener)new PlatformDependencyListener());
        TeaVMPluginUtil.handleNatives((TeaVMHost)host, Platform.class);
        TeaVMPluginUtil.handleNatives((TeaVMHost)host, PlatformQueue.class);
        host.registerService(MetadataRegistration.class, (Object)this);
    }

    @Override
    public void register(MethodReference method, MetadataGenerator generator) {
        MethodReference constructor = new MethodReference(method.getClassName(), method.getName() + "$$create", method.getSignature());
        for (MetadataGeneratorConsumer consumer : this.metadataGeneratorConsumers) {
            consumer.consume(constructor, method, generator);
        }
        this.metadataTransformer.addMetadataMethod(method);
    }

    @PlatformMarker
    private static boolean isBootstrap() {
        return false;
    }

    static interface MetadataGeneratorConsumer {
        public void consume(MethodReference var1, MethodReference var2, MetadataGenerator var3);
    }
}

