/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.impl.CompositeMethodGenerator;
import org.teavm.metaprogramming.impl.MetaprogrammingClassLoader;
import org.teavm.metaprogramming.impl.MetaprogrammingImpl;
import org.teavm.metaprogramming.impl.TopLevelVariableContext;
import org.teavm.metaprogramming.impl.ValueImpl;
import org.teavm.metaprogramming.impl.model.MethodModel;
import org.teavm.model.AccessLevel;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;

class UsageGenerator {
    private static Map<DependencyAgent, Integer> suffixGenerator = new WeakHashMap<DependencyAgent, Integer>();
    private DependencyAgent agent;
    private MethodModel model;
    private MethodDependency methodDep;
    private CallLocation location;
    private Diagnostics diagnostics;
    private Method proxyMethod;
    private MetaprogrammingClassLoader classLoader;
    private boolean annotationErrorReported;
    private MethodDependency nameDependency;

    UsageGenerator(DependencyAgent agent, MethodModel model, MethodDependency methodDep, CallLocation location, MetaprogrammingClassLoader classLoader) {
        this.agent = agent;
        this.diagnostics = agent.getDiagnostics();
        this.model = model;
        this.methodDep = methodDep;
        this.location = location;
        this.classLoader = classLoader;
    }

    void installProxyEmitter() {
        Diagnostics diagnostics = this.agent.getDiagnostics();
        try {
            this.proxyMethod = this.getJavaMethod(this.classLoader, this.model.getMetaMethod());
            this.proxyMethod.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            StringWriter stackTraceWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stackTraceWriter));
            diagnostics.error(this.location, "Error accessing proxy method {{m0}}: " + stackTraceWriter.getBuffer(), new Object[]{this.model.getMetaMethod()});
            return;
        }
        this.nameDependency = this.installAdditionalDependencies();
        if (this.model.getClassParameterIndex() >= 0) {
            int index = 1 + this.model.getClassParameterIndex();
            this.methodDep.getVariable(index).getClassValueNode().addConsumer(type -> this.emitPermutation(this.findClass(type.getName())));
        } else {
            this.emitPermutation(null);
        }
    }

    private MethodDependency installAdditionalDependencies() {
        MethodDependency nameDep = this.agent.linkMethod(new MethodReference(Class.class, "getName", new Class[]{String.class}), this.location);
        nameDep.getVariable(0).propagate(this.agent.getType(Class.class.getName()));
        nameDep.getThrown().connect(this.methodDep.getThrown());
        nameDep.use();
        MethodDependency equalsDep = this.agent.linkMethod(new MethodReference(String.class, "equals", new Class[]{Object.class, Boolean.TYPE}), this.location);
        nameDep.getResult().connect(equalsDep.getVariable(0));
        equalsDep.getVariable(1).propagate(this.agent.getType("java.lang.String"));
        equalsDep.getThrown().connect(this.methodDep.getThrown());
        equalsDep.use();
        MethodDependency hashCodeDep = this.agent.linkMethod(new MethodReference(String.class, "hashCode", new Class[]{Integer.TYPE}), this.location);
        nameDep.getResult().connect(hashCodeDep.getVariable(0));
        hashCodeDep.getThrown().connect(this.methodDep.getThrown());
        hashCodeDep.use();
        return nameDep;
    }

    private void emitPermutation(ValueType type) {
        if (!this.classLoader.isCompileTimeClass(this.model.getMetaMethod().getClassName()) && !this.annotationErrorReported) {
            this.annotationErrorReported = true;
            this.diagnostics.error(this.location, "Metaprogramming method should be within class marked with {{c0}} annotation", new Object[]{CompileTime.class.getName()});
            return;
        }
        MethodReference implRef = this.model.getUsages().get(type);
        if (implRef != null) {
            return;
        }
        implRef = this.buildMethodReference();
        this.model.getUsages().put(type, implRef);
        MetaprogrammingImpl.templateMethod = this.model.getMetaMethod();
        TopLevelVariableContext varContext = new TopLevelVariableContext(this.diagnostics);
        MetaprogrammingImpl.generator = new CompositeMethodGenerator(varContext);
        MetaprogrammingImpl.varContext = varContext;
        MetaprogrammingImpl.returnType = this.model.getMethod().getReturnType();
        MetaprogrammingImpl.generator.location = this.location != null ? this.location.getSourceLocation() : null;
        for (int i = 0; i <= this.model.getMetaParameterCount(); ++i) {
            MetaprogrammingImpl.generator.getProgram().createVariable();
        }
        Object[] proxyArgs = new Object[this.model.getMetaParameterCount()];
        for (int i = 0; i < proxyArgs.length; ++i) {
            proxyArgs[i] = i == this.model.getMetaClassParameterIndex() ? MetaprogrammingImpl.findClass(type) : new ValueImpl(this.getParameterVar(i), MetaprogrammingImpl.varContext, this.model.getMetaParameterType(i));
        }
        try {
            this.proxyMethod.invoke(null, proxyArgs);
            MetaprogrammingImpl.close();
            Program program = MetaprogrammingImpl.generator.getProgram();
            ClassHolder cls = new ClassHolder(implRef.getClassName());
            cls.setLevel(AccessLevel.PUBLIC);
            cls.setParent("java.lang.Object");
            MethodHolder method = new MethodHolder(implRef.getDescriptor());
            method.setLevel(AccessLevel.PUBLIC);
            method.getModifiers().add(ElementModifier.STATIC);
            method.setProgram(program);
            cls.addMethod(method);
            this.agent.submitClass(cls);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.diagnostics.error(this.location, "Error calling proxy method {{m0}}: " + writer.toString(), new Object[]{this.model.getMetaMethod()});
        }
        MethodDependency implMethod = this.agent.linkMethod(implRef, this.location);
        for (int i = 0; i < implRef.parameterCount(); ++i) {
            this.methodDep.getVariable(i + 1).connect(implMethod.getVariable(i + 1));
        }
        if (this.model.getClassParameterIndex() >= 0) {
            implMethod.getVariable(this.model.getClassParameterIndex() + 1).getClassValueNode().connect(this.nameDependency.getVariable(0));
        }
        if (implMethod.getResult() != null) {
            implMethod.getResult().connect(this.methodDep.getResult());
        }
        implMethod.getThrown().connect(this.methodDep.getThrown());
        implMethod.use();
        this.agent.linkClass(implRef.getClassName(), this.location);
    }

    private ValueType findClass(String name) {
        if (name.startsWith("[")) {
            ValueType type = ValueType.parseIfPossible((String)name);
            if (type != null) {
                return type;
            }
            int degree = 0;
            while (name.charAt(degree) == '[') {
                ++degree;
            }
            type = ValueType.object((String)name.substring(degree));
            while (degree-- > 0) {
                type = ValueType.arrayOf((ValueType)type);
            }
            return type;
        }
        return ValueType.object((String)name);
    }

    private MethodReference buildMethodReference() {
        if (this.model.getClassParameterIndex() < 0) {
            return new MethodReference(this.model.getMethod().getClassName() + "$PROXY$" + this.getSuffix(), this.model.getMethod().getDescriptor());
        }
        ValueType[] signature = new ValueType[this.model.getMetaParameterCount() + 1];
        for (int i = 0; i < signature.length - 1; ++i) {
            signature[i] = this.model.getMetaParameterType(i);
        }
        signature[i] = this.model.getMethod().getReturnType();
        return new MethodReference(this.model.getMethod().getClassName() + "$PROXY$" + this.getSuffix(), this.model.getMethod().getName(), signature);
    }

    private int getSuffix() {
        int suffix = suffixGenerator.getOrDefault(this.agent, 0);
        suffixGenerator.put(this.agent, suffix + 1);
        return suffix;
    }

    private Method getJavaMethod(ClassLoader classLoader, MethodReference ref) throws ReflectiveOperationException {
        Class<?> cls = Class.forName(ref.getClassName(), true, classLoader);
        Class[] parameterTypes = new Class[ref.parameterCount()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.getJavaType(classLoader, ref.parameterType(i));
        }
        return cls.getDeclaredMethod(ref.getName(), parameterTypes);
    }

    private Class<?> getJavaType(ClassLoader classLoader, ValueType type) throws ReflectiveOperationException {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case BYTE: {
                    return Byte.TYPE;
                }
                case SHORT: {
                    return Short.TYPE;
                }
                case CHARACTER: {
                    return Character.TYPE;
                }
                case INTEGER: {
                    return Integer.TYPE;
                }
                case LONG: {
                    return Long.TYPE;
                }
                case FLOAT: {
                    return Float.TYPE;
                }
                case DOUBLE: {
                    return Double.TYPE;
                }
            }
        } else {
            if (type instanceof ValueType.Array) {
                Class<?> componentType = this.getJavaType(classLoader, ((ValueType.Array)type).getItemType());
                return Array.newInstance(componentType, 0).getClass();
            }
            if (type instanceof ValueType.Object) {
                String className = ((ValueType.Object)type).getClassName();
                return Class.forName(className, true, classLoader);
            }
            if (type instanceof ValueType.Void) {
                return Void.TYPE;
            }
        }
        throw new AssertionError((Object)("Don't know how to map type: " + type));
    }

    private Variable getParameterVar(int index) {
        Program program = MetaprogrammingImpl.generator.getProgram();
        Variable var = program.variableAt(index + 1);
        ValueType type = this.model.getMethod().parameterType(index);
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    var = this.box(var, Boolean.class, Boolean.TYPE);
                    break;
                }
                case BYTE: {
                    var = this.box(var, Byte.class, Byte.TYPE);
                    break;
                }
                case SHORT: {
                    var = this.box(var, Short.class, Short.TYPE);
                    break;
                }
                case CHARACTER: {
                    var = this.box(var, Character.class, Character.TYPE);
                    break;
                }
                case INTEGER: {
                    var = this.box(var, Integer.class, Integer.TYPE);
                    break;
                }
                case LONG: {
                    var = this.box(var, Long.class, Long.TYPE);
                    break;
                }
                case FLOAT: {
                    var = this.box(var, Float.class, Float.TYPE);
                    break;
                }
                case DOUBLE: {
                    var = this.box(var, Double.class, Double.TYPE);
                }
            }
        }
        return var;
    }

    private Variable box(Variable var, Class<?> boxed, Class<?> primitive) {
        Program program = MetaprogrammingImpl.generator.getProgram();
        BasicBlock block = program.basicBlockAt(0);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(boxed, "valueOf", new Class[]{primitive, boxed}));
        insn.getArguments().add(var);
        var = program.createVariable();
        insn.setReceiver(var);
        block.add((Instruction)insn);
        return var;
    }
}

