/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.teavm.metaprogramming.impl.reflect.AnnotationProxy;
import org.teavm.metaprogramming.impl.reflect.ReflectContext;
import org.teavm.metaprogramming.reflect.ReflectAnnotatedElement;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationReader;

public class ReflectAnnotatedElementImpl
implements ReflectAnnotatedElement {
    private ReflectContext context;
    private AnnotationContainerReader annotationContainer;
    private Map<Class<?>, Annotation> annotations = new HashMap();

    public ReflectAnnotatedElementImpl(ReflectContext context, AnnotationContainerReader annotationContainer) {
        this.context = context;
        this.annotationContainer = annotationContainer;
    }

    public <S extends Annotation> S getAnnotation(Class<S> type) {
        Annotation result = this.annotations.computeIfAbsent(type, t -> {
            if (this.annotationContainer == null) {
                return null;
            }
            AnnotationReader annot = this.annotationContainer.get(t.getName());
            if (annot == null) {
                return null;
            }
            AnnotationProxy handler = new AnnotationProxy(this.context.getClassLoader(), this.context.getClassSource(), annot, (Class<?>)t);
            return (Annotation)Proxy.newProxyInstance(this.context.getClassLoader(), new Class[]{t}, (InvocationHandler)handler);
        });
        return (S)result;
    }
}

