/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.metaprogramming.impl.model;

import java.util.HashMap;
import java.util.Map;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.ReflectClass;
import org.teavm.metaprogramming.Value;
import org.teavm.metaprogramming.impl.model.MethodModel;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class MethodDescriber {
    private Diagnostics diagnostics;
    private ClassReaderSource classSource;
    private Map<MethodReference, MethodModel> cache = new HashMap<MethodReference, MethodModel>();

    public MethodDescriber(Diagnostics diagnostics, ClassReaderSource classSource) {
        this.diagnostics = diagnostics;
        this.classSource = classSource;
    }

    public MethodModel getMethod(MethodReference method) {
        return this.cache.computeIfAbsent(method, this::describeMethod);
    }

    public MethodModel getKnownMethod(MethodReference method) {
        return this.cache.get(method);
    }

    public Iterable<MethodModel> getKnownMethods() {
        return this.cache.values();
    }

    private MethodModel describeMethod(MethodReference methodRef) {
        MethodReader method = this.classSource.resolve(methodRef);
        if (method == null) {
            return null;
        }
        if (method.getAnnotations().get(Meta.class.getName()) == null) {
            return null;
        }
        CallLocation location = new CallLocation(methodRef);
        MethodModel proxyMethod = this.findMetaMethod(method);
        if (proxyMethod == null) {
            this.diagnostics.error(location, "Corresponding meta method was not found", new Object[0]);
            return null;
        }
        return proxyMethod;
    }

    private MethodModel findMetaMethod(MethodReader method) {
        ClassReader cls = this.classSource.get(method.getOwnerName());
        boolean isStatic = method.hasModifier(ElementModifier.STATIC);
        int expectedParameterCount = (isStatic ? 0 : 1) + method.parameterCount();
        for (MethodReader meta : cls.getMethods()) {
            if (meta == method || !meta.hasModifier(ElementModifier.STATIC) || !meta.getName().equals(method.getName()) || meta.getResultType() != ValueType.VOID || meta.parameterCount() != expectedParameterCount) continue;
            int paramOffset = 0;
            if (!isStatic) {
                if (meta.parameterCount() == 0 || meta.parameterType(0).isObject(Value.class)) {
                    return null;
                }
                ++paramOffset;
            }
            int classParamIndex = -1;
            for (int i = 0; i < method.parameterCount(); ++i) {
                ValueType proxyParam = meta.parameterType(i + paramOffset);
                if (proxyParam.isObject(ReflectClass.class)) {
                    if (classParamIndex == -1) {
                        classParamIndex = i;
                        continue;
                    }
                    return null;
                }
                if (proxyParam.isObject(Value.class)) continue;
                return null;
            }
            return new MethodModel(method.getReference(), meta.getReference(), classParamIndex, isStatic);
        }
        return null;
    }
}

