/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.teavm.maven.AbstractJavascriptMojo;
import org.teavm.testing.JUnitTestAdapter;
import org.teavm.testing.TestAdapter;
import org.teavm.tooling.BaseTeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.sources.DirectorySourceFileProvider;
import org.teavm.tooling.sources.SourceFileProvider;
import org.teavm.tooling.testing.TeaVMTestTool;
import org.teavm.tooling.testing.TestPlan;

@Mojo(name="testCompile", requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class BuildJavascriptTestMojo
extends AbstractJavascriptMojo {
    private static Set<String> testScopes = new HashSet<String>(Arrays.asList("compile", "test", "system", "runtime", "provided"));
    @Parameter(defaultValue="${project.build.directory}/javascript-test")
    private File targetDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testFiles;
    @Parameter
    private String[] wildcards = new String[]{"**.*Test", "**.*UnitTest"};
    @Parameter
    private String[] excludeWildcards = new String[0];
    @Parameter
    private boolean scanDependencies;
    @Parameter
    private int numThreads = 1;
    @Parameter
    private String adapterClass = JUnitTestAdapter.class.getName();
    @Parameter
    private String[] additionalScripts;
    private TeaVMTestTool tool = new TeaVMTestTool();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (System.getProperty("maven.test.skip", "false").equals("true") || System.getProperty("skipTests") != null) {
            this.getLog().info((CharSequence)"Tests build skipped as specified by system property");
            return;
        }
        this.setupTool((BaseTeaVMTool)this.tool);
        try {
            if (!this.testFiles.isDirectory()) {
                throw new MojoFailureException("Directory with tests doesn't exist: " + this.testFiles);
            }
            this.getLog().info((CharSequence)("Searching for tests in the directory `" + this.testFiles.getAbsolutePath() + "'"));
            this.tool.setAdapter(this.createAdapter(this.classLoader));
            this.findTestClasses(this.classLoader, this.testFiles, "");
            if (this.scanDependencies) {
                this.findTestsInDependencies(this.classLoader);
            }
            this.tool.setNumThreads(this.numThreads);
            if (this.additionalScripts != null) {
                this.tool.getAdditionalScripts().addAll(Arrays.asList(this.additionalScripts));
            }
            this.writePlan(this.tool.generate());
        }
        catch (TeaVMToolException e) {
            throw new MojoFailureException("Error occurred generating JavaScript files", (Throwable)e);
        }
    }

    private void writePlan(TestPlan plan) throws MojoExecutionException {
        File file = new File(this.targetDirectory, "plan.json");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue((Writer)writer, (Object)plan);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing test plan", (Exception)e);
        }
    }

    private TestAdapter createAdapter(ClassLoader classLoader) throws MojoExecutionException {
        Constructor<TestAdapter> cons;
        Class<?> adapterClsRaw;
        try {
            adapterClsRaw = Class.forName(this.adapterClass, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Adapter not found: " + this.adapterClass, (Exception)e);
        }
        if (!TestAdapter.class.isAssignableFrom(adapterClsRaw)) {
            throw new MojoExecutionException("Adapter " + this.adapterClass + " does not implement " + TestAdapter.class.getName());
        }
        Class<TestAdapter> adapterCls = adapterClsRaw.asSubclass(TestAdapter.class);
        try {
            cons = adapterCls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("No default constructor found for test adapter " + this.adapterClass, (Exception)e);
        }
        try {
            return cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MojoExecutionException("Error creating test adapter", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Error creating test adapter", e.getTargetException());
        }
    }

    private void findTestsInDependencies(ClassLoader classLoader) throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Scanning dependencies for tests");
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!testScopes.contains(artifact.getScope())) continue;
                File file = artifact.getFile();
                if (file.isDirectory()) {
                    this.findTestClasses(classLoader, file, "");
                    continue;
                }
                if (!file.getName().endsWith(".jar")) continue;
                this.findTestClassesInJar(classLoader, new JarFile(file));
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error gathering classpath information", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error scanning dependencies for tests", (Exception)e);
        }
    }

    private void findTestClasses(ClassLoader classLoader, File folder, String prefix) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                String newPrefix = prefix.isEmpty() ? file.getName() : prefix + "." + file.getName();
                this.findTestClasses(classLoader, file, newPrefix);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = file.getName().substring(0, file.getName().length() - ".class".length());
            if (!prefix.isEmpty()) {
                className = prefix + "." + className;
            }
            this.addCandidate(classLoader, className);
        }
    }

    private void findTestClassesInJar(ClassLoader classLoader, JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String className = entry.getName().substring(0, entry.getName().length() - ".class".length()).replace('/', '.');
            this.addCandidate(classLoader, className);
        }
    }

    private void addCandidate(ClassLoader classLoader, String className) {
        boolean matches = false;
        String simpleName = className.replace('.', '/');
        for (String wildcard : this.wildcards) {
            if (!FilenameUtils.wildcardMatch((String)simpleName, (String)wildcard.replace('.', '/'))) continue;
            matches = true;
            break;
        }
        if (!matches) {
            return;
        }
        for (String wildcard : this.excludeWildcards) {
            if (!FilenameUtils.wildcardMatch((String)simpleName, (String)wildcard.replace('.', '/'))) continue;
            return;
        }
        try {
            Class<?> candidate = Class.forName(className, true, classLoader);
            if (this.tool.getAdapter().acceptClass(candidate)) {
                this.tool.getTestClasses().add(candidate.getName());
                this.getLog().info((CharSequence)("Test class detected: " + candidate.getName()));
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().info((CharSequence)("Could not load class `" + className + "' to search for tests"));
        }
    }

    @Override
    protected File getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    protected List<File> getAdditionalClassPath() {
        return Arrays.asList(this.testFiles);
    }

    @Override
    protected boolean isSupportedScope(String scope) {
        return testScopes.contains(scope);
    }

    @Override
    protected void addSourceProviders(List<SourceFileProvider> providers) {
        providers.add((SourceFileProvider)new DirectorySourceFileProvider(this.sourceDirectory));
        providers.add((SourceFileProvider)new DirectorySourceFileProvider(this.testSourceDirectory));
    }
}

