/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.teavm.maven.TestStatus;
import org.teavm.model.MethodReference;

public class TestResult {
    private MethodReference method;
    private TestStatus status;
    private String exception;
    private String stack;

    @JsonCreator
    TestResult(@JsonProperty(value="method") MethodReference method, @JsonProperty(value="status") TestStatus status, @JsonInclude(value=JsonInclude.Include.NON_NULL) @JsonProperty(value="exception") String exception, @JsonInclude(value=JsonInclude.Include.NON_NULL) @JsonProperty(value="stack") String stack) {
        this.method = method;
        this.status = status;
        this.exception = exception;
        this.stack = stack;
    }

    public static TestResult passed(MethodReference method) {
        return new TestResult(method, TestStatus.PASSED, null, null);
    }

    public static TestResult exceptionNotThrown(MethodReference method) {
        return new TestResult(method, TestStatus.EXCEPTION_NOT_THROWN, null, null);
    }

    public static TestResult error(MethodReference method, String exception, String stack) {
        return new TestResult(method, TestStatus.ERROR, exception, stack);
    }

    @JsonGetter
    public MethodReference getMethod() {
        return this.method;
    }

    @JsonGetter
    public TestStatus getStatus() {
        return this.status;
    }

    @JsonGetter
    public String getException() {
        return this.exception;
    }

    @JsonGetter
    public String getStack() {
        return this.stack;
    }
}

