/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.logging.Log;
import org.teavm.maven.TestReport;
import org.teavm.maven.TestResult;
import org.teavm.maven.TestRunStrategy;
import org.teavm.model.MethodReference;
import org.teavm.tooling.testing.TestCase;
import org.teavm.tooling.testing.TestGroup;
import org.teavm.tooling.testing.TestPlan;

public class TestRunner {
    private int numThreads = 1;
    private TestRunStrategy strategy;
    private BlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue<Runnable>();
    private CountDownLatch latch;
    private volatile boolean stopped;
    private Log log;
    private List<TestResult> report = new CopyOnWriteArrayList<TestResult>();
    private ThreadLocal<List<TestResult>> localReport = new ThreadLocal();

    public TestRunner(TestRunStrategy strategy) {
        this.strategy = strategy;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void run(TestPlan testPlan) {
        this.init();
        for (TestGroup group : testPlan.getGroups()) {
            for (TestCase testCase : group.getTestCases()) {
                this.run(testPlan.getRuntimeScript(), testCase);
            }
        }
        this.stop();
        this.waitForCompletion();
    }

    private void init() {
        this.latch = new CountDownLatch(this.numThreads);
        for (int i = 0; i < this.numThreads; ++i) {
            new Thread(() -> {
                this.strategy.beforeThread();
                this.localReport.set(new ArrayList());
                while (!this.stopped || !this.taskQueue.isEmpty()) {
                    Runnable task;
                    try {
                        task = this.taskQueue.poll(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (task == null) continue;
                    task.run();
                }
                this.report.addAll((Collection<TestResult>)this.localReport.get());
                this.localReport.remove();
                this.strategy.afterThread();
                this.latch.countDown();
            }).start();
        }
    }

    private void addTask(Runnable runnable) {
        this.taskQueue.add(runnable);
    }

    private void stop() {
        this.stopped = true;
    }

    private void waitForCompletion() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void run(String runtimeScript, TestCase testCase) {
        this.addTask(() -> this.runImpl(runtimeScript, testCase));
    }

    private void runImpl(String runtimeScript, TestCase testCase) {
        MethodReference ref = MethodReference.parse((String)testCase.getTestMethod());
        try {
            String status;
            String result = this.strategy.runTest(this.log, runtimeScript, testCase);
            if (result == null) {
                this.log.info((CharSequence)("Test failed: " + testCase.getTestMethod()));
                this.localReport.get().add(TestResult.error(ref, null, null));
                return;
            }
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode resultObject = (ObjectNode)mapper.readTree(result);
            switch (status = resultObject.get("status").asText()) {
                case "ok": {
                    if (testCase.getExpectedExceptions().isEmpty()) {
                        this.log.info((CharSequence)("Test passed: " + testCase.getTestMethod()));
                        this.localReport.get().add(TestResult.passed(ref));
                        break;
                    }
                    this.log.info((CharSequence)("Test failed: " + testCase.getTestMethod()));
                    this.localReport.get().add(TestResult.exceptionNotThrown(ref));
                    break;
                }
                case "exception": {
                    String stack = resultObject.get("stack").asText();
                    String exception = resultObject.get("exception").asText();
                    if (!testCase.getExpectedExceptions().contains(exception)) {
                        this.log.info((CharSequence)("Test failed: " + testCase.getTestMethod()));
                        this.localReport.get().add(TestResult.error(ref, exception, stack));
                        break;
                    }
                    this.log.info((CharSequence)("Test passed: " + testCase.getTestMethod()));
                    this.localReport.get().add(TestResult.passed(ref));
                    break;
                }
            }
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
    }

    public TestReport getReport() {
        TestReport report = new TestReport();
        report.getResults().addAll(this.report);
        return report;
    }
}

