/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.teavm.maven.HtmlUnitRunStrategy;
import org.teavm.maven.SeleniumRunStrategy;
import org.teavm.maven.TestReport;
import org.teavm.maven.TestResult;
import org.teavm.maven.TestRunStrategy;
import org.teavm.maven.TestRunner;
import org.teavm.maven.TestStatus;
import org.teavm.tooling.testing.TestPlan;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST)
public class RunTestsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/javascript-test")
    private File testDirectory;
    @Parameter(defaultValue="${project.build.directory}/teavm-test-report.json")
    private File reportFile;
    @Parameter
    private String seleniumURL;
    @Parameter
    private int numThreads = 1;
    @Parameter
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TestPlan plan;
        if (this.skip) {
            this.getLog().info((CharSequence)"Tests run skipped as specified by skip property");
            return;
        }
        if (System.getProperty("maven.test.skip", "false").equals("true") || System.getProperty("skipTests") != null) {
            this.getLog().info((CharSequence)"Tests run skipped as specified by system property");
            return;
        }
        TestRunner runner = new TestRunner(this.pickStrategy());
        runner.setLog(this.getLog());
        runner.setNumThreads(this.numThreads);
        ObjectMapper mapper = new ObjectMapper();
        File file = new File(this.testDirectory, "plan.json");
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
            plan = (TestPlan)mapper.readValue((Reader)reader, TestPlan.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading test plan", (Exception)e);
        }
        runner.run(plan);
        this.processReport(runner.getReport());
    }

    private TestRunStrategy pickStrategy() throws MojoFailureException {
        if (this.seleniumURL != null) {
            try {
                return new SeleniumRunStrategy(new URL(this.seleniumURL), this.testDirectory);
            }
            catch (MalformedURLException e) {
                throw new MojoFailureException("Can't parse URL: " + this.seleniumURL, (Throwable)e);
            }
        }
        return new HtmlUnitRunStrategy(this.testDirectory);
    }

    private void processReport(TestReport report) throws MojoExecutionException, MojoFailureException {
        if (report.getResults().isEmpty()) {
            this.getLog().info((CharSequence)"No tests ran");
            return;
        }
        int failedTests = 0;
        for (TestResult result : report.getResults()) {
            if (result.getStatus() == TestStatus.PASSED) continue;
            ++failedTests;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.reportFile), "UTF-8");){
            mapper.writeValue((Writer)writer, (Object)report);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing test report", (Throwable)e);
        }
        if (failedTests > 0) {
            throw new MojoExecutionException(failedTests + " of " + report.getResults().size() + " test(s) failed");
        }
        this.getLog().info((CharSequence)("All of " + report.getResults().size() + " tests successfully passed"));
    }
}

