/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

class TestExceptionDependency
extends AbstractDependencyListener {
    private MethodReference getMessageRef = new MethodReference("java.lang.Throwable", "getMessage", new ValueType[]{ValueType.object((String)"java.lang.String")});
    private DependencyNode allClasses;

    TestExceptionDependency() {
    }

    public void started(DependencyAgent agent) {
        this.allClasses = agent.createNode();
    }

    public void classReached(DependencyAgent agent, String className, CallLocation location) {
        if (this.isException(agent.getClassSource(), className)) {
            this.allClasses.propagate(agent.getType(className));
        }
    }

    private boolean isException(ClassReaderSource classSource, String className) {
        while (className != null) {
            if (className.equals("java.lang.Throwable")) {
                return true;
            }
            ClassReader cls = classSource.get(className);
            if (cls == null) {
                return false;
            }
            className = cls.getParent();
        }
        return false;
    }

    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        if (method.getReference().equals((Object)this.getMessageRef)) {
            this.allClasses.connect(method.getVariable(0));
        }
    }
}

