/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.teavm.maven.MavenSourceFileProviderLookup;
import org.teavm.maven.MavenTeaVMToolLog;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.tooling.ClassAlias;
import org.teavm.tooling.MethodAlias;
import org.teavm.tooling.RuntimeCopyOperation;
import org.teavm.tooling.SourceFileProvider;
import org.teavm.tooling.TeaVMTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;

@Mojo(name="build-javascript", requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class BuildJavascriptMojo
extends AbstractMojo {
    private static Set<String> compileScopes = new HashSet<String>(Arrays.asList("compile", "provided", "system"));
    @Component
    private MavenProject project;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    private MavenArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<MavenArtifactRepository> remoteRepositories;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.directory}/javascript")
    private File targetDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classFiles;
    @Parameter
    private String targetFileName = "classes.js";
    @Parameter
    private boolean minifying = true;
    @Parameter
    private String mainClass;
    @Parameter
    private RuntimeCopyOperation runtime = RuntimeCopyOperation.SEPARATE;
    @Parameter
    private Properties properties;
    @Parameter
    private boolean mainPageIncluded;
    @Parameter
    private boolean bytecodeLogging;
    @Parameter
    private boolean debugInformationGenerated;
    @Parameter
    private boolean sourceMapsGenerated;
    @Parameter
    private boolean sourceFilesCopied;
    @Parameter
    private boolean incremental;
    @Parameter(defaultValue="${project.build.directory}/teavm-cache")
    private File cacheDirectory;
    @Parameter
    private String[] transformers;
    @Parameter
    private ClassAlias[] classAliases;
    @Parameter
    private MethodAlias[] methodAliases;
    @Parameter
    private boolean stopOnErrors = true;
    private TeaVMTool tool = new TeaVMTool();

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public void setClassFiles(File classFiles) {
        this.classFiles = classFiles;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public void setBytecodeLogging(boolean bytecodeLogging) {
        this.bytecodeLogging = bytecodeLogging;
    }

    public void setRuntimeCopy(RuntimeCopyOperation runtimeCopy) {
        this.runtime = runtimeCopy;
    }

    public void setMainPageIncluded(boolean mainPageIncluded) {
        this.mainPageIncluded = mainPageIncluded;
    }

    public String[] getTransformers() {
        return this.transformers;
    }

    public void setTransformers(String[] transformers) {
        this.transformers = transformers;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setClassAliases(ClassAlias[] classAliases) {
        this.classAliases = classAliases;
    }

    public void setMethodAliases(MethodAlias[] methodAliases) {
        this.methodAliases = methodAliases;
    }

    public boolean isDebugInformationGenerated() {
        return this.debugInformationGenerated;
    }

    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    public boolean isSourceMapsGenerated() {
        return this.sourceMapsGenerated;
    }

    public void setSourceMapsGenerated(boolean sourceMapsGenerated) {
        this.sourceMapsGenerated = sourceMapsGenerated;
    }

    public boolean isSourceFilesCopied() {
        return this.sourceFilesCopied;
    }

    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public void setStopOnErrors(boolean stopOnErrors) {
        this.stopOnErrors = stopOnErrors;
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        this.tool.setLog((TeaVMToolLog)new MavenTeaVMToolLog(log));
        try {
            ClassLoader classLoader = this.prepareClassLoader();
            this.tool.setClassLoader(classLoader);
            this.tool.setBytecodeLogging(this.bytecodeLogging);
            this.tool.setMainClass(this.mainClass);
            this.tool.setMainPageIncluded(this.mainPageIncluded);
            this.tool.setMinifying(this.minifying);
            this.tool.setRuntime(this.runtime);
            this.tool.setTargetDirectory(this.targetDirectory);
            this.tool.setTargetFileName(this.targetFileName);
            this.tool.getTransformers().addAll(this.instantiateTransformers(classLoader));
            if (this.sourceFilesCopied) {
                MavenSourceFileProviderLookup lookup = new MavenSourceFileProviderLookup();
                lookup.setMavenProject(this.project);
                lookup.setRepositorySystem(this.repositorySystem);
                lookup.setLocalRepository((ArtifactRepository)this.localRepository);
                lookup.setRemoteRepositories(this.remoteRepositories);
                lookup.setPluginDependencies(this.pluginArtifacts);
                for (SourceFileProvider provider : lookup.resolve()) {
                    this.tool.addSourceFileProvider(provider);
                }
            }
            if (this.classAliases != null) {
                this.tool.getClassAliases().addAll(Arrays.asList(this.classAliases));
            }
            if (this.methodAliases != null) {
                this.tool.getMethodAliases().addAll(Arrays.asList(this.methodAliases));
            }
            if (this.properties != null) {
                this.tool.getProperties().putAll((Map<?, ?>)this.properties);
            }
            this.tool.setCacheDirectory(this.cacheDirectory);
            this.tool.setIncremental(this.incremental);
            this.tool.setDebugInformationGenerated(this.debugInformationGenerated);
            this.tool.setSourceMapsFileGenerated(this.sourceMapsGenerated);
            this.tool.setSourceFilesCopied(this.sourceFilesCopied);
            this.tool.generate();
            if (this.stopOnErrors && !this.tool.getProblemProvider().getSevereProblems().isEmpty()) {
                throw new MojoExecutionException("Build error");
            }
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Unexpected error occured", (Exception)e);
        }
        catch (TeaVMToolException e) {
            throw new MojoExecutionException("IO error occured", (Exception)((Object)e));
        }
    }

    private List<ClassHolderTransformer> instantiateTransformers(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<ClassHolderTransformer> transformerInstances = new ArrayList<ClassHolderTransformer>();
        if (this.transformers == null) {
            return transformerInstances;
        }
        for (String transformerName : this.transformers) {
            Constructor<ClassHolderTransformer> ctor;
            Class<?> transformerRawType;
            try {
                transformerRawType = Class.forName(transformerName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Transformer not found: " + transformerName, (Exception)e);
            }
            if (!ClassHolderTransformer.class.isAssignableFrom(transformerRawType)) {
                throw new MojoExecutionException("Transformer " + transformerName + " is not subtype of " + ClassHolderTransformer.class.getName());
            }
            Class<ClassHolderTransformer> transformerType = transformerRawType.asSubclass(ClassHolderTransformer.class);
            try {
                ctor = transformerType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new MojoExecutionException("Transformer " + transformerName + " has no default constructor");
            }
            try {
                ClassHolderTransformer transformer = ctor.newInstance(new Object[0]);
                transformerInstances.add(transformer);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new MojoExecutionException("Error instantiating transformer " + transformerName, (Exception)e);
            }
        }
        return transformerInstances;
    }

    private ClassLoader prepareClassLoader() throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Preparing classpath for JavaScript generation");
            ArrayList<URL> urls = new ArrayList<URL>();
            StringBuilder classpath = new StringBuilder();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!compileScopes.contains(artifact.getScope())) continue;
                File file = artifact.getFile();
                if (classpath.length() > 0) {
                    classpath.append(':');
                }
                classpath.append(file.getPath());
                urls.add(file.toURI().toURL());
            }
            if (classpath.length() > 0) {
                classpath.append(':');
            }
            classpath.append(this.classFiles.getPath());
            urls.add(this.classFiles.toURI().toURL());
            log.info((CharSequence)("Using the following classpath for JavaScript generation: " + classpath));
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), BuildJavascriptMojo.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error gathering classpath information", (Exception)e);
        }
    }
}

