/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.teavm.maven.MavenSourceFileProviderLookup;
import org.teavm.maven.MavenTeaVMToolLog;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.testing.JUnitTestAdapter;
import org.teavm.testing.TestAdapter;
import org.teavm.tooling.SourceFileProvider;
import org.teavm.tooling.TeaVMTestTool;
import org.teavm.tooling.TeaVMToolException;
import org.teavm.tooling.TeaVMToolLog;

@Mojo(name="build-test-javascript", requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class BuildJavascriptTestMojo
extends AbstractMojo {
    private static Set<String> testScopes = new HashSet<String>(Arrays.asList("compile", "test", "system", "runtime", "provided"));
    @Component
    private MavenProject project;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(required=true, readonly=true, defaultValue="${localRepository}")
    private MavenArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<MavenArtifactRepository> remoteRepositories;
    @Parameter(readonly=true, defaultValue="${plugin.artifacts}")
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.directory}/javascript-test")
    private File outputDir;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classFiles;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testFiles;
    @Parameter
    private String[] wildcards = new String[]{"**.*Test", "**.*UnitTest"};
    @Parameter
    private boolean minifying = true;
    @Parameter
    private boolean scanDependencies;
    @Parameter
    private int numThreads = 1;
    @Parameter
    private String adapterClass = JUnitTestAdapter.class.getName();
    @Parameter
    private String[] transformers;
    @Parameter
    private String[] additionalScripts;
    @Parameter
    private Properties properties;
    @Parameter
    private boolean incremental;
    @Parameter
    private boolean debugInformationGenerated;
    @Parameter
    private boolean sourceMapsGenerated;
    @Parameter
    private boolean sourceFilesCopied;
    private TeaVMTestTool tool = new TeaVMTestTool();

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setClassFiles(File classFiles) {
        this.classFiles = classFiles;
    }

    public void setTestFiles(File testFiles) {
        this.testFiles = testFiles;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setAdapterClass(String adapterClass) {
        this.adapterClass = adapterClass;
    }

    public void setWildcards(String[] wildcards) {
        this.wildcards = wildcards;
    }

    public String[] getTransformers() {
        return this.transformers;
    }

    public void setTransformers(String[] transformers) {
        this.transformers = transformers;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean isDebugInformationGenerated() {
        return this.debugInformationGenerated;
    }

    public void setDebugInformationGenerated(boolean debugInformationGenerated) {
        this.debugInformationGenerated = debugInformationGenerated;
    }

    public boolean isSourceMapsGenerated() {
        return this.sourceMapsGenerated;
    }

    public void setSourceMapsGenerated(boolean sourceMapsGenerated) {
        this.sourceMapsGenerated = sourceMapsGenerated;
    }

    public boolean isSourceFilesCopied() {
        return this.sourceFilesCopied;
    }

    public void setSourceFilesCopied(boolean sourceFilesCopied) {
        this.sourceFilesCopied = sourceFilesCopied;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (System.getProperty("maven.test.skip", "false").equals("true") || System.getProperty("skipTests") != null) {
            this.getLog().info((CharSequence)"Tests build skipped as specified by system property");
            return;
        }
        try {
            ClassLoader classLoader = this.prepareClassLoader();
            this.getLog().info((CharSequence)("Searching for tests in the directory `" + this.testFiles.getAbsolutePath() + "'"));
            this.tool.setClassLoader(classLoader);
            this.tool.setAdapter(this.createAdapter(classLoader));
            this.findTestClasses(classLoader, this.testFiles, "");
            if (this.scanDependencies) {
                this.findTestsInDependencies(classLoader);
            }
            this.tool.getTransformers().addAll(this.instantiateTransformers(classLoader));
            this.tool.setLog((TeaVMToolLog)new MavenTeaVMToolLog(this.getLog()));
            this.tool.setOutputDir(this.outputDir);
            this.tool.setNumThreads(this.numThreads);
            this.tool.setMinifying(this.minifying);
            this.tool.setIncremental(this.incremental);
            this.tool.setDebugInformationGenerated(this.debugInformationGenerated);
            this.tool.setSourceMapsGenerated(this.sourceMapsGenerated);
            this.tool.setSourceFilesCopied(this.sourceFilesCopied);
            if (this.sourceFilesCopied) {
                MavenSourceFileProviderLookup lookup = new MavenSourceFileProviderLookup();
                lookup.setMavenProject(this.project);
                lookup.setRepositorySystem(this.repositorySystem);
                lookup.setLocalRepository((ArtifactRepository)this.localRepository);
                lookup.setRemoteRepositories(this.remoteRepositories);
                lookup.setPluginDependencies(this.pluginArtifacts);
                for (SourceFileProvider provider : lookup.resolve()) {
                    this.tool.addSourceFileProvider(provider);
                }
            }
            if (this.properties != null) {
                this.tool.getProperties().putAll((Map<?, ?>)this.properties);
            }
            if (this.additionalScripts != null) {
                this.tool.getAdditionalScripts().addAll(Arrays.asList(this.additionalScripts));
            }
            this.tool.generate();
        }
        catch (TeaVMToolException e) {
            throw new MojoFailureException("Error occured generating JavaScript files", (Throwable)e);
        }
    }

    private TestAdapter createAdapter(ClassLoader classLoader) throws MojoExecutionException {
        Constructor<TestAdapter> cons;
        Class<?> adapterClsRaw;
        try {
            adapterClsRaw = Class.forName(this.adapterClass, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Adapter not found: " + this.adapterClass, (Exception)e);
        }
        if (!TestAdapter.class.isAssignableFrom(adapterClsRaw)) {
            throw new MojoExecutionException("Adapter " + this.adapterClass + " does not implement " + TestAdapter.class.getName());
        }
        Class<TestAdapter> adapterCls = adapterClsRaw.asSubclass(TestAdapter.class);
        try {
            cons = adapterCls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("No default constructor found for test adapter " + this.adapterClass, (Exception)e);
        }
        try {
            return cons.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MojoExecutionException("Error creating test adapter", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new MojoExecutionException("Error creating test adapter", e.getTargetException());
        }
    }

    private ClassLoader prepareClassLoader() throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Preparing classpath for JavaScript test generation");
            ArrayList<URL> urls = new ArrayList<URL>();
            StringBuilder classpath = new StringBuilder();
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!testScopes.contains(artifact.getScope())) continue;
                File file = artifact.getFile();
                if (classpath.length() > 0) {
                    classpath.append(':');
                }
                classpath.append(file.getPath());
                urls.add(file.toURI().toURL());
            }
            if (classpath.length() > 0) {
                classpath.append(':');
            }
            classpath.append(this.testFiles.getPath());
            urls.add(this.testFiles.toURI().toURL());
            classpath.append(':').append(this.classFiles.getPath());
            urls.add(this.classFiles.toURI().toURL());
            log.info((CharSequence)("Using the following classpath for JavaScript test generation: " + classpath));
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), BuildJavascriptTestMojo.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error gathering classpath information", (Exception)e);
        }
    }

    private void findTestsInDependencies(ClassLoader classLoader) throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Scanning dependencies for tests");
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!testScopes.contains(artifact.getScope())) continue;
                File file = artifact.getFile();
                if (file.isDirectory()) {
                    this.findTestClasses(classLoader, file, "");
                    continue;
                }
                if (!file.getName().endsWith(".jar")) continue;
                this.findTestClassesInJar(classLoader, new JarFile(file));
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error gathering classpath information", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error scanning dependencies for tests", (Exception)e);
        }
    }

    private void findTestClasses(ClassLoader classLoader, File folder, String prefix) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                String newPrefix = prefix.isEmpty() ? file.getName() : prefix + "." + file.getName();
                this.findTestClasses(classLoader, file, newPrefix);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = file.getName().substring(0, file.getName().length() - ".class".length());
            if (!prefix.isEmpty()) {
                className = prefix + "." + className;
            }
            this.addCandidate(classLoader, className);
        }
    }

    private void findTestClassesInJar(ClassLoader classLoader, JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String className = entry.getName().substring(0, entry.getName().length() - ".class".length()).replace('/', '.');
            this.addCandidate(classLoader, className);
        }
    }

    private void addCandidate(ClassLoader classLoader, String className) {
        boolean matches = false;
        String simpleName = className.replace('.', '/');
        for (String wildcard : this.wildcards) {
            if (!FilenameUtils.wildcardMatch((String)simpleName, (String)wildcard.replace('.', '/'))) continue;
            matches = true;
            break;
        }
        if (!matches) {
            return;
        }
        try {
            Class<?> candidate = Class.forName(className, true, classLoader);
            if (this.tool.getAdapter().acceptClass(candidate)) {
                this.tool.getTestClasses().add(candidate.getName());
                this.getLog().info((CharSequence)("Test class detected: " + candidate.getName()));
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().info((CharSequence)("Could not load class `" + className + "' to search for tests"));
        }
    }

    private List<ClassHolderTransformer> instantiateTransformers(ClassLoader classLoader) throws MojoExecutionException {
        ArrayList<ClassHolderTransformer> transformerInstances = new ArrayList<ClassHolderTransformer>();
        if (this.transformers == null) {
            return transformerInstances;
        }
        for (String transformerName : this.transformers) {
            Constructor<ClassHolderTransformer> ctor;
            Class<?> transformerRawType;
            try {
                transformerRawType = Class.forName(transformerName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException("Transformer not found: " + transformerName, (Exception)e);
            }
            if (!ClassHolderTransformer.class.isAssignableFrom(transformerRawType)) {
                throw new MojoExecutionException("Transformer " + transformerName + " is not subtype of " + ClassHolderTransformer.class.getName());
            }
            Class<ClassHolderTransformer> transformerType = transformerRawType.asSubclass(ClassHolderTransformer.class);
            try {
                ctor = transformerType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new MojoExecutionException("Transformer " + transformerName + " has no default constructor");
            }
            try {
                ClassHolderTransformer transformer = ctor.newInstance(new Object[0]);
                transformerInstances.add(transformer);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new MojoExecutionException("Error instantiating transformer " + transformerName, (Exception)e);
            }
        }
        return transformerInstances;
    }
}

