/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="copy-webassembly-gc-runtime", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class TeaVMCopyWebassemblyGCRuntimeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/javascript")
    private File targetDirectory;
    @Parameter(property="teavm.wasmGC.runtime.fileName", defaultValue="classes.wasm-runtime.js")
    private String runtimeFileName;
    @Parameter(property="teavm.wasmGC.deobfuscator.fileName", defaultValue="classes.wasm-deobfuscator.wasm")
    private String deobfuscatorFileName;
    @Parameter(property="teavm.wasmGC.runtime.minified", defaultValue="true")
    private boolean minified;
    @Parameter(property="teavm.wasmGC.runtime.modular", defaultValue="false")
    private boolean modular;
    @Parameter(property="teavm.wasmGC.runtime.deobfuscator", defaultValue="false")
    private boolean deobfuscator;

    public void execute() throws MojoExecutionException {
        block17: {
            try {
                StringBuilder name = new StringBuilder("wasm-gc");
                if (this.modular) {
                    name.append("-modular");
                }
                name.append("-runtime");
                if (this.minified) {
                    name.append(".min");
                }
                Object resourceName = "org/teavm/backend/wasm/" + String.valueOf(name) + ".js";
                ClassLoader classLoader = TeaVMCopyWebassemblyGCRuntimeMojo.class.getClassLoader();
                File output = new File(this.targetDirectory, this.runtimeFileName);
                output.getParentFile().mkdirs();
                try (InputStream input = classLoader.getResourceAsStream((String)resourceName);){
                    Files.copy(input, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                if (!this.deobfuscator) break block17;
                resourceName = "org/teavm/backend/wasm/deobfuscator.wasm";
                output = new File(this.targetDirectory, this.deobfuscatorFileName);
                output.getParentFile().mkdirs();
                input = classLoader.getResourceAsStream((String)resourceName);
                try {
                    Files.copy(input, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy webassembly runtime", (Exception)e);
            }
        }
    }
}

