/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teavm.backend.javascript.JavaScriptTarget;
import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.DebugInformationBuilder;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.junit.BrowserRunStrategy;
import org.teavm.junit.CompilePostProcessor;
import org.teavm.junit.CompileResult;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestJsEntryPoint;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestPlatformSupport;
import org.teavm.junit.TestRunStrategy;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.MethodReference;
import org.teavm.model.ReferenceCache;
import org.teavm.vm.TeaVM;

class JSPlatformSupport
extends TestPlatformSupport<JavaScriptTarget> {
    JSPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache) {
        super(classSource, referenceCache);
    }

    @Override
    TestRunStrategy createRunStrategy(File outputDir) {
        String runStrategyName = System.getProperty("teavm.junit.js.runner");
        if (runStrategyName != null) {
            switch (runStrategyName) {
                case "browser": {
                    return new BrowserRunStrategy(outputDir, "JAVASCRIPT", BrowserRunStrategy::customBrowser);
                }
                case "browser-chrome": {
                    return new BrowserRunStrategy(outputDir, "JAVASCRIPT", BrowserRunStrategy::chromeBrowser);
                }
                case "browser-firefox": {
                    return new BrowserRunStrategy(outputDir, "JAVASCRIPT", BrowserRunStrategy::firefoxBrowser);
                }
                case "none": {
                    return null;
                }
            }
            throw new RuntimeException("Unknown run strategy: " + runStrategyName);
        }
        return null;
    }

    @Override
    TestPlatform getPlatform() {
        return TestPlatform.JAVASCRIPT;
    }

    @Override
    String getPath() {
        return "js";
    }

    @Override
    String getExtension() {
        return ".js";
    }

    @Override
    List<TeaVMTestConfiguration<JavaScriptTarget>> getConfigurations() {
        ArrayList<TeaVMTestConfiguration<JavaScriptTarget>> configurations = new ArrayList<TeaVMTestConfiguration<JavaScriptTarget>>();
        if (Boolean.parseBoolean(System.getProperty("teavm.junit.js", "true"))) {
            configurations.add(TeaVMTestConfiguration.JS_DEFAULT);
            if (Boolean.getBoolean("teavm.junit.minified")) {
                configurations.add(TeaVMTestConfiguration.JS_MINIFIED);
            }
            if (Boolean.getBoolean("teavm.junit.optimized")) {
                configurations.add(TeaVMTestConfiguration.JS_OPTIMIZED);
            }
        }
        return configurations;
    }

    @Override
    CompileResult compile(Consumer<TeaVM> additionalProcessing, String baseName, TeaVMTestConfiguration<JavaScriptTarget> configuration, File path) {
        boolean decodeStack = Boolean.parseBoolean(System.getProperty("teavm.junit.js.decodeStack", "true"));
        DebugInformationBuilder debugEmitter = new DebugInformationBuilder(new ReferenceCache());
        Supplier<JavaScriptTarget> targetSupplier = () -> {
            JavaScriptTarget target = new JavaScriptTarget();
            target.setStrict(true);
            if (decodeStack) {
                target.setDebugEmitter((DebugInformationEmitter)debugEmitter);
                target.setStackTraceIncluded(true);
            }
            return target;
        };
        CompilePostProcessor postBuild = null;
        if (decodeStack) {
            postBuild = (vm, file) -> {
                DebugInformation debugInfo = debugEmitter.getDebugInformation();
                File sourceMapsFile = new File(file.getPath() + ".map");
                File debugFile = new File(file.getPath() + ".teavmdbg");
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);){
                        writer.write("\n//# sourceMappingURL=");
                        writer.write(sourceMapsFile.getName());
                    }
                    try (OutputStreamWriter sourceMapsOut = new OutputStreamWriter((OutputStream)new FileOutputStream(sourceMapsFile), StandardCharsets.UTF_8);){
                        debugInfo.writeAsSourceMaps((Writer)sourceMapsOut, "", file.getPath());
                    }
                    try (FileOutputStream out = new FileOutputStream(debugFile);){
                        debugInfo.write((OutputStream)out);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return this.compile(configuration, targetSupplier, TestJsEntryPoint.class.getName(), path, ".js", postBuild, additionalProcessing, baseName);
    }

    @Override
    void additionalOutput(File outputPath, File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
        this.htmlOutput(outputPath, outputPathForMethod, configuration, reference, "teavm-run-test.html");
    }

    @Override
    void additionalSingleTestOutput(File outputPathForMethod, TeaVMTestConfiguration<?> configuration, MethodReference reference) {
        this.htmlSingleTestOutput(outputPathForMethod, configuration, "teavm-run-test.html");
    }

    @Override
    boolean usesFileName() {
        return true;
    }
}

