/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teavm.junit.TeaVMTestRunner;
import org.teavm.junit.TestEntryPoint;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassHolderTransformerContext;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.emit.ProgramEmitter;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

class TestEntryPointTransformer
implements ClassHolderTransformer,
TeaVMPlugin {
    private MethodReference testMethod;
    private String testClassName;

    TestEntryPointTransformer(MethodReference testMethod, String testClassName) {
        this.testMethod = testMethod;
        this.testClassName = testClassName;
    }

    public void install(TeaVMHost host) {
        host.add((ClassHolderTransformer)this);
    }

    public void transformClass(ClassHolder cls, ClassHolderTransformerContext context) {
        if (cls.getName().equals(TestEntryPoint.class.getName())) {
            for (MethodHolder method : cls.getMethods()) {
                switch (method.getName()) {
                    case "launchTest": {
                        method.setProgram(this.generateLaunchProgram(method, context.getHierarchy()));
                        method.getModifiers().remove(ElementModifier.NATIVE);
                        break;
                    }
                    case "before": {
                        method.setProgram(this.generateBeforeProgram(method, context.getHierarchy()));
                        method.getModifiers().remove(ElementModifier.NATIVE);
                        break;
                    }
                    case "after": {
                        method.setProgram(this.generateAfterProgram(method, context.getHierarchy()));
                        method.getModifiers().remove(ElementModifier.NATIVE);
                    }
                }
            }
        }
    }

    private Program generateBeforeProgram(MethodHolder method, ClassHierarchy hierarchy) {
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter testCaseInitVar = pe.getField(TestEntryPoint.class, "testCase", Object.class);
        pe.when(testCaseInitVar.isNull()).thenDo(() -> pe.setField(TestEntryPoint.class, "testCase", pe.construct(this.testClassName, new ValueEmitter[0]).cast(Object.class)));
        ValueEmitter testCaseVar = pe.getField(TestEntryPoint.class, "testCase", Object.class);
        if (hierarchy.isSuperType("junit.framework.TestCase", this.testMethod.getClassName(), false)) {
            testCaseVar.cast(ValueType.object((String)"junit.framework.TestCase")).invokeVirtual(TeaVMTestRunner.JUNIT3_BEFORE, new ValueEmitter[0]);
        }
        List<ClassReader> classes = this.collectSuperClasses(pe.getClassSource(), this.testMethod.getClassName());
        Collections.reverse(classes);
        classes.stream().flatMap(cls -> cls.getMethods().stream()).filter(m -> m.getAnnotations().get("org.junit.Before") != null).forEach(m -> testCaseVar.cast(ValueType.object((String)m.getOwnerName())).invokeVirtual(m.getReference(), new ValueEmitter[0]));
        pe.exit();
        return pe.getProgram();
    }

    private Program generateAfterProgram(MethodHolder method, ClassHierarchy hierarchy) {
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        ValueEmitter testCaseVar = pe.getField(TestEntryPoint.class, "testCase", Object.class);
        List<ClassReader> classes = this.collectSuperClasses(pe.getClassSource(), this.testMethod.getClassName());
        classes.stream().flatMap(cls -> cls.getMethods().stream()).filter(m -> m.getAnnotations().get("org.junit.After") != null).forEach(m -> testCaseVar.cast(ValueType.object((String)m.getOwnerName())).invokeVirtual(m.getReference(), new ValueEmitter[0]));
        if (hierarchy.isSuperType("junit.framework.TestCase", this.testMethod.getClassName(), false)) {
            testCaseVar.cast(ValueType.object((String)"junit.framework.TestCase")).invokeVirtual(TeaVMTestRunner.JUNIT3_AFTER, new ValueEmitter[0]);
        }
        pe.exit();
        return pe.getProgram();
    }

    private List<ClassReader> collectSuperClasses(ClassReaderSource classSource, String className) {
        ClassReader cls;
        ArrayList<ClassReader> result = new ArrayList<ClassReader>();
        while (className != null && !className.equals("junit.framework.TestCase") && (cls = classSource.get(className)) != null) {
            result.add(cls);
            className = cls.getParent();
        }
        return result;
    }

    private Program generateLaunchProgram(MethodHolder method, ClassHierarchy hierarchy) {
        AnnotationValue throwsValue;
        ProgramEmitter pe = ProgramEmitter.create((MethodHolder)method, (ClassHierarchy)hierarchy);
        pe.getField(TestEntryPoint.class, "testCase", Object.class).cast(ValueType.object((String)this.testMethod.getClassName())).invokeSpecial(this.testMethod, new ValueEmitter[0]);
        MethodReader testMethodReader = hierarchy.getClassSource().resolve(this.testMethod);
        AnnotationReader testAnnotation = testMethodReader.getAnnotations().get("org.junit.Test");
        AnnotationValue annotationValue = throwsValue = testAnnotation != null ? testAnnotation.getValue("expected") : null;
        if (throwsValue != null) {
            BasicBlock handler = pe.getProgram().createBasicBlock();
            TryCatchBlock tryCatch = new TryCatchBlock();
            tryCatch.setExceptionType(((ValueType.Object)throwsValue.getJavaClass()).getClassName());
            tryCatch.setHandler(handler);
            pe.getBlock().getTryCatchBlocks().add(tryCatch);
            BasicBlock nextBlock = pe.getProgram().createBasicBlock();
            pe.jump(nextBlock);
            pe.enter(nextBlock);
            pe.construct(AssertionError.class, new ValueEmitter[]{pe.constant("Expected exception not thrown")}).raise();
            pe.enter(handler);
            pe.exit();
        } else {
            pe.exit();
        }
        return pe.getProgram();
    }
}

