/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import org.teavm.backend.javascript.TeaVMJavaScriptHost;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.RenderingManager;
import org.teavm.dependency.DependencyListener;
import org.teavm.junit.TestExceptionDependencyListener;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.ValueType;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.spi.AbstractRendererListener;
import org.teavm.vm.spi.RendererListener;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

class TestExceptionPlugin
implements TeaVMPlugin {
    static final MethodDescriptor GET_MESSAGE = new MethodDescriptor("getMessage", new ValueType[]{ValueType.parse(String.class)});

    TestExceptionPlugin() {
    }

    public void install(TeaVMHost host) {
        host.add((DependencyListener)new TestExceptionDependencyListener());
        TeaVMJavaScriptHost jsHost = (TeaVMJavaScriptHost)host.getExtension(TeaVMJavaScriptHost.class);
        if (jsHost != null) {
            this.install(jsHost);
        }
    }

    private void install(TeaVMJavaScriptHost host) {
        host.addVirtualMethods((context, methodRef) -> {
            if (!methodRef.getDescriptor().equals((Object)GET_MESSAGE)) {
                return false;
            }
            return context.getClassSource().isSuperType("java.lang.Throwable", methodRef.getClassName()).orElse(false);
        });
        host.add((RendererListener)new AbstractRendererListener(){
            RenderingManager manager;

            public void begin(RenderingManager manager, BuildTarget buildTarget) {
                this.manager = manager;
            }

            public void complete() {
                TestExceptionPlugin.this.renderExceptionMessage(this.manager.getWriter());
            }
        });
    }

    private void renderExceptionMessage(SourceWriter writer) {
        writer.appendClass("java.lang.Throwable").append(".prototype.getMessage").ws().append("=").ws().append("function()").ws().append("{").indent().softNewLine();
        writer.append("return ").appendFunction("$rt_ustr").append("(this.").appendVirtualMethod("getMessage", new Class[]{String.class}).append("());").softNewLine();
        writer.outdent().append("};").newLine();
    }
}

