/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.TestCase;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.teavm.junit.CPlatformSupport;
import org.teavm.junit.CompileResult;
import org.teavm.junit.EachTestCompiledSeparately;
import org.teavm.junit.JSPlatformSupport;
import org.teavm.junit.JsModuleTest;
import org.teavm.junit.OnlyPlatform;
import org.teavm.junit.SkipJVM;
import org.teavm.junit.SkipPlatform;
import org.teavm.junit.TeaVMProperties;
import org.teavm.junit.TeaVMProperty;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestEntryPointTransformerForSingleMethod;
import org.teavm.junit.TestEntryPointTransformerForWholeClass;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestPlatformSupport;
import org.teavm.junit.TestRun;
import org.teavm.junit.TestRunGroup;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.WasiPlatformSupport;
import org.teavm.junit.WebAssemblyGCPlatformSupport;
import org.teavm.junit.WebAssemblyPlatformSupport;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.PreOptimizingClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.model.ValueType;
import org.teavm.parsing.ClasspathClassHolderSource;
import org.teavm.parsing.ClasspathResourceProvider;
import org.teavm.parsing.resource.ResourceProvider;
import org.teavm.vm.TeaVM;
import org.teavm.vm.spi.TeaVMHost;

public class TeaVMTestRunner
extends org.junit.runner.Runner
implements Filterable {
    static final String JUNIT3_BASE_CLASS = "junit.framework.TestCase";
    static final MethodReference JUNIT3_BEFORE = new MethodReference("junit.framework.TestCase", "setUp", new ValueType[]{ValueType.VOID});
    static final MethodReference JUNIT3_AFTER = new MethodReference("junit.framework.TestCase", "tearDown", new ValueType[]{ValueType.VOID});
    static final String JUNIT4_TEST = "org.junit.Test";
    static final String JUNIT4_IGNORE = "org.junit.Ignore";
    static final String TESTNG_TEST = "org.testng.annotations.Test";
    static final String TESTNG_IGNORE = "org.testng.annotations.Ignore";
    static final String JUNIT4_BEFORE = "org.junit.Before";
    static final String TESTNG_BEFORE = "org.testng.annotations.BeforeMethod";
    static final String JUNIT4_AFTER = "org.junit.After";
    static final String TESTNG_AFTER = "org.testng.annotations.AfterMethod";
    static final String TESTNG_PROVIDER = "org.testng.annotations.DataProvider";
    private Class<?> testClass;
    private boolean isWholeClassCompilation;
    private static ClassHolderSource classSource;
    private static ClassLoader classLoader;
    private Description suiteDescription;
    private static File outputDir;
    private Map<Method, Description> descriptions = new HashMap<Method, Description>();
    private static Map<TestPlatform, TestRunStrategy> runners;
    private List<Method> filteredChildren;
    private static ReferenceCache referenceCache;
    private List<TestRun> runsInCurrentClass = new ArrayList<TestRun>();
    private static List<TestPlatformSupport<?>> platforms;
    private List<TestPlatformSupport<?>> participatingPlatforms = new ArrayList();
    private ResourceProvider resourceProvider;

    public TeaVMTestRunner(Class<?> testClass) throws InitializationError {
        this.testClass = testClass;
    }

    public Description getDescription() {
        if (this.suiteDescription == null) {
            this.suiteDescription = Description.createSuiteDescription(this.testClass);
            for (Method child : this.getFilteredChildren()) {
                this.suiteDescription.addChild(this.describeChild(child));
            }
        }
        return this.suiteDescription;
    }

    public void run(RunNotifier notifier) {
        for (TestPlatformSupport<?> platform : platforms) {
            if (!platform.isEnabled() || platform.getConfigurations().isEmpty()) continue;
            this.participatingPlatforms.add(platform);
        }
        List<Method> children = this.getFilteredChildren();
        Description description = this.getDescription();
        notifier.fireTestStarted(description);
        boolean bl = this.isWholeClassCompilation = !this.testClass.isAnnotationPresent(EachTestCompiledSeparately.class);
        if (this.isWholeClassCompilation) {
            this.runWithWholeClassCompilation(children, notifier);
        } else {
            for (Method child : children) {
                this.runChild(child, notifier);
            }
        }
        this.writeRunsDescriptor();
        this.runsInCurrentClass.clear();
        notifier.fireTestFinished(description);
    }

    private void runWithWholeClassCompilation(List<Method> children, RunNotifier notifier) {
        List<PlatformClassTests> tests = this.compileWholeClass(children, notifier);
        if (tests == null) {
            this.failAllClasses(children, notifier);
            return;
        }
        boolean skipJvmForClass = !this.testClass.isAnnotationPresent(SkipJVM.class);
        for (Method child : children) {
            Description description = this.describeChild(child);
            notifier.fireTestStarted(description);
            if (this.isIgnored(child)) {
                notifier.fireTestIgnored(description);
            } else {
                boolean success = true;
                if (skipJvmForClass && !child.isAnnotationPresent(SkipJVM.class)) {
                    ClassHolder classHolder = classSource.get(child.getDeclaringClass().getName());
                    MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(child));
                    success = this.runInJvm(child, notifier, TeaVMTestRunner.getExpectedExceptions((MethodReader)methodHolder));
                }
                if (success) {
                    block3: for (PlatformClassTests testForPlatform : tests) {
                        List<TestRun> runs = testForPlatform.runs.get(child);
                        if (runs == null) continue;
                        for (TestRun run : runs) {
                            try {
                                this.submitRun(run);
                            }
                            catch (Throwable e) {
                                notifier.fireTestFailure(new Failure(description, e));
                                continue block3;
                            }
                        }
                    }
                }
            }
            notifier.fireTestFinished(description);
        }
        for (PlatformClassTests testsForPlatform : tests) {
            TestRunStrategy runner = runners.get((Object)testsForPlatform.platform.getPlatform());
            runner.cleanup();
        }
    }

    private void failAllClasses(List<Method> children, RunNotifier notifier) {
        for (Method child : children) {
            Description description = this.describeChild(child);
            notifier.fireTestStarted(description);
            if (this.isIgnored(child)) {
                notifier.fireTestIgnored(description);
                return;
            }
            notifier.fireTestFailure(new Failure(description, (Throwable)((Object)new AssertionError((Object)"Could not compile test class"))));
            notifier.fireTestFinished(description);
        }
    }

    private List<Method> getChildren() {
        ArrayList<Method> children = new ArrayList<Method>();
        HashSet<String> foundMethods = new HashSet<String>();
        for (Class<?> cls = this.testClass; cls != Object.class && !cls.getName().equals(JUNIT3_BASE_CLASS); cls = cls.getSuperclass()) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!foundMethods.add(method.getName()) || !this.isTestMethod(method)) continue;
                children.add(method);
            }
        }
        return children;
    }

    private boolean isTestMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (TestCase.class.isAssignableFrom(method.getDeclaringClass())) {
            return method.getName().startsWith("test") && method.getName().length() > 4 && Character.isUpperCase(method.getName().charAt(4));
        }
        if (this.getClassAnnotation(method, TESTNG_TEST) != null) {
            return method.getName().startsWith("test_");
        }
        return this.getAnnotation(method, JUNIT4_TEST) != null || this.getAnnotation(method, TESTNG_TEST) != null;
    }

    private List<Method> getFilteredChildren() {
        if (this.filteredChildren == null) {
            this.filteredChildren = this.getChildren();
        }
        return this.filteredChildren;
    }

    private Description describeChild(Method child) {
        return this.descriptions.computeIfAbsent(child, method -> Description.createTestDescription(this.testClass, (String)method.getName()));
    }

    private List<PlatformClassTests> compileWholeClass(List<Method> children, RunNotifier notifier) {
        Description description = this.getDescription();
        ArrayList<PlatformClassTests> result = new ArrayList<PlatformClassTests>();
        for (TestPlatformSupport<?> platformSupport : this.participatingPlatforms) {
            PlatformClassTests item = this.compileClassForPlatform(platformSupport, children, this.testClass, description, notifier);
            if (item == null) {
                return null;
            }
            if (item.platform == null) continue;
            result.add(item);
        }
        return result;
    }

    private PlatformClassTests compileClassForPlatform(TestPlatformSupport<?> platform, List<Method> children, Class<?> cls, Description description, RunNotifier notifier) {
        PlatformClassTests platformClassTests = new PlatformClassTests();
        boolean isModule = cls.isAnnotationPresent(JsModuleTest.class);
        if (platform.isEnabled() && this.hasChildrenToRun(children, platform.getPlatform())) {
            platformClassTests.platform = platform;
            File path = this.getOutputPathForClass(platform);
            for (TeaVMTestConfiguration<?> configuration : platform.getConfigurations()) {
                TestPlatformSupport<?> castPlatform = platform;
                TeaVMTestConfiguration<?> castConfiguration = configuration;
                ArrayList<TestRun> runs = new ArrayList<TestRun>();
                CompileResult result = castPlatform.compile(this.wholeClass(children, platform.getPlatform(), configuration, runs), "classTest", castConfiguration, path, this.testClass);
                if (!result.success) {
                    notifier.fireTestFailure(this.createFailure(description, result));
                    return null;
                }
                TestRunGroup group = new TestRunGroup(path, result.file.getName(), platform.getPlatform(), isModule);
                for (TestRun run : runs) {
                    run.group = group;
                    platformClassTests.runs.computeIfAbsent(run.getMethod(), m -> new ArrayList()).add(run);
                    platform.additionalOutput(path, new File(path, run.getMethod().getName()), configuration, MethodReference.parse((String)run.getArgument()));
                }
                platform.additionalOutput(path, configuration);
            }
            for (Method method : platformClassTests.runs.keySet()) {
                platform.additionalOutputForAllConfigurations(path, method);
            }
        }
        return platformClassTests;
    }

    private boolean isPlatformPresent(AnnotatedElement declaration, TestPlatform platform) {
        OnlyPlatform onlyPlatform;
        SkipPlatform skipPlatform = declaration.getAnnotation(SkipPlatform.class);
        if (skipPlatform != null) {
            for (TestPlatform toSkip : skipPlatform.value()) {
                if (toSkip != platform) continue;
                return false;
            }
        }
        if ((onlyPlatform = declaration.getAnnotation(OnlyPlatform.class)) != null) {
            for (TestPlatform allowedPlatform : onlyPlatform.value()) {
                if (allowedPlatform != platform) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean hasChildrenToRun(List<Method> children, TestPlatform platform) {
        return this.isPlatformPresent(this.testClass, platform) && children.stream().anyMatch(child -> this.isPlatformPresent((AnnotatedElement)child, platform));
    }

    private List<Method> filterChildren(List<Method> children, TestPlatform platform) {
        return children.stream().filter((? super T child) -> this.isPlatformPresent((AnnotatedElement)child, platform)).collect(Collectors.toList());
    }

    private boolean shouldRunChild(Method child, TestPlatform platform) {
        return this.isPlatformPresent(this.testClass, platform) && this.isPlatformPresent(child, platform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runChild(Method child, RunNotifier notifier) {
        Description description = this.describeChild(child);
        notifier.fireTestStarted(description);
        if (this.isIgnored(child)) {
            notifier.fireTestIgnored(description);
            notifier.fireTestFinished(description);
            return;
        }
        boolean ran = false;
        boolean success = true;
        if (!child.isAnnotationPresent(SkipJVM.class) && !this.testClass.isAnnotationPresent(SkipJVM.class)) {
            ran = true;
            ClassHolder classHolder = classSource.get(child.getDeclaringClass().getName());
            MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(child));
            success = this.runInJvm(child, notifier, TeaVMTestRunner.getExpectedExceptions((MethodReader)methodHolder));
        }
        if (success && outputDir != null) {
            ArrayList<TestRun> runs = new ArrayList<TestRun>();
            try {
                this.prepareCompiledTest(child, notifier, runs);
                for (TestRun run : runs) {
                    try {
                        this.submitRun(run);
                    }
                    catch (Throwable e) {
                        notifier.fireTestFailure(new Failure(description, e));
                        break;
                    }
                }
                for (TestRun run : runs) {
                    TestRunStrategy strategy = runners.get((Object)run.getGroup().getKind());
                    strategy.cleanup();
                }
            }
            finally {
                notifier.fireTestFinished(description);
            }
        } else {
            if (!ran) {
                notifier.fireTestIgnored(description);
            }
            notifier.fireTestFinished(description);
        }
    }

    private void prepareCompiledTest(Method child, RunNotifier notifier, List<TestRun> runs) {
        MethodDescriptor descriptor = this.getDescriptor(child);
        MethodReference reference = new MethodReference(child.getDeclaringClass().getName(), descriptor);
        try {
            for (TestPlatformSupport<?> platform : this.participatingPlatforms) {
                if (!platform.isEnabled() || !this.shouldRunChild(child, platform.getPlatform())) continue;
                File outputPath = this.getOutputPath(child, platform);
                for (TeaVMTestConfiguration<?> configuration : platform.getConfigurations()) {
                    TestPlatformSupport<?> castPlatform = platform;
                    TeaVMTestConfiguration<?> castConfig = configuration;
                    CompileResult compileResult = castPlatform.compile(this.singleTest(child), "test", castConfig, outputPath, child);
                    TestRun run = this.prepareRun(configuration, child, compileResult, notifier, platform.getPlatform());
                    if (run == null) continue;
                    runs.add(run);
                    platform.additionalSingleTestOutput(outputPath, configuration, reference);
                }
                platform.additionalOutputForAllConfigurations(outputPath, child);
            }
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(this.describeChild(child), e));
        }
    }

    static String[] getExpectedExceptions(MethodReader method) {
        AnnotationReader annot = method.getAnnotations().get(JUNIT4_TEST);
        if (annot != null) {
            AnnotationValue expected = annot.getValue("expected");
            if (expected == null) {
                return new String[0];
            }
            ValueType result = expected.getJavaClass();
            return new String[]{((ValueType.Object)result).getClassName()};
        }
        annot = method.getAnnotations().get(TESTNG_TEST);
        if (annot != null) {
            AnnotationValue expected = annot.getValue("expectedExceptions");
            if (expected == null) {
                return new String[0];
            }
            List list = expected.getList();
            String[] result = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                result[i] = ((ValueType.Object)((AnnotationValue)list.get(i)).getJavaClass()).getClassName();
            }
            return result;
        }
        return new String[0];
    }

    private boolean runInJvm(Method testMethod, RunNotifier notifier, String[] expectedExceptions) {
        Runner runner;
        Object instance;
        Description description = this.describeChild(testMethod);
        try {
            instance = this.testClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            notifier.fireTestFailure(new Failure(description, (Throwable)e));
            return false;
        }
        catch (InvocationTargetException e) {
            notifier.fireTestFailure(new Failure(description, e.getTargetException()));
            return false;
        }
        try {
            runner = this.prepareJvmRunner(instance, testMethod, expectedExceptions);
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(description, e));
            return false;
        }
        try {
            runner.run(new Object[0]);
            return true;
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(description, e));
            return false;
        }
    }

    private Runner prepareJvmRunner(Object instance, Method testMethod, String[] expectedExceptions) throws Throwable {
        Runner runner = TestCase.class.isAssignableFrom(this.testClass) ? new JUnit3Runner((TestCase)instance, testMethod) : new SimpleMethodRunner(instance, testMethod);
        if (expectedExceptions.length > 0) {
            runner = new WithExpectedExceptionRunner(runner, expectedExceptions);
        }
        runner = this.wrapWithBeforeAndAfter(runner, instance);
        runner = this.wrapWithDataProvider(runner, instance, testMethod);
        return runner;
    }

    private Runner wrapWithBeforeAndAfter(Runner runner, Object instance) {
        ArrayList classes = new ArrayList();
        for (Class<?> cls = instance.getClass(); cls != null; cls = cls.getSuperclass()) {
            classes.add(cls);
        }
        ArrayList<Method> afterMethods = new ArrayList<Method>();
        for (Class clazz : classes) {
            for (Method method : clazz.getMethods()) {
                if (this.getAnnotation(method, JUNIT4_AFTER) == null && this.getAnnotation(method, TESTNG_AFTER) == null) continue;
                afterMethods.add(method);
            }
        }
        ArrayList<Method> beforeMethods = new ArrayList<Method>();
        Collections.reverse(classes);
        for (Class clazz : classes) {
            for (Method method : clazz.getMethods()) {
                if (this.getAnnotation(method, JUNIT4_BEFORE) == null && this.getAnnotation(method, TESTNG_BEFORE) == null) continue;
                beforeMethods.add(method);
            }
        }
        if (beforeMethods.isEmpty() && afterMethods.isEmpty()) {
            return runner;
        }
        return new WithBeforeAndAfterRunner(runner, instance, beforeMethods.toArray(new Method[0]), afterMethods.toArray(new Method[0]));
    }

    private Runner wrapWithDataProvider(Runner runner, Object instance, Method testMethod) throws Throwable {
        Object data;
        AnnotationHolder annot = this.getAnnotation(testMethod, TESTNG_TEST);
        if (annot == null) {
            return runner;
        }
        AnnotationValue dataProviderValue = annot.getValue("dataProvider");
        if (dataProviderValue == null) {
            return runner;
        }
        String providerName = dataProviderValue.getString();
        if (providerName.isEmpty()) {
            return runner;
        }
        Method provider = null;
        for (Method method : testMethod.getDeclaringClass().getDeclaredMethods()) {
            AnnotationHolder providerAnnot = this.getAnnotation(method, TESTNG_PROVIDER);
            if (providerAnnot == null || !providerAnnot.getValue("name").getString().equals(providerName)) continue;
            provider = method;
            break;
        }
        try {
            provider.setAccessible(true);
            data = provider.invoke(instance, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return new WithDataProviderRunner(runner, data, testMethod.getParameterTypes());
    }

    private TestRun prepareRun(TeaVMTestConfiguration<?> configuration, Method child, CompileResult result, RunNotifier notifier, TestPlatform kind) {
        Description description = this.describeChild(child);
        if (!result.success) {
            notifier.fireTestFailure(this.createFailure(description, result));
            return null;
        }
        return this.createTestRun(configuration, result.file, child, kind, this.isModule(child));
    }

    private boolean isModule(Method method) {
        return method.isAnnotationPresent(JsModuleTest.class) || method.getDeclaringClass().isAnnotationPresent(JsModuleTest.class);
    }

    private TestRun createTestRun(TeaVMTestConfiguration<?> configuration, File file, Method child, TestPlatform kind, boolean module) {
        TestRun run = new TestRun(this.generateName(child.getName(), configuration), child, null);
        run.group = new TestRunGroup(file.getParentFile(), file.getName(), kind, module);
        return run;
    }

    private String generateName(String baseName, TeaVMTestConfiguration<?> configuration) {
        String suffix = configuration.getSuffix();
        if (!suffix.isEmpty()) {
            baseName = (String)baseName + " (" + suffix + ")";
        }
        return baseName;
    }

    private Failure createFailure(Description description, CompileResult result) {
        Object throwable = result.throwable;
        if (throwable == null) {
            throwable = new AssertionError((Object)result.errorMessage);
        }
        return new Failure(description, (Throwable)throwable);
    }

    private void submitRun(TestRun run) throws IOException {
        this.runsInCurrentClass.add(run);
        TestRunStrategy strategy = runners.get((Object)run.getGroup().getKind());
        if (strategy == null) {
            return;
        }
        strategy.runTest(run);
    }

    private File getOutputPath(Method method, TestPlatformSupport<?> platform) {
        File path = outputDir;
        path = new File(new File(path, platform.getPath()), this.testClass.getName().replace('.', '/'));
        path = new File(path, method.getName());
        path.mkdirs();
        return path;
    }

    private File getOutputPathForClass(TestPlatformSupport<?> platform) {
        File path = outputDir;
        path = new File(new File(path, platform.getPath()), this.testClass.getName().replace('.', '/'));
        path.mkdirs();
        return path;
    }

    private Consumer<TeaVM> singleTest(Method method) {
        ClassHolder classHolder = classSource.get(method.getDeclaringClass().getName());
        MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(method));
        return vm -> {
            Properties properties = new Properties();
            this.applyProperties(method.getDeclaringClass(), properties);
            vm.setProperties(properties);
            new TestEntryPointTransformerForSingleMethod(methodHolder.getReference(), this.testClass.getName()).install((TeaVMHost)vm);
        };
    }

    private Consumer<TeaVM> wholeClass(List<Method> methods, TestPlatform platform, TeaVMTestConfiguration<?> configuration, List<TestRun> runs) {
        return vm -> {
            Properties properties = new Properties();
            this.applyProperties(this.testClass, properties);
            vm.setProperties(properties);
            ArrayList<MethodReference> methodReferences = new ArrayList<MethodReference>();
            for (Method method : this.filterChildren(methods, platform)) {
                if (this.isIgnored(method)) continue;
                ClassHolder classHolder = classSource.get(method.getDeclaringClass().getName());
                MethodHolder methodHolder = classHolder.getMethod(this.getDescriptor(method));
                methodReferences.add(methodHolder.getReference());
                TestRun run = new TestRun(this.generateName(method.getName(), configuration), method, methodHolder.getReference().toString());
                runs.add(run);
            }
            new TestEntryPointTransformerForWholeClass(methodReferences, this.testClass.getName()).install((TeaVMHost)vm);
        };
    }

    private boolean isIgnored(Method method) {
        return this.getAnnotation(method, JUNIT4_IGNORE) != null || this.getAnnotation(method, TESTNG_IGNORE) != null || this.getClassAnnotation(method, JUNIT4_IGNORE) != null || this.getClassAnnotation(method, TESTNG_IGNORE) != null;
    }

    private AnnotationHolder getAnnotation(Method method, String name) {
        ClassHolder cls = classSource.get(method.getDeclaringClass().getName());
        if (cls == null) {
            return null;
        }
        MethodDescriptor descriptor = this.getDescriptor(method);
        MethodHolder methodHolder = cls.getMethod(descriptor);
        if (methodHolder == null) {
            return null;
        }
        return methodHolder.getAnnotations().get(name);
    }

    private AnnotationHolder getClassAnnotation(Method method, String name) {
        ClassHolder cls = classSource.get(method.getDeclaringClass().getName());
        if (cls == null) {
            return null;
        }
        return cls.getAnnotations().get(name);
    }

    private void applyProperties(Class<?> cls, Properties result) {
        TeaVMProperties properties;
        if (cls.getSuperclass() != null) {
            this.applyProperties(cls.getSuperclass(), result);
        }
        if ((properties = cls.getAnnotation(TeaVMProperties.class)) != null) {
            for (TeaVMProperty property : properties.value()) {
                result.setProperty(property.key(), property.value());
            }
        }
    }

    private MethodDescriptor getDescriptor(Method method) {
        ValueType[] signature = (ValueType[])Stream.concat(Arrays.stream(method.getParameterTypes()).map(ValueType::parse), Stream.of(ValueType.parse(method.getReturnType()))).toArray(ValueType[]::new);
        return new MethodDescriptor(method.getName(), signature);
    }

    private static ClassHolderSource getClassSource(ClassLoader classLoader) {
        ClasspathResourceProvider resourceProvider = new ClasspathResourceProvider(classLoader);
        return new PreOptimizingClassHolderSource((ClassHolderSource)new ClasspathClassHolderSource((ResourceProvider)resourceProvider, referenceCache));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        Iterator<Method> iterator = this.getFilteredChildren().iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next();
            if (filter.shouldRun(this.describeChild(method))) {
                filter.apply((Object)method);
                continue;
            }
            iterator.remove();
        }
    }

    private void writeRunsDescriptor() {
        if (this.runsInCurrentClass.isEmpty()) {
            return;
        }
        for (TestPlatformSupport<?> platform : this.participatingPlatforms) {
            this.writeRunsDescriptor(platform);
        }
    }

    private void writeRunsDescriptor(TestPlatformSupport<?> platform) {
        List runs = this.runsInCurrentClass.stream().filter((? super T run) -> run.getGroup().getKind() == platform.getPlatform()).collect(Collectors.toList());
        if (runs.isEmpty()) {
            return;
        }
        File outputDir = this.getOutputPathForClass(platform);
        outputDir.mkdirs();
        File descriptorFile = new File(outputDir, "tests.json");
        try (FileOutputStream output = new FileOutputStream(descriptorFile);
             BufferedOutputStream bufferedOutput = new BufferedOutputStream(output);
             OutputStreamWriter writer = new OutputStreamWriter(bufferedOutput);){
            writer.write("[\n");
            boolean first = true;
            for (TestRun run2 : runs) {
                if (!first) {
                    writer.write(",\n");
                }
                first = false;
                writer.write("  {\n");
                writer.write("    \"baseDir\": ");
                TeaVMTestRunner.writeJsonString(writer, run2.getGroup().getBaseDirectory().getAbsolutePath().replace('\\', '/'));
                writer.write(",\n");
                writer.write("    \"fileName\": ");
                TeaVMTestRunner.writeJsonString(writer, run2.getGroup().getFileName());
                writer.write(",\n");
                writer.write("    \"kind\": \"" + run2.getGroup().getKind().name() + "\"");
                if (run2.getArgument() != null) {
                    writer.write(",\n");
                    writer.write("    \"argument\": ");
                    TeaVMTestRunner.writeJsonString(writer, run2.getArgument());
                }
                writer.write(",\n");
                writer.write("    \"name\": ");
                TeaVMTestRunner.writeJsonString(writer, run2.getName());
                writer.write("\n  }");
            }
            writer.write("\n]");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeJsonString(Writer writer, String s) throws IOException {
        writer.write(34);
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    writer.write("\\\"");
                    continue block9;
                }
                case '\\': {
                    writer.write("\\\\");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        writer.write("\\u00");
                        writer.write(TeaVMTestRunner.hex(c / 16));
                        writer.write(TeaVMTestRunner.hex(c % 16));
                        continue block9;
                    }
                    writer.write(c);
                }
            }
        }
        writer.write(34);
    }

    private static char hex(int digit) {
        return (char)(digit < 10 ? 48 + digit : 65 + digit - 10);
    }

    static {
        runners = new HashMap<TestPlatform, TestRunStrategy>();
        referenceCache = new ReferenceCache();
        platforms = new ArrayList();
        classLoader = TeaVMTestRunner.class.getClassLoader();
        classSource = TeaVMTestRunner.getClassSource(classLoader);
        String outputPath = System.getProperty("teavm.junit.target");
        if (outputPath != null) {
            outputDir = new File(outputPath);
        }
        platforms.add(new JSPlatformSupport(classSource, referenceCache));
        platforms.add(new WebAssemblyPlatformSupport(classSource, referenceCache, Boolean.parseBoolean(System.getProperty("teavm.junit.wasm.disasm"))));
        platforms.add(new WebAssemblyGCPlatformSupport(classSource, referenceCache, Boolean.parseBoolean(System.getProperty("teavm.junit.wasm-gc.disasm"))));
        platforms.add(new WasiPlatformSupport(classSource, referenceCache));
        platforms.add(new CPlatformSupport(classSource, referenceCache));
        for (TestPlatformSupport<?> platform : platforms) {
            TestRunStrategy runStrategy;
            if (!platform.isEnabled() || platform.getConfigurations().isEmpty() || (runStrategy = platform.createRunStrategy(outputDir)) == null) continue;
            runners.put(platform.getPlatform(), runStrategy);
        }
        for (TestRunStrategy strategy : runners.values()) {
            strategy.beforeAll();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (TestRunStrategy strategy : runners.values()) {
                strategy.afterAll();
            }
        }));
    }

    private static class PlatformClassTests {
        TestPlatformSupport<?> platform;
        LinkedHashMap<Method, List<TestRun>> runs = new LinkedHashMap();

        private PlatformClassTests() {
        }
    }

    static interface Runner {
        public void run(Object[] var1) throws Throwable;
    }

    static class JUnit3Runner
    implements Runner {
        TestCase instance;
        Method testMethod;

        JUnit3Runner(TestCase instance, Method testMethod) {
            this.instance = instance;
            this.testMethod = testMethod;
        }

        @Override
        public void run(Object[] arguments) throws Throwable {
            this.instance.setName(this.testMethod.getName());
            this.instance.runBare();
        }
    }

    static class SimpleMethodRunner
    implements Runner {
        Object instance;
        Method testMethod;

        SimpleMethodRunner(Object instance, Method testMethod) {
            this.instance = instance;
            this.testMethod = testMethod;
        }

        @Override
        public void run(Object[] arguments) throws Throwable {
            try {
                this.testMethod.invoke(this.instance, arguments);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    static class WithExpectedExceptionRunner
    implements Runner {
        private Runner underlyingRunner;
        private String[] expectedExceptions;

        WithExpectedExceptionRunner(Runner underlyingRunner, String[] expectedExceptions) {
            this.underlyingRunner = underlyingRunner;
            this.expectedExceptions = expectedExceptions;
        }

        @Override
        public void run(Object[] arguments) throws Throwable {
            boolean caught;
            block4: {
                caught = false;
                try {
                    this.underlyingRunner.run(arguments);
                }
                catch (Exception e) {
                    for (String expected : this.expectedExceptions) {
                        if (!this.isSubtype(e.getClass(), expected)) continue;
                        caught = true;
                        break;
                    }
                    if (caught) break block4;
                    throw e;
                }
            }
            if (!caught) {
                throw new AssertionError((Object)"Expected exception not thrown");
            }
        }

        private boolean isSubtype(Class<?> cls, String superType) {
            while (cls != Throwable.class) {
                if (cls.getName().equals(superType)) {
                    return true;
                }
                cls = cls.getSuperclass();
            }
            return false;
        }
    }

    static class WithBeforeAndAfterRunner
    implements Runner {
        private Runner underlyingRunner;
        private Object instance;
        private Method[] beforeMethods;
        private Method[] afterMethods;

        WithBeforeAndAfterRunner(Runner underlyingRunner, Object instance, Method[] beforeMethods, Method[] afterMethods) {
            this.underlyingRunner = underlyingRunner;
            this.instance = instance;
            this.beforeMethods = beforeMethods;
            this.afterMethods = afterMethods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Object[] arguments) throws Throwable {
            for (Method method : this.beforeMethods) {
                try {
                    method.invoke(this.instance, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            try {
                this.underlyingRunner.run(arguments);
            }
            finally {
                for (Method method : this.afterMethods) {
                    method.invoke(this.instance, new Object[0]);
                }
            }
        }
    }

    static class WithDataProviderRunner
    implements Runner {
        Runner underlyingRunner;
        Object data;
        Class<?>[] types;

        WithDataProviderRunner(Runner underlyingRunner, Object data, Class<?>[] types) {
            this.underlyingRunner = underlyingRunner;
            this.data = data;
            this.types = types;
        }

        @Override
        public void run(Object[] arguments) throws Throwable {
            if (arguments.length > 0) {
                throw new IllegalArgumentException("Expected 0 arguments");
            }
            if (this.data instanceof Iterator) {
                this.runWithIteratorData((Iterator)this.data);
            } else {
                this.runWithArrayData((Object[][])this.data);
            }
        }

        private void runWithArrayData(Object[][] data) throws Throwable {
            for (int i = 0; i < data.length; ++i) {
                this.runWithDataRow(data[i]);
            }
        }

        private void runWithIteratorData(Iterator<?> data) throws Throwable {
            while (data.hasNext()) {
                this.runWithDataRow((Object[])data.next());
            }
        }

        private void runWithDataRow(Object[] dataRow) throws Throwable {
            Object[] args = (Object[])dataRow.clone();
            for (int j = 0; j < args.length; ++j) {
                args[j] = this.convert(args[j], this.types[j]);
            }
            this.underlyingRunner.run(args);
        }

        private Object convert(Object value, Class<?> type) {
            if (type == Byte.TYPE) {
                value = ((Number)value).byteValue();
            } else if (type == Short.TYPE) {
                value = ((Number)value).shortValue();
            } else if (type == Integer.TYPE) {
                value = ((Number)value).intValue();
            } else if (type == Long.TYPE) {
                value = ((Number)value).longValue();
            } else if (type == Float.TYPE) {
                value = Float.valueOf(((Number)value).floatValue());
            } else if (type == Double.TYPE) {
                value = ((Number)value).doubleValue();
            }
            return value;
        }
    }
}

