/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.teavm.backend.c.CTarget;
import org.teavm.backend.c.generate.CNameProvider;
import org.teavm.backend.lowlevel.generate.NameProvider;
import org.teavm.junit.AttachC;
import org.teavm.junit.CRunStrategy;
import org.teavm.junit.CompilePostProcessor;
import org.teavm.junit.CompileResult;
import org.teavm.junit.IncludeC;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestNativeEntryPoint;
import org.teavm.junit.TestPlatform;
import org.teavm.junit.TestPlatformSupport;
import org.teavm.junit.TestRunStrategy;
import org.teavm.junit.TestUtil;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.vm.TeaVM;

class CPlatformSupport
extends TestPlatformSupport<CTarget> {
    CPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache) {
        super(classSource, referenceCache);
    }

    @Override
    TestRunStrategy createRunStrategy(File outputDir) {
        String cCommand = System.getProperty("teavm.junit.c.compiler");
        if (cCommand != null) {
            return new CRunStrategy(cCommand);
        }
        return null;
    }

    @Override
    TestPlatform getPlatform() {
        return TestPlatform.C;
    }

    @Override
    String getPath() {
        return "c";
    }

    @Override
    String getExtension() {
        return "";
    }

    @Override
    boolean isEnabled() {
        return Boolean.getBoolean("teavm.junit.c");
    }

    @Override
    List<TeaVMTestConfiguration<CTarget>> getConfigurations() {
        ArrayList<TeaVMTestConfiguration<CTarget>> configurations = new ArrayList<TeaVMTestConfiguration<CTarget>>();
        configurations.add(TeaVMTestConfiguration.C_DEFAULT);
        if (Boolean.getBoolean("teavm.junit.optimized")) {
            configurations.add(TeaVMTestConfiguration.C_OPTIMIZED);
        }
        return configurations;
    }

    @Override
    CompileResult compile(Consumer<TeaVM> additionalProcessing, String baseName, TeaVMTestConfiguration<CTarget> configuration, File path, AnnotatedElement element) {
        CompilePostProcessor postBuild = (vm, file) -> {
            try {
                TestUtil.resourceToFile("teavm-CMakeLists.txt", new File(file.getParent(), "CMakeLists.txt"), Collections.emptyMap());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        CompileResult result = this.compile(configuration, this::createCTarget, TestNativeEntryPoint.class.getName(), path, "", postBuild, additionalProcessing, baseName);
        if (result.success) {
            this.includeAndAttachAdditionalFiles(element, result.file);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void includeAndAttachAdditionalFiles(AnnotatedElement element, File baseFile) {
        IncludeC includeC;
        FileOutputStream output;
        InputStream input;
        File outputFile;
        String fileName;
        String resourceName;
        String[] stringArray;
        Class<?> cls = element instanceof Method ? ((Method)element).getDeclaringClass() : (Class<?>)element;
        AttachC attachC = element.getAnnotation(AttachC.class);
        if (attachC != null) {
            void var8_13;
            ArrayList<CallSite> fileNamesToAdd = new ArrayList<CallSite>();
            stringArray = attachC.value();
            int n = stringArray.length;
            boolean bl = false;
            while (var8_13 < n) {
                resourceName = stringArray[var8_13];
                fileName = "custom-src/" + resourceName.substring(resourceName.lastIndexOf(47) + 1);
                fileNamesToAdd.add((CallSite)((Object)fileName));
                outputFile = new File(baseFile, fileName);
                outputFile.getParentFile().mkdirs();
                try {
                    input = cls.getClassLoader().getResourceAsStream(resourceName);
                    try {
                        output = new FileOutputStream(outputFile);
                        try {
                            input.transferTo(output);
                        }
                        finally {
                            output.close();
                        }
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ++var8_13;
            }
            try (FileWriter output2 = new FileWriter(new File(baseFile, "all.c"), StandardCharsets.UTF_8, true);){
                output2.append("\n");
                for (String string : fileNamesToAdd) {
                    output2.append("#include \"").append(string).append("\"\n");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ((includeC = element.getAnnotation(IncludeC.class)) != null) {
            void var8_17;
            stringArray = includeC.value();
            int n = stringArray.length;
            boolean bl = false;
            while (var8_17 < n) {
                resourceName = stringArray[var8_17];
                fileName = "custom-include/" + resourceName.substring(resourceName.lastIndexOf(47) + 1);
                outputFile = new File(baseFile, fileName);
                outputFile.getParentFile().mkdirs();
                try {
                    input = cls.getClassLoader().getResourceAsStream(resourceName);
                    try {
                        output = new FileOutputStream(outputFile);
                        try {
                            input.transferTo(output);
                        }
                        finally {
                            output.close();
                        }
                    }
                    finally {
                        if (input != null) {
                            input.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ++var8_17;
            }
        }
    }

    private CTarget createCTarget() {
        CTarget cTarget = new CTarget((NameProvider)new CNameProvider());
        cTarget.setLineNumbersGenerated(Boolean.parseBoolean(System.getProperty("teavm.junit.c.lineNumbers", "false")));
        return cTarget;
    }

    @Override
    boolean usesFileName() {
        return false;
    }
}

