/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.teavm.apachecommons.io.IOUtils;
import org.teavm.junit.TeaVMTestRunner;

final class TestUtil {
    private TestUtil() {
    }

    static File getOutputFile(File path, String baseName, String suffix, boolean separateDir, String extension) {
        File outputFile;
        StringBuilder simpleName = new StringBuilder();
        simpleName.append(baseName);
        if (!suffix.isEmpty() && !separateDir) {
            simpleName.append('-').append(suffix);
        }
        if (separateDir) {
            outputFile = new File(new File(path, simpleName.toString()), "test" + extension);
        } else {
            simpleName.append(extension);
            outputFile = new File(path, simpleName.toString());
        }
        return outputFile;
    }

    static void resourceToFile(String resource, File file, Map<String, String> properties) throws IOException {
        block28: {
            String content;
            file.getParentFile().mkdirs();
            if (properties.isEmpty()) {
                try (InputStream input = TeaVMTestRunner.class.getClassLoader().getResourceAsStream(resource);
                     BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));){
                    input.transferTo(output);
                    break block28;
                }
            }
            try (InputStream input = TeaVMTestRunner.class.getClassLoader().getResourceAsStream(resource);){
                content = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            }
            content = TestUtil.replaceProperties(content, properties);
            try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                 OutputStreamWriter writer = new OutputStreamWriter(output);){
                writer.write(content);
            }
        }
    }

    static String replaceProperties(String s, Map<String, String> properties) {
        int end;
        int next;
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (i < s.length() && (next = s.indexOf("${", i)) >= 0 && (end = s.indexOf(125, next + 2)) >= 0) {
            sb.append(s, i, next);
            String property = s.substring(next + 2, end);
            String value = properties.get(property);
            if (value == null) {
                sb.append(s, next, end + 1);
            } else {
                sb.append(value);
            }
            i = end + 1;
        }
        if (i == 0) {
            return s;
        }
        return sb.append(s.substring(i)).toString();
    }
}

