/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.junit;

import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.teavm.backend.wasm.WasmRuntimeType;
import org.teavm.backend.wasm.WasmTarget;
import org.teavm.backend.wasm.generate.DirectorySourceFileResolver;
import org.teavm.backend.wasm.generate.SourceFileResolver;
import org.teavm.junit.CompileResult;
import org.teavm.junit.TeaVMTestConfiguration;
import org.teavm.junit.TestNativeEntryPoint;
import org.teavm.junit.TestPlatformSupport;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ReferenceCache;
import org.teavm.vm.TeaVM;

abstract class BaseWebAssemblyPlatformSupport
extends TestPlatformSupport<WasmTarget> {
    public BaseWebAssemblyPlatformSupport(ClassHolderSource classSource, ReferenceCache referenceCache) {
        super(classSource, referenceCache);
    }

    @Override
    String getExtension() {
        return ".wasm";
    }

    protected abstract WasmRuntimeType getRuntimeType();

    @Override
    CompileResult compile(Consumer<TeaVM> additionalProcessing, String baseName, TeaVMTestConfiguration<WasmTarget> configuration, File path, AnnotatedElement element) {
        Supplier<WasmTarget> targetSupplier = () -> {
            WasmTarget target = new WasmTarget();
            target.setRuntimeType(this.getRuntimeType());
            String sourceDirs = System.getProperty("teavm.junit.sourceDirs");
            if (sourceDirs != null) {
                ArrayList<File> dirs = new ArrayList<File>();
                StringTokenizer tokenizer = new StringTokenizer(sourceDirs, Character.toString(File.pathSeparatorChar));
                while (tokenizer.hasMoreTokens()) {
                    File dir = new File(tokenizer.nextToken());
                    if (!dir.isDirectory()) continue;
                    dirs.add(dir);
                }
                if (!dirs.isEmpty()) {
                    target.setSourceFileResolver((SourceFileResolver)new DirectorySourceFileResolver(dirs));
                }
            }
            return target;
        };
        return this.compile(configuration, targetSupplier, TestNativeEntryPoint.class.getName(), path, ".wasm", null, additionalProcessing, baseName);
    }

    @Override
    boolean usesFileName() {
        return true;
    }
}

