/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.plugin;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.jso.JSBody;
import org.teavm.jso.plugin.JSBodyImpl;
import org.teavm.jso.plugin.JavascriptNativeProcessor;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;

public class JSObjectClassTransformer
implements ClassHolderTransformer {
    private JavascriptNativeProcessor processor;

    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        MethodReference functorMethod;
        if (this.processor == null || this.processor.getClassSource() != innerSource) {
            this.processor = new JavascriptNativeProcessor(innerSource);
        }
        this.processor.setDiagnostics(diagnostics);
        this.processor.processClass(cls);
        if (this.processor.isNative(cls.getName())) {
            this.processor.processFinalMethods(cls);
        }
        if (this.processor.isNativeImplementation(cls.getName())) {
            this.processor.makeSync(cls);
        }
        if ((functorMethod = this.processor.isFunctor(cls.getName())) != null && this.processor.isFunctor(cls.getParent()) == null) {
            this.processor.addFunctorField(cls, functorMethod);
        }
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            if (method.getAnnotations().get(JSBody.class.getName()) != null) {
                this.processor.processJSBody(cls, method);
                continue;
            }
            if (method.getProgram() == null || method.getAnnotations().get(JSBodyImpl.class.getName()) != null) continue;
            this.processor.processProgram(method);
        }
    }
}

