/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.teavm.dependency.PluggableDependency;
import org.teavm.javascript.spi.GeneratedBy;
import org.teavm.javascript.spi.InjectedBy;
import org.teavm.jso.JSArray;
import org.teavm.jso.JSArrayReader;
import org.teavm.jso.JSBooleanArray;
import org.teavm.jso.JSDoubleArray;
import org.teavm.jso.JSGlobal;
import org.teavm.jso.JSIntArray;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSStringArray;
import org.teavm.jso.JSStringArrayReader;
import org.teavm.jso.JSType;
import org.teavm.jso.plugin.JSNativeGenerator;

public final class JS {
    private JS() {
    }

    public static JSType getType(JSObject obj) {
        switch (JS.unwrapString(JS.getTypeName(obj))) {
            case "boolean": {
                return JSType.OBJECT;
            }
            case "number": {
                return JSType.NUMBER;
            }
            case "string": {
                return JSType.STRING;
            }
            case "function": {
                return JSType.FUNCTION;
            }
            case "object": {
                return JSType.OBJECT;
            }
            case "undefined": {
                return JSType.UNDEFINED;
            }
        }
        throw new AssertionError((Object)"Unexpected type");
    }

    public static <T extends JSObject> JSArray<T> createArray(int size) {
        return ((JSGlobal)JS.getGlobal()).newArray(size);
    }

    public static JSIntArray createIntArray(int size) {
        return ((JSGlobal)JS.getGlobal()).newIntArray(size);
    }

    public static JSStringArray createStringArray(int size) {
        return ((JSGlobal)JS.getGlobal()).newStringArray(size);
    }

    public static JSBooleanArray createBooleanArray(int size) {
        return ((JSGlobal)JS.getGlobal()).newBooleanArray(size);
    }

    public static JSDoubleArray createDoubleArray(int size) {
        return ((JSGlobal)JS.getGlobal()).newDoubleArray(size);
    }

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject getTypeName(JSObject var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject getGlobal();

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject wrap(String var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject wrap(char var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject wrap(int var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject wrap(float var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject wrap(double var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject wrap(boolean var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject wrap(byte var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject wrap(short var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject marshall(Object var0);

    public static <T extends JSObject> JSArray<T> wrap(T[] array) {
        JSArray<T> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static <T extends JSObject> JSArray<JSArray<T>> wrap(T[][] array) {
        JSArray<JSArray<JSArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static <T extends JSObject> JSArray<JSArray<JSArray<T>>> wrap(T[][][] array) {
        JSArray<JSArray<JSArray<JSArray>>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSBooleanArray wrap(boolean[] array) {
        JSBooleanArray result = JS.createBooleanArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static JSArray<JSBooleanArray> wrap(boolean[][] array) {
        JSArray<JSBooleanArray> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSArray<JSArray<JSBooleanArray>> wrap(boolean[][][] array) {
        JSArray<JSArray<JSBooleanArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSIntArray wrap(byte[] array) {
        JSIntArray result = JS.createIntArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static JSArray<JSIntArray> wrap(byte[][] array) {
        JSArray<JSIntArray> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSArray<JSArray<JSIntArray>> wrap(byte[][][] array) {
        JSArray<JSArray<JSIntArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSIntArray wrap(short[] array) {
        JSIntArray result = JS.createIntArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static JSArray<JSIntArray> wrap(short[][] array) {
        JSArray<JSIntArray> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSArray<JSArray<JSIntArray>> wrap(short[][][] array) {
        JSArray<JSArray<JSIntArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSIntArray wrap(char[] array) {
        JSIntArray result = JS.createIntArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static JSArray<JSIntArray> wrap(char[][] array) {
        JSArray<JSIntArray> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSArray<JSArray<JSIntArray>> wrap(char[][][] array) {
        JSArray<JSArray<JSIntArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSIntArray wrap(int[] array) {
        JSIntArray result = JS.createIntArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static JSArray<JSIntArray> wrap(int[][] array) {
        JSArray<JSIntArray> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSArray<JSArray<JSIntArray>> wrap(int[][][] array) {
        JSArray<JSArray<JSIntArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSStringArray wrap(String[] array) {
        JSStringArray result = JS.createStringArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static JSArray<JSStringArray> wrap(String[][] array) {
        JSArray<JSStringArray> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSArray<JSArray<JSStringArray>> wrap(String[][][] array) {
        JSArray<JSArray<JSStringArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSDoubleArray wrap(float[] array) {
        JSDoubleArray result = JS.createDoubleArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static JSArray<JSDoubleArray> wrap(float[][] array) {
        JSArray<JSDoubleArray> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSArray<JSArray<JSDoubleArray>> wrap(float[][][] array) {
        JSArray<JSArray<JSDoubleArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSDoubleArray wrap(double[] array) {
        JSDoubleArray result = JS.createDoubleArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, array[i]);
        }
        return result;
    }

    public static JSArray<JSDoubleArray> wrap(double[][] array) {
        JSArray<JSDoubleArray> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    public static JSArray<JSArray<JSDoubleArray>> wrap(double[][][] array) {
        JSArray<JSArray<JSDoubleArray>> result = JS.createArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.set(i, JS.wrap(array[i]));
        }
        return result;
    }

    @InjectedBy(value=JSNativeGenerator.class)
    public static native boolean unwrapBoolean(JSObject var0);

    public static byte unwrapByte(JSObject obj) {
        return (byte)JS.unwrapInt(obj);
    }

    public static short unwrapShort(JSObject obj) {
        return (short)JS.unwrapInt(obj);
    }

    @InjectedBy(value=JSNativeGenerator.class)
    public static native int unwrapInt(JSObject var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native float unwrapFloat(JSObject var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native double unwrapDouble(JSObject var0);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native String unwrapString(JSObject var0);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native char unwrapCharacter(JSObject var0);

    public static <T extends JSObject> T[] unwrapArray(Class<T> type, JSArray<T> array) {
        JSObject[] result = (JSObject[])Array.newInstance(type, array.getLength());
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i);
        }
        return result;
    }

    public static <T extends JSObject> T[][] unwrapArray2(Class<T> type, JSArray<JSArray<T>> array) {
        JSObject[][] result = (JSObject[][])Array.newInstance(Array.newInstance(type, 0).getClass(), array.getLength());
        for (int i = 0; i < result.length; ++i) {
            result[i] = JS.unwrapArray(type, (JSArray)((JSArray)array.get(i)));
        }
        return result;
    }

    public static <T extends JSObject> T[][][] unwrapArray3(Class<T> type, JSArray<JSArray<JSArray<T>>> array) {
        Class<?> baseType = Array.newInstance(type, 0).getClass();
        JSObject[][][] result = (JSObject[][][])Array.newInstance(Array.newInstance(baseType, 0).getClass(), array.getLength());
        for (int i = 0; i < result.length; ++i) {
            result[i] = JS.unwrapArray2(type, (JSArray)((JSArray)array.get(i)));
        }
        return result;
    }

    public static String[] unwrapStringArray(JSStringArray array) {
        String[] result = new String[array.getLength()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i);
        }
        return result;
    }

    public static String[][] unwrapStringArray2(JSArray<JSStringArray> array) {
        String[][] result = new String[array.getLength()][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = JS.unwrapStringArray((JSStringArray)array.get(i));
        }
        return result;
    }

    public static String[][][] unwrapStringArray3(JSArray<JSArray<JSStringArray>> array) {
        String[][][] result = new String[array.getLength()][][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = JS.unwrapStringArray2((JSArray)array.get(i));
        }
        return result;
    }

    @InjectedBy(value=JSNativeGenerator.class)
    public static native boolean isUndefined(JSObject var0);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12, JSObject var13);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject invoke(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9, JSObject var10, JSObject var11, JSObject var12, JSObject var13, JSObject var14);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1, JSObject var2);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1, JSObject var2, JSObject var3);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8);

    @InjectedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject instantiate(JSObject var0, JSObject var1, JSObject var2, JSObject var3, JSObject var4, JSObject var5, JSObject var6, JSObject var7, JSObject var8, JSObject var9);

    public static <T extends JSObject> Iterable<T> iterate(final JSArrayReader<T> array) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < array.getLength();
                    }

                    @Override
                    public T next() {
                        return array.get(this.index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<String> iterate(final JSStringArrayReader array) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index;

                    @Override
                    public boolean hasNext() {
                        return this.index < array.getLength();
                    }

                    @Override
                    public String next() {
                        return array.get(this.index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @InjectedBy(value=JSNativeGenerator.class)
    public static native JSObject get(JSObject var0, JSObject var1);

    @InjectedBy(value=JSNativeGenerator.class)
    public static native void set(JSObject var0, JSObject var1, JSObject var2);

    @GeneratedBy(value=JSNativeGenerator.class)
    @PluggableDependency(value=JSNativeGenerator.class)
    public static native JSObject function(JSObject var0, JSObject var1);
}

