/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.RenderingManager;
import org.teavm.backend.javascript.spi.VirtualMethodContributor;
import org.teavm.backend.javascript.spi.VirtualMethodContributorContext;
import org.teavm.jso.impl.FunctorImpl;
import org.teavm.jso.impl.JSGetterToExpose;
import org.teavm.jso.impl.JSMethodToExpose;
import org.teavm.jso.impl.JSSetterToExpose;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.spi.RendererListener;

class JSAliasRenderer
implements RendererListener,
VirtualMethodContributor {
    private static String variableChars = "abcdefghijklmnopqrstuvwxyz";
    private SourceWriter writer;
    private ListableClassReaderSource classSource;
    private JSTypeHelper typeHelper;

    JSAliasRenderer() {
    }

    public void begin(RenderingManager context, BuildTarget buildTarget) {
        this.writer = context.getWriter();
        this.classSource = context.getClassSource();
        this.typeHelper = new JSTypeHelper((ClassReaderSource)context.getClassSource());
    }

    public void complete() throws IOException {
        if (!this.hasClassesToExpose()) {
            return;
        }
        this.writer.append("let ").appendFunction("$rt_jso_marker").ws().append("=").ws().append("$rt_globals.Symbol").append("('jsoClass');").newLine();
        this.writer.append("(function()").ws().append("{").softNewLine().indent();
        this.writer.append("var c;").softNewLine();
        for (String className : this.classSource.getClassNames()) {
            PropertyInfo propInfo;
            Object method22;
            ClassReader classReader = this.classSource.get(className);
            HashMap<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();
            HashMap<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
            for (Object method22 : classReader.getMethods()) {
                Alias alias = this.getPublicAlias((MethodReader)method22);
                if (alias == null) continue;
                switch (alias.kind) {
                    case METHOD: {
                        methods.put(alias.name, method22.getDescriptor());
                        break;
                    }
                    case GETTER: {
                        propInfo = properties.computeIfAbsent(alias.name, k -> new PropertyInfo());
                        propInfo.getter = method22.getDescriptor();
                        break;
                    }
                    case SETTER: {
                        propInfo = properties.computeIfAbsent(alias.name, k -> new PropertyInfo());
                        propInfo.setter = method22.getDescriptor();
                        break;
                    }
                }
            }
            boolean isJsClassImpl = this.typeHelper.isJavaScriptImplementation(className);
            if (methods.isEmpty() && properties.isEmpty() && !isJsClassImpl) continue;
            this.writer.append("c").ws().append("=").ws().appendClass(className).append(".prototype;").softNewLine();
            if (isJsClassImpl) {
                this.writer.append("c[").appendFunction("$rt_jso_marker").append("]").ws().append("=").ws().append("true;").softNewLine();
            }
            for (Map.Entry entry : methods.entrySet()) {
                if (classReader.getMethod((MethodDescriptor)entry.getValue()) == null) continue;
                if (this.isKeyword((String)entry.getKey())) {
                    this.writer.append("c[\"").append((String)entry.getKey()).append("\"]");
                } else {
                    this.writer.append("c.").append((String)entry.getKey());
                }
                this.writer.ws().append("=").ws().append("c.").appendMethod((MethodDescriptor)entry.getValue()).append(";").softNewLine();
            }
            method22 = properties.entrySet().iterator();
            while (method22.hasNext()) {
                Map.Entry entry = (Map.Entry)method22.next();
                propInfo = (PropertyInfo)entry.getValue();
                if (propInfo.getter == null || classReader.getMethod(propInfo.getter) == null) continue;
                this.writer.append("Object.defineProperty(c,").ws().append("\"").append((String)entry.getKey()).append("\",").ws().append("{").indent().softNewLine();
                this.writer.append("get:").ws().append("c.").appendMethod(propInfo.getter);
                if (propInfo.setter != null && classReader.getMethod(propInfo.setter) != null) {
                    this.writer.append(",").softNewLine();
                    this.writer.append("set:").ws().append("c.").appendMethod(propInfo.setter);
                }
                this.writer.softNewLine().outdent().append("});").softNewLine();
            }
            FieldReader functorField = this.getFunctorField(classReader);
            if (functorField == null) continue;
            this.writeFunctor(classReader, functorField.getReference());
        }
        this.writer.outdent().append("})();").newLine();
    }

    private boolean hasClassesToExpose() {
        for (String className : this.classSource.getClassNames()) {
            ClassReader cls = this.classSource.get(className);
            if (!cls.getMethods().stream().anyMatch(method -> this.getPublicAlias((MethodReader)method) != null) && !this.typeHelper.isJavaScriptImplementation(className)) continue;
            return true;
        }
        return false;
    }

    private Alias getPublicAlias(MethodReader method) {
        AnnotationReader annot = method.getAnnotations().get(JSMethodToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.METHOD);
        }
        annot = method.getAnnotations().get(JSGetterToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.GETTER);
        }
        annot = method.getAnnotations().get(JSSetterToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.SETTER);
        }
        return null;
    }

    private FieldReader getFunctorField(ClassReader cls) {
        return cls.getField("$$jso_functor$$");
    }

    private boolean isKeyword(String id) {
        switch (id) {
            case "with": 
            case "delete": 
            case "in": 
            case "undefined": 
            case "debugger": 
            case "export": 
            case "function": 
            case "let": 
            case "var": 
            case "typeof": 
            case "yield": {
                return true;
            }
        }
        return false;
    }

    private void writeFunctor(ClassReader cls, FieldReference functorField) throws IOException {
        AnnotationReader implAnnot = cls.getAnnotations().get(FunctorImpl.class.getName());
        MethodDescriptor functorMethod = MethodDescriptor.parse((String)implAnnot.getValue("value").getString());
        String alias = cls.getMethod(functorMethod).getAnnotations().get(JSMethodToExpose.class.getName()).getValue("name").getString();
        if (alias == null) {
            return;
        }
        this.writer.append("c.jso$functor$").append(alias).ws().append("=").ws().append("function()").ws().append("{").indent().softNewLine();
        this.writer.append("if").ws().append("(!this.").appendField(functorField).append(")").ws().append("{").indent().softNewLine();
        this.writer.append("var self").ws().append('=').ws().append("this;").softNewLine();
        this.writer.append("this.").appendField(functorField).ws().append('=').ws().append("function(");
        this.appendArguments(functorMethod.parameterCount());
        this.writer.append(")").ws().append('{').indent().softNewLine();
        this.writer.append("return self.").appendMethod(functorMethod).append('(');
        this.appendArguments(functorMethod.parameterCount());
        this.writer.append(");").softNewLine();
        this.writer.outdent().append("};").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return this.").appendField(functorField).append(';').softNewLine();
        this.writer.outdent().append("};").softNewLine();
    }

    private void appendArguments(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.writer.append(',').ws();
            }
            this.writer.append(this.variableName(i));
        }
    }

    private String variableName(int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(variableChars.charAt(index % variableChars.length()));
        if ((index /= variableChars.length()) > 0) {
            sb.append(index);
        }
        return sb.toString();
    }

    public boolean isVirtual(VirtualMethodContributorContext context, MethodReference methodRef) {
        ClassReader classReader = context.getClassSource().get(methodRef.getClassName());
        if (classReader == null) {
            return false;
        }
        if (this.getFunctorField(classReader) != null) {
            return true;
        }
        MethodReader methodReader = classReader.getMethod(methodRef.getDescriptor());
        return methodReader != null && this.getPublicAlias(methodReader) != null;
    }

    static class Alias {
        final String name;
        final AliasKind kind;

        Alias(String name, AliasKind kind) {
            this.name = name;
            this.kind = kind;
        }
    }

    static enum AliasKind {
        METHOD,
        GETTER,
        SETTER;

    }

    static class PropertyInfo {
        MethodDescriptor getter;
        MethodDescriptor setter;

        PropertyInfo() {
        }
    }
}

