/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.jso.impl.JSBodyEmitter;
import org.teavm.jso.impl.JsBodyImportInfo;
import org.teavm.model.MethodReference;

class JSBodyBloatedEmitter
implements JSBodyEmitter {
    private boolean isStatic;
    private MethodReference method;
    private String script;
    private String[] parameterNames;
    private JsBodyImportInfo[] imports;

    JSBodyBloatedEmitter(boolean isStatic, MethodReference method, String script, String[] parameterNames, JsBodyImportInfo[] imports) {
        this.isStatic = isStatic;
        this.method = method;
        this.script = script;
        this.parameterNames = parameterNames;
        this.imports = imports;
    }

    @Override
    public void emit(final InjectorContext context) throws IOException {
        this.emit(context.getWriter(), new EmissionStrategy(){

            @Override
            public void emitArgument(int argument) {
                context.writeExpr(context.getArgument(argument));
            }

            @Override
            public void emitModule(String name) throws IOException {
                context.getWriter().append(context.importModule(name));
            }
        });
    }

    @Override
    public void emit(final GeneratorContext context, final SourceWriter writer, MethodReference methodRef) throws IOException {
        this.emit(writer, new EmissionStrategy(){

            @Override
            public void emitArgument(int argument) throws IOException {
                writer.append(context.getParameterName(argument + 1));
            }

            @Override
            public void emitModule(String name) throws IOException {
                writer.append(context.importModule(name));
            }
        });
    }

    private void emit(SourceWriter writer, EmissionStrategy strategy) throws IOException {
        int i;
        int i2;
        int bodyParamCount = this.isStatic ? this.method.parameterCount() : this.method.parameterCount() - 1;
        writer.append("if (!").appendMethodBody(this.method).append(".$native)").ws().append('{').indent().newLine();
        writer.appendMethodBody(this.method).append(".$native").ws().append('=').ws().append("function(");
        int count = this.method.parameterCount();
        boolean first = true;
        for (i2 = 0; i2 < count; ++i2) {
            if (!first) {
                writer.append(',').ws();
            }
            first = false;
            writer.append('_').append(i2);
        }
        for (i2 = 0; i2 < this.imports.length; ++i2) {
            if (!first) {
                writer.append(',').ws();
            }
            first = false;
            writer.append("_i").append(i2);
        }
        writer.append(')').ws().append('{').softNewLine().indent();
        writer.append("return (function(");
        first = true;
        for (i2 = 0; i2 < bodyParamCount; ++i2) {
            if (!first) {
                writer.append(',').ws();
            }
            first = false;
            String name = this.parameterNames[i2];
            writer.append(name);
        }
        for (JsBodyImportInfo importInfo : this.imports) {
            if (!first) {
                writer.append(',').ws();
            }
            first = false;
            writer.append(importInfo.alias);
        }
        writer.append(')').ws().append('{').softNewLine().indent();
        writer.append(this.script).softNewLine();
        writer.outdent().append("})");
        if (!this.isStatic) {
            writer.append(".call");
        }
        writer.append('(');
        first = true;
        for (i = 0; i < count; ++i) {
            if (!first) {
                writer.append(',').ws();
            }
            first = false;
            writer.append('_').append(i);
        }
        for (i = 0; i < this.imports.length; ++i) {
            if (!first) {
                writer.append(',').ws();
            }
            first = false;
            writer.append("_i").append(i);
        }
        writer.append(");").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.appendMethodBody(this.method).ws().append('=').ws().appendMethodBody(this.method).append(".$native;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return ").appendMethodBody(this.method).append('(');
        for (i = 0; i < count; ++i) {
            if (i > 0) {
                writer.append(',').ws();
            }
            strategy.emitArgument(i);
        }
        writer.append(");").softNewLine();
    }

    static interface EmissionStrategy {
        public void emitArgument(int var1) throws IOException;

        public void emitModule(String var1) throws IOException;
    }
}

