/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSObject;
import org.teavm.jso.core.JSArrayReader;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ReferenceCache;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.StringConstantInstruction;

class JSValueMarshaller {
    private static final ValueType stringType = ValueType.parse(String.class);
    private ReferenceCache referenceCache = new ReferenceCache();
    private Diagnostics diagnostics;
    private JSTypeHelper typeHelper;
    private ClassReaderSource classSource;
    private Program program;
    private List<Instruction> replacement;

    JSValueMarshaller(Diagnostics diagnostics, JSTypeHelper typeHelper, ClassReaderSource classSource, Program program, List<Instruction> replacement) {
        this.diagnostics = diagnostics;
        this.typeHelper = typeHelper;
        this.classSource = classSource;
        this.program = program;
        this.replacement = replacement;
    }

    Variable wrapArgument(CallLocation location, Variable var, ValueType type, boolean byRef) {
        String className;
        ClassReader cls;
        if (type instanceof ValueType.Object && (cls = this.classSource.get(className = ((ValueType.Object)type).getClassName())) != null && cls.getAnnotations().get(JSFunctor.class.getName()) != null) {
            return this.wrapFunctor(location, var, cls);
        }
        return this.wrap(var, type, location.getSourceLocation(), byRef);
    }

    boolean isProperFunctor(ClassReader type) {
        if (!type.hasModifier(ElementModifier.INTERFACE)) {
            return false;
        }
        return type.getMethods().stream().filter(method -> method.hasModifier(ElementModifier.ABSTRACT)).count() == 1L;
    }

    private Variable wrapFunctor(CallLocation location, Variable var, ClassReader type) {
        if (!this.isProperFunctor(type)) {
            this.diagnostics.error(location, "Wrong functor: {{c0}}", new Object[]{type.getName()});
            return var;
        }
        String name = type.getMethods().stream().filter(method -> method.hasModifier(ElementModifier.ABSTRACT)).findFirst().get().getName();
        Variable functor = this.program.createVariable();
        Variable nameVar = this.addStringWrap(this.addString(name, location.getSourceLocation()), location.getSourceLocation());
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(JSMethods.FUNCTION);
        insn.setReceiver(functor);
        insn.setArguments(new Variable[]{var, nameVar});
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return functor;
    }

    Variable wrap(Variable var, ValueType type, TextLocation location, boolean byRef) {
        String className;
        if (byRef) {
            InvokeInstruction insn = new InvokeInstruction();
            insn.setMethod(JSMethods.ARRAY_DATA);
            insn.setReceiver(this.program.createVariable());
            insn.setType(InvocationType.SPECIAL);
            insn.setArguments(new Variable[]{var});
            this.replacement.add((Instruction)insn);
            return insn.getReceiver();
        }
        if (type instanceof ValueType.Object && !(className = ((ValueType.Object)type).getClassName()).equals("java.lang.String")) {
            return var;
        }
        Variable result = this.program.createVariable();
        ValueType itemType = type;
        int degree = 0;
        while (itemType instanceof ValueType.Array) {
            itemType = ((ValueType.Array)itemType).getItemType();
            ++degree;
        }
        if (degree <= 1) {
            InvokeInstruction insn = new InvokeInstruction();
            insn.setMethod(this.referenceCache.getCached(new MethodReference(JS.class.getName(), "wrap", new ValueType[]{this.getWrappedType(type), this.getWrapperType(type)})));
            insn.setArguments(new Variable[]{var});
            insn.setReceiver(result);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
        } else {
            Variable function = this.program.createVariable();
            InvokeInstruction insn = new InvokeInstruction();
            insn.setMethod(this.getWrapperFunction(itemType));
            insn.setReceiver(function);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
            while (--degree > 1) {
                insn = new InvokeInstruction();
                insn.setMethod(JSMethods.ARRAY_MAPPER);
                insn.setArguments(new Variable[]{function});
                function = this.program.createVariable();
                insn.setReceiver(function);
                insn.setType(InvocationType.SPECIAL);
                insn.setLocation(location);
                this.replacement.add((Instruction)insn);
            }
            insn = new InvokeInstruction();
            insn.setMethod(this.referenceCache.getCached(new MethodReference(JS.class.getName(), "map", new ValueType[]{this.getWrappedType(type), ValueType.parse(Function.class), this.getWrapperType(type)})));
            insn.setArguments(new Variable[]{var, function});
            insn.setReceiver(result);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
        }
        return result;
    }

    private ValueType getWrappedType(ValueType type) {
        if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            if (itemType instanceof ValueType.Array) {
                return ValueType.parse(Object[].class);
            }
            return ValueType.arrayOf((ValueType)this.getWrappedType(itemType));
        }
        if (type instanceof ValueType.Object) {
            if (type.isObject(String.class)) {
                return type;
            }
            return JSMethods.JS_OBJECT;
        }
        return type;
    }

    private ValueType getWrapperType(ValueType type) {
        if (type instanceof ValueType.Array) {
            return JSMethods.JS_ARRAY;
        }
        return JSMethods.JS_OBJECT;
    }

    private MethodReference getWrapperFunction(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return JSMethods.BOOLEAN_ARRAY_WRAPPER;
                }
                case BYTE: {
                    return JSMethods.BYTE_ARRAY_WRAPPER;
                }
                case SHORT: {
                    return JSMethods.SHORT_ARRAY_WRAPPER;
                }
                case CHARACTER: {
                    return JSMethods.CHAR_ARRAY_WRAPPER;
                }
                case INTEGER: {
                    return JSMethods.INT_ARRAY_WRAPPER;
                }
                case FLOAT: {
                    return JSMethods.FLOAT_ARRAY_WRAPPER;
                }
                case DOUBLE: {
                    return JSMethods.DOUBLE_ARRAY_WRAPPER;
                }
            }
        } else if (type.isObject(String.class)) {
            return JSMethods.STRING_ARRAY_WRAPPER;
        }
        return JSMethods.ARRAY_WRAPPER;
    }

    Variable unwrapReturnValue(CallLocation location, Variable var, ValueType type, boolean byRef) {
        String className;
        ClassReader cls;
        if (byRef) {
            return this.unwrapByRef(location, var, type);
        }
        if (type instanceof ValueType.Object && (cls = this.classSource.get(className = ((ValueType.Object)type).getClassName())) != null && cls.getAnnotations().get(JSFunctor.class.getName()) != null) {
            return this.unwrapFunctor(location, var, cls);
        }
        return this.unwrap(location, var, type);
    }

    private Variable unwrapByRef(CallLocation location, Variable var, ValueType type) {
        if ((type = ((ValueType.Array)type).getItemType()) instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BYTE: {
                    return this.invokeMethod(location, JSMethods.DATA_TO_BYTE_ARRAY, var);
                }
                case SHORT: {
                    return this.invokeMethod(location, JSMethods.DATA_TO_SHORT_ARRAY, var);
                }
                case CHARACTER: {
                    return this.invokeMethod(location, JSMethods.DATA_TO_CHAR_ARRAY, var);
                }
                case INTEGER: {
                    return this.invokeMethod(location, JSMethods.DATA_TO_INT_ARRAY, var);
                }
                case FLOAT: {
                    return this.invokeMethod(location, JSMethods.DATA_TO_FLOAT_ARRAY, var);
                }
                case DOUBLE: {
                    return this.invokeMethod(location, JSMethods.DATA_TO_DOUBLE_ARRAY, var);
                }
            }
        }
        return this.invokeMethod(location, JSMethods.DATA_TO_ARRAY, var);
    }

    Variable unwrap(CallLocation location, Variable var, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.unwrap(var, "unwrapBoolean", JSMethods.JS_OBJECT, (ValueType)ValueType.BOOLEAN, location.getSourceLocation());
                }
                case BYTE: {
                    return this.unwrap(var, "unwrapByte", JSMethods.JS_OBJECT, (ValueType)ValueType.BYTE, location.getSourceLocation());
                }
                case SHORT: {
                    return this.unwrap(var, "unwrapShort", JSMethods.JS_OBJECT, (ValueType)ValueType.SHORT, location.getSourceLocation());
                }
                case INTEGER: {
                    return this.unwrap(var, "unwrapInt", JSMethods.JS_OBJECT, (ValueType)ValueType.INTEGER, location.getSourceLocation());
                }
                case CHARACTER: {
                    return this.unwrap(var, "unwrapCharacter", JSMethods.JS_OBJECT, (ValueType)ValueType.CHARACTER, location.getSourceLocation());
                }
                case DOUBLE: {
                    return this.unwrap(var, "unwrapDouble", JSMethods.JS_OBJECT, (ValueType)ValueType.DOUBLE, location.getSourceLocation());
                }
                case FLOAT: {
                    return this.unwrap(var, "unwrapFloat", JSMethods.JS_OBJECT, (ValueType)ValueType.FLOAT, location.getSourceLocation());
                }
            }
        } else if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            if (className.equals(JSObject.class.getName())) {
                return var;
            }
            if (className.equals("java.lang.String")) {
                return this.unwrap(var, "unwrapString", JSMethods.JS_OBJECT, stringType, location.getSourceLocation());
            }
            if (this.typeHelper.isJavaScriptClass(className)) {
                Variable result = this.program.createVariable();
                CastInstruction castInsn = new CastInstruction();
                castInsn.setReceiver(result);
                castInsn.setValue(var);
                castInsn.setTargetType(type);
                castInsn.setLocation(location.getSourceLocation());
                this.replacement.add((Instruction)castInsn);
                return result;
            }
        } else if (type instanceof ValueType.Array) {
            return this.unwrapArray(location, var, (ValueType.Array)type);
        }
        this.diagnostics.error(location, "Unsupported type: {{t0}}", new Object[]{type});
        return var;
    }

    private Variable unwrapArray(CallLocation location, Variable var, ValueType.Array type) {
        ValueType.Array itemType = type;
        int degree = 0;
        while (itemType instanceof ValueType.Array) {
            ++degree;
            itemType = itemType.getItemType();
        }
        CastInstruction castInsn = new CastInstruction();
        castInsn.setValue(var);
        castInsn.setTargetType(ValueType.parse(JSArrayReader.class));
        var = this.program.createVariable();
        castInsn.setReceiver(var);
        castInsn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)castInsn);
        var = degree == 1 ? this.unwrapSingleDimensionArray(location, var, (ValueType)itemType) : this.unwrapMultiDimensionArray(location, var, (ValueType)itemType, degree);
        return var;
    }

    private Variable invokeMethod(CallLocation location, MethodReference method, Variable var) {
        InvokeInstruction invoke = new InvokeInstruction();
        invoke.setArguments(new Variable[]{var});
        invoke.setMethod(method);
        invoke.setReceiver(this.program.createVariable());
        invoke.setType(InvocationType.SPECIAL);
        invoke.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)invoke);
        return invoke.getReceiver();
    }

    private Variable unwrapSingleDimensionArray(CallLocation location, Variable var, ValueType type) {
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(this.singleDimensionArrayUnwrapper(type));
        insn.setType(InvocationType.SPECIAL);
        ArrayList<Variable> args = new ArrayList<Variable>();
        if (insn.getMethod().parameterCount() == 2) {
            Variable cls = this.program.createVariable();
            ClassConstantInstruction clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            args.add(cls);
        }
        args.add(var);
        insn.setArguments(args.toArray(new Variable[0]));
        insn.setReceiver(result);
        this.replacement.add((Instruction)insn);
        return result;
    }

    private Variable unwrapMultiDimensionArray(CallLocation location, Variable var, ValueType type, int degree) {
        ClassConstantInstruction clsInsn;
        Variable cls;
        Variable function = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(this.multipleDimensionArrayUnwrapper(type));
        insn.setType(InvocationType.SPECIAL);
        if (insn.getMethod().parameterCount() == 1) {
            cls = this.program.createVariable();
            clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            insn.setArguments(new Variable[]{cls});
        }
        insn.setReceiver(function);
        this.replacement.add((Instruction)insn);
        while (--degree > 1) {
            type = ValueType.arrayOf((ValueType)type);
            cls = this.program.createVariable();
            clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            insn = new InvokeInstruction();
            insn.setMethod(JSMethods.ARRAY_UNMAPPER);
            insn.setType(InvocationType.SPECIAL);
            insn.setArguments(new Variable[]{cls, function});
            function = this.program.createVariable();
            insn.setReceiver(function);
            this.replacement.add((Instruction)insn);
        }
        cls = this.program.createVariable();
        clsInsn = new ClassConstantInstruction();
        clsInsn.setConstant(ValueType.arrayOf((ValueType)type));
        clsInsn.setLocation(location.getSourceLocation());
        clsInsn.setReceiver(cls);
        this.replacement.add((Instruction)clsInsn);
        insn = new InvokeInstruction();
        insn.setMethod(JSMethods.UNMAP_ARRAY);
        insn.setArguments(new Variable[]{cls, var, function});
        insn.setReceiver(var);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return var;
    }

    private MethodReference singleDimensionArrayUnwrapper(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BOOLEAN: {
                    return JSMethods.UNWRAP_BOOLEAN_ARRAY;
                }
                case BYTE: {
                    return JSMethods.UNWRAP_BYTE_ARRAY;
                }
                case SHORT: {
                    return JSMethods.UNWRAP_SHORT_ARRAY;
                }
                case CHARACTER: {
                    return JSMethods.UNWRAP_CHAR_ARRAY;
                }
                case INTEGER: {
                    return JSMethods.UNWRAP_INT_ARRAY;
                }
                case FLOAT: {
                    return JSMethods.UNWRAP_FLOAT_ARRAY;
                }
                case DOUBLE: {
                    return JSMethods.UNWRAP_DOUBLE_ARRAY;
                }
            }
        } else if (itemType.isObject(String.class)) {
            return JSMethods.UNWRAP_STRING_ARRAY;
        }
        return JSMethods.UNWRAP_ARRAY;
    }

    private MethodReference multipleDimensionArrayUnwrapper(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BOOLEAN: {
                    return JSMethods.BOOLEAN_ARRAY_UNWRAPPER;
                }
                case BYTE: {
                    return JSMethods.BYTE_ARRAY_UNWRAPPER;
                }
                case SHORT: {
                    return JSMethods.SHORT_ARRAY_UNWRAPPER;
                }
                case CHARACTER: {
                    return JSMethods.CHAR_ARRAY_UNWRAPPER;
                }
                case INTEGER: {
                    return JSMethods.INT_ARRAY_UNWRAPPER;
                }
                case FLOAT: {
                    return JSMethods.FLOAT_ARRAY_UNWRAPPER;
                }
                case DOUBLE: {
                    return JSMethods.DOUBLE_ARRAY_UNWRAPPER;
                }
            }
        } else if (itemType.isObject(String.class)) {
            return JSMethods.STRING_ARRAY_UNWRAPPER;
        }
        return JSMethods.ARRAY_UNWRAPPER;
    }

    private Variable unwrap(Variable var, String methodName, ValueType argType, ValueType resultType, TextLocation location) {
        if (!argType.isObject(JSObject.class.getName())) {
            Variable castValue = this.program.createVariable();
            CastInstruction castInsn = new CastInstruction();
            castInsn.setValue(var);
            castInsn.setReceiver(castValue);
            castInsn.setLocation(location);
            castInsn.setTargetType(argType);
            this.replacement.add((Instruction)castInsn);
            var = castValue;
        }
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(this.referenceCache.getCached(this.referenceCache.getCached(new MethodReference(JS.class.getName(), methodName, new ValueType[]{argType, resultType}))));
        insn.setArguments(new Variable[]{var});
        insn.setReceiver(result);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
        return result;
    }

    Variable unwrapFunctor(CallLocation location, Variable var, ClassReader type) {
        if (!this.isProperFunctor(type)) {
            this.diagnostics.error(location, "Wrong functor: {{c0}}", new Object[]{type.getName()});
            return var;
        }
        String name = type.getMethods().stream().filter(method -> method.hasModifier(ElementModifier.ABSTRACT)).findFirst().get().getName();
        Variable functor = this.program.createVariable();
        Variable nameVar = this.addStringWrap(this.addString(name, location.getSourceLocation()), location.getSourceLocation());
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(JSMethods.FUNCTION_AS_OBJECT);
        insn.setReceiver(functor);
        insn.setArguments(new Variable[]{var, nameVar});
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return functor;
    }

    Variable addStringWrap(Variable var, TextLocation location) {
        return this.wrap(var, stringType, location, false);
    }

    Variable addString(String str, TextLocation location) {
        Variable var = this.program.createVariable();
        StringConstantInstruction nameInsn = new StringConstantInstruction();
        nameInsn.setReceiver(var);
        nameInsn.setConstant(str);
        nameInsn.setLocation(location);
        this.replacement.add((Instruction)nameInsn);
        return var;
    }
}

