/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.RenderingManager;
import org.teavm.backend.javascript.spi.VirtualMethodContributor;
import org.teavm.backend.javascript.spi.VirtualMethodContributorContext;
import org.teavm.jso.impl.FunctorImpl;
import org.teavm.jso.impl.JSMethodToExpose;
import org.teavm.model.AnnotationReader;
import org.teavm.model.ClassReader;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.spi.RendererListener;

class JSAliasRenderer
implements RendererListener,
VirtualMethodContributor {
    private static String variableChars = "abcdefghijklmnopqrstuvwxyz";
    private SourceWriter writer;
    private ListableClassReaderSource classSource;

    JSAliasRenderer() {
    }

    public void begin(RenderingManager context, BuildTarget buildTarget) {
        this.writer = context.getWriter();
        this.classSource = context.getClassSource();
    }

    public void complete() throws IOException {
        if (!this.hasClassesToExpose()) {
            return;
        }
        this.writer.append("(function()").ws().append("{").softNewLine().indent();
        this.writer.append("var c;").softNewLine();
        for (String className : this.classSource.getClassNames()) {
            Object method2;
            ClassReader classReader = this.classSource.get(className);
            HashMap<MethodDescriptor, String> methods = new HashMap<MethodDescriptor, String>();
            for (Object method2 : classReader.getMethods()) {
                String methodAlias = this.getPublicAlias((MethodReader)method2);
                if (methodAlias == null) continue;
                methods.put(method2.getDescriptor(), methodAlias);
            }
            if (methods.isEmpty()) continue;
            boolean first = true;
            method2 = methods.entrySet().iterator();
            while (method2.hasNext()) {
                Map.Entry aliasEntry = (Map.Entry)method2.next();
                if (classReader.getMethod((MethodDescriptor)aliasEntry.getKey()) == null) continue;
                if (first) {
                    this.writer.append("c").ws().append("=").ws().appendClass(className).append(".prototype;").softNewLine();
                    first = false;
                }
                if (this.isKeyword((String)aliasEntry.getValue())) {
                    this.writer.append("c[\"").append((String)aliasEntry.getValue()).append("\"]");
                } else {
                    this.writer.append("c.").append((String)aliasEntry.getValue());
                }
                this.writer.ws().append("=").ws().append("c.").appendMethod((MethodDescriptor)aliasEntry.getKey()).append(";").softNewLine();
            }
            FieldReader functorField = this.getFunctorField(classReader);
            if (functorField == null) continue;
            this.writeFunctor(classReader, functorField.getReference());
        }
        this.writer.outdent().append("})();").newLine();
    }

    private boolean hasClassesToExpose() {
        for (String className : this.classSource.getClassNames()) {
            ClassReader cls = this.classSource.get(className);
            if (!cls.getMethods().stream().anyMatch(method -> this.getPublicAlias((MethodReader)method) != null)) continue;
            return true;
        }
        return false;
    }

    private String getPublicAlias(MethodReader method) {
        AnnotationReader annot = method.getAnnotations().get(JSMethodToExpose.class.getName());
        return annot != null ? annot.getValue("name").getString() : null;
    }

    private FieldReader getFunctorField(ClassReader cls) {
        return cls.getField("$$jso_functor$$");
    }

    private boolean isKeyword(String id) {
        switch (id) {
            case "with": 
            case "delete": 
            case "in": 
            case "undefined": 
            case "debugger": 
            case "export": 
            case "function": 
            case "let": 
            case "var": 
            case "typeof": 
            case "yield": {
                return true;
            }
        }
        return false;
    }

    private void writeFunctor(ClassReader cls, FieldReference functorField) throws IOException {
        AnnotationReader implAnnot = cls.getAnnotations().get(FunctorImpl.class.getName());
        MethodDescriptor functorMethod = MethodDescriptor.parse((String)implAnnot.getValue("value").getString());
        String alias = cls.getMethod(functorMethod).getAnnotations().get(JSMethodToExpose.class.getName()).getValue("name").getString();
        if (alias == null) {
            return;
        }
        this.writer.append("c.jso$functor$").append(alias).ws().append("=").ws().append("function()").ws().append("{").indent().softNewLine();
        this.writer.append("if").ws().append("(!this.").appendField(functorField).append(")").ws().append("{").indent().softNewLine();
        this.writer.append("var self").ws().append('=').ws().append("this;").softNewLine();
        this.writer.append("this.").appendField(functorField).ws().append('=').ws().append("function(");
        this.appendArguments(functorMethod.parameterCount());
        this.writer.append(")").ws().append('{').indent().softNewLine();
        this.writer.append("return self.").appendMethod(functorMethod).append('(');
        this.appendArguments(functorMethod.parameterCount());
        this.writer.append(");").softNewLine();
        this.writer.outdent().append("};").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return this.").appendField(functorField).append(';').softNewLine();
        this.writer.outdent().append("};").softNewLine();
    }

    private void appendArguments(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.writer.append(',').ws();
            }
            this.writer.append(this.variableName(i));
        }
    }

    private String variableName(int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(variableChars.charAt(index % variableChars.length()));
        if ((index /= variableChars.length()) > 0) {
            sb.append(index);
        }
        return sb.toString();
    }

    public boolean isVirtual(VirtualMethodContributorContext context, MethodReference methodRef) {
        ClassReader classReader = context.getClassSource().get(methodRef.getClassName());
        if (classReader == null) {
            return false;
        }
        if (this.getFunctorField(classReader) != null) {
            return true;
        }
        MethodReader methodReader = classReader.getMethod(methodRef.getDescriptor());
        return methodReader != null && this.getPublicAlias(methodReader) != null;
    }
}

