/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.List;
import java.util.function.Function;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSObject;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSArrayReader;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.StringConstantInstruction;

class JSValueMarshaller {
    private Diagnostics diagnostics;
    private JSTypeHelper typeHelper;
    private ClassReaderSource classSource;
    private Program program;
    private List<Instruction> replacement;

    JSValueMarshaller(Diagnostics diagnostics, JSTypeHelper typeHelper, ClassReaderSource classSource, Program program, List<Instruction> replacement) {
        this.diagnostics = diagnostics;
        this.typeHelper = typeHelper;
        this.classSource = classSource;
        this.program = program;
        this.replacement = replacement;
    }

    Variable wrapArgument(CallLocation location, Variable var, ValueType type, boolean byRef) {
        String className;
        ClassReader cls;
        if (type instanceof ValueType.Object && (cls = this.classSource.get(className = ((ValueType.Object)type).getClassName())).getAnnotations().get(JSFunctor.class.getName()) != null) {
            return this.wrapFunctor(location, var, cls);
        }
        return this.wrap(var, type, location.getSourceLocation(), byRef);
    }

    boolean isProperFunctor(ClassReader type) {
        if (!type.hasModifier(ElementModifier.INTERFACE)) {
            return false;
        }
        return type.getMethods().stream().filter(method -> method.hasModifier(ElementModifier.ABSTRACT)).count() == 1L;
    }

    private Variable wrapFunctor(CallLocation location, Variable var, ClassReader type) {
        if (!this.isProperFunctor(type)) {
            this.diagnostics.error(location, "Wrong functor: {{c0}}", new Object[]{type.getName()});
            return var;
        }
        String name = type.getMethods().stream().filter(method -> method.hasModifier(ElementModifier.ABSTRACT)).findFirst().get().getName();
        Variable functor = this.program.createVariable();
        Variable nameVar = this.addStringWrap(this.addString(name, location.getSourceLocation()), location.getSourceLocation());
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "function", new Class[]{JSObject.class, JSObject.class, JSObject.class}));
        insn.setReceiver(functor);
        insn.getArguments().add(var);
        insn.getArguments().add(nameVar);
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return functor;
    }

    Variable wrap(Variable var, ValueType type, TextLocation location, boolean byRef) {
        String className;
        if (byRef) {
            InvokeInstruction insn = new InvokeInstruction();
            insn.setMethod(new MethodReference(JS.class, "arrayData", new Class[]{Object.class, JSObject.class}));
            insn.setReceiver(this.program.createVariable());
            insn.setType(InvocationType.SPECIAL);
            insn.getArguments().add(var);
            this.replacement.add((Instruction)insn);
            return insn.getReceiver();
        }
        if (type instanceof ValueType.Object && !(className = ((ValueType.Object)type).getClassName()).equals("java.lang.String")) {
            return var;
        }
        Variable result = this.program.createVariable();
        ValueType itemType = type;
        int degree = 0;
        while (itemType instanceof ValueType.Array) {
            itemType = ((ValueType.Array)itemType).getItemType();
            ++degree;
        }
        if (degree <= 1) {
            InvokeInstruction insn = new InvokeInstruction();
            insn.setMethod(new MethodReference(JS.class.getName(), "wrap", new ValueType[]{this.getWrappedType(type), this.getWrapperType(type)}));
            insn.getArguments().add(var);
            insn.setReceiver(result);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
        } else {
            Variable function = this.program.createVariable();
            InvokeInstruction insn = new InvokeInstruction();
            insn.setMethod(this.getWrapperFunction(itemType));
            insn.setReceiver(function);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
            while (--degree > 1) {
                insn = new InvokeInstruction();
                insn.setMethod(new MethodReference(JS.class, "arrayMapper", new Class[]{Function.class, Function.class}));
                insn.getArguments().add(function);
                function = this.program.createVariable();
                insn.setReceiver(function);
                insn.setType(InvocationType.SPECIAL);
                insn.setLocation(location);
                this.replacement.add((Instruction)insn);
            }
            insn = new InvokeInstruction();
            insn.setMethod(new MethodReference(JS.class.getName(), "map", new ValueType[]{this.getWrappedType(type), ValueType.parse(Function.class), this.getWrapperType(type)}));
            insn.getArguments().add(var);
            insn.getArguments().add(function);
            insn.setReceiver(result);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
        }
        return result;
    }

    private ValueType getWrappedType(ValueType type) {
        if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            if (itemType instanceof ValueType.Array) {
                return ValueType.parse(Object[].class);
            }
            return ValueType.arrayOf((ValueType)this.getWrappedType(itemType));
        }
        if (type instanceof ValueType.Object) {
            if (type.isObject(String.class)) {
                return type;
            }
            return ValueType.parse(JSObject.class);
        }
        return type;
    }

    private ValueType getWrapperType(ValueType type) {
        if (type instanceof ValueType.Array) {
            return ValueType.parse(JSArray.class);
        }
        return ValueType.parse(JSObject.class);
    }

    private MethodReference getWrapperFunction(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return new MethodReference(JS.class, "booleanArrayWrapper", new Class[]{Function.class});
                }
                case BYTE: {
                    return new MethodReference(JS.class, "byteArrayWrapper", new Class[]{Function.class});
                }
                case SHORT: {
                    return new MethodReference(JS.class, "shortArrayWrapper", new Class[]{Function.class});
                }
                case CHARACTER: {
                    return new MethodReference(JS.class, "charArrayWrapper", new Class[]{Function.class});
                }
                case INTEGER: {
                    return new MethodReference(JS.class, "intArrayWrapper", new Class[]{Function.class});
                }
                case FLOAT: {
                    return new MethodReference(JS.class, "floatArrayWrapper", new Class[]{Function.class});
                }
                case DOUBLE: {
                    return new MethodReference(JS.class, "doubleArrayWrapper", new Class[]{Function.class});
                }
            }
        } else if (type.isObject(String.class)) {
            return new MethodReference(JS.class, "stringArrayWrapper", new Class[]{Function.class});
        }
        return new MethodReference(JS.class, "arrayWrapper", new Class[]{Function.class});
    }

    Variable unwrapReturnValue(CallLocation location, Variable var, ValueType type) {
        String className;
        ClassReader cls;
        if (type instanceof ValueType.Object && (cls = this.classSource.get(className = ((ValueType.Object)type).getClassName())).getAnnotations().get(JSFunctor.class.getName()) != null) {
            return this.unwrapFunctor(location, var, cls);
        }
        return this.unwrap(location, var, type);
    }

    Variable unwrap(CallLocation location, Variable var, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.unwrap(var, "unwrapBoolean", ValueType.parse(JSObject.class), (ValueType)ValueType.BOOLEAN, location.getSourceLocation());
                }
                case BYTE: {
                    return this.unwrap(var, "unwrapByte", ValueType.parse(JSObject.class), (ValueType)ValueType.BYTE, location.getSourceLocation());
                }
                case SHORT: {
                    return this.unwrap(var, "unwrapShort", ValueType.parse(JSObject.class), (ValueType)ValueType.SHORT, location.getSourceLocation());
                }
                case INTEGER: {
                    return this.unwrap(var, "unwrapInt", ValueType.parse(JSObject.class), (ValueType)ValueType.INTEGER, location.getSourceLocation());
                }
                case CHARACTER: {
                    return this.unwrap(var, "unwrapCharacter", ValueType.parse(JSObject.class), (ValueType)ValueType.CHARACTER, location.getSourceLocation());
                }
                case DOUBLE: {
                    return this.unwrap(var, "unwrapDouble", ValueType.parse(JSObject.class), (ValueType)ValueType.DOUBLE, location.getSourceLocation());
                }
                case FLOAT: {
                    return this.unwrap(var, "unwrapFloat", ValueType.parse(JSObject.class), (ValueType)ValueType.FLOAT, location.getSourceLocation());
                }
            }
        } else if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            if (className.equals(JSObject.class.getName())) {
                return var;
            }
            if (className.equals("java.lang.String")) {
                return this.unwrap(var, "unwrapString", ValueType.parse(JSObject.class), ValueType.parse(String.class), location.getSourceLocation());
            }
            if (this.typeHelper.isJavaScriptClass(className)) {
                Variable result = this.program.createVariable();
                CastInstruction castInsn = new CastInstruction();
                castInsn.setReceiver(result);
                castInsn.setValue(var);
                castInsn.setTargetType(type);
                castInsn.setLocation(location.getSourceLocation());
                this.replacement.add((Instruction)castInsn);
                return result;
            }
        } else if (type instanceof ValueType.Array) {
            return this.unwrapArray(location, var, (ValueType.Array)type);
        }
        this.diagnostics.error(location, "Unsupported type: {{t0}}", new Object[]{type});
        return var;
    }

    private Variable unwrapArray(CallLocation location, Variable var, ValueType.Array type) {
        ValueType.Array itemType = type;
        int degree = 0;
        while (itemType instanceof ValueType.Array) {
            ++degree;
            itemType = itemType.getItemType();
        }
        CastInstruction castInsn = new CastInstruction();
        castInsn.setValue(var);
        castInsn.setTargetType(ValueType.parse(JSArrayReader.class));
        var = this.program.createVariable();
        castInsn.setReceiver(var);
        castInsn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)castInsn);
        var = degree == 1 ? this.unwrapSingleDimensionArray(location, var, (ValueType)itemType) : this.unwrapMultiDimensionArray(location, var, (ValueType)itemType, degree);
        return var;
    }

    private Variable unwrapSingleDimensionArray(CallLocation location, Variable var, ValueType type) {
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(this.singleDimensionArrayUnwrapper(type));
        insn.setType(InvocationType.SPECIAL);
        if (insn.getMethod().parameterCount() == 2) {
            Variable cls = this.program.createVariable();
            ClassConstantInstruction clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            insn.getArguments().add(cls);
        }
        insn.getArguments().add(var);
        insn.setReceiver(result);
        this.replacement.add((Instruction)insn);
        return result;
    }

    private Variable unwrapMultiDimensionArray(CallLocation location, Variable var, ValueType type, int degree) {
        ClassConstantInstruction clsInsn;
        Variable cls;
        Variable function = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(this.multipleDimensionArrayUnwrapper(type));
        insn.setType(InvocationType.SPECIAL);
        if (insn.getMethod().parameterCount() == 1) {
            cls = this.program.createVariable();
            clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            insn.getArguments().add(cls);
        }
        insn.setReceiver(function);
        this.replacement.add((Instruction)insn);
        while (--degree > 1) {
            type = ValueType.arrayOf((ValueType)type);
            cls = this.program.createVariable();
            clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            insn = new InvokeInstruction();
            insn.setMethod(new MethodReference(JS.class, "arrayUnmapper", new Class[]{Class.class, Function.class, Function.class}));
            insn.setType(InvocationType.SPECIAL);
            insn.getArguments().add(cls);
            insn.getArguments().add(function);
            function = this.program.createVariable();
            insn.setReceiver(function);
            this.replacement.add((Instruction)insn);
        }
        cls = this.program.createVariable();
        clsInsn = new ClassConstantInstruction();
        clsInsn.setConstant(ValueType.arrayOf((ValueType)type));
        clsInsn.setLocation(location.getSourceLocation());
        clsInsn.setReceiver(cls);
        this.replacement.add((Instruction)clsInsn);
        insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(JS.class, "unmapArray", new Class[]{Class.class, JSArrayReader.class, Function.class, Object[].class}));
        insn.getArguments().add(cls);
        insn.getArguments().add(var);
        insn.getArguments().add(function);
        insn.setReceiver(var);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return var;
    }

    private MethodReference singleDimensionArrayUnwrapper(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BOOLEAN: {
                    return new MethodReference(JS.class, "unwrapBooleanArray", new Class[]{JSArrayReader.class, boolean[].class});
                }
                case BYTE: {
                    return new MethodReference(JS.class, "unwrapByteArray", new Class[]{JSArrayReader.class, byte[].class});
                }
                case SHORT: {
                    return new MethodReference(JS.class, "unwrapShortArray", new Class[]{JSArrayReader.class, short[].class});
                }
                case CHARACTER: {
                    return new MethodReference(JS.class, "unwrapCharArray", new Class[]{JSArrayReader.class, char[].class});
                }
                case INTEGER: {
                    return new MethodReference(JS.class, "unwrapIntArray", new Class[]{JSArrayReader.class, int[].class});
                }
                case FLOAT: {
                    return new MethodReference(JS.class, "unwrapFloatArray", new Class[]{JSArrayReader.class, float[].class});
                }
                case DOUBLE: {
                    return new MethodReference(JS.class, "unwrapDoubleArray", new Class[]{JSArrayReader.class, double[].class});
                }
            }
        } else if (itemType.isObject(String.class)) {
            return new MethodReference(JS.class, "unwrapStringArray", new Class[]{JSArrayReader.class, String[].class});
        }
        return new MethodReference(JS.class, "unwrapArray", new Class[]{Class.class, JSArrayReader.class, JSObject[].class});
    }

    private MethodReference multipleDimensionArrayUnwrapper(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BOOLEAN: {
                    return new MethodReference(JS.class, "booleanArrayUnwrapper", new Class[]{Function.class});
                }
                case BYTE: {
                    return new MethodReference(JS.class, "byteArrayUnwrapper", new Class[]{Function.class});
                }
                case SHORT: {
                    return new MethodReference(JS.class, "shortArrayUnwrapper", new Class[]{Function.class});
                }
                case CHARACTER: {
                    return new MethodReference(JS.class, "charArrayUnwrapper", new Class[]{Function.class});
                }
                case INTEGER: {
                    return new MethodReference(JS.class, "intArrayUnwrapper", new Class[]{Function.class});
                }
                case FLOAT: {
                    return new MethodReference(JS.class, "floatArrayUnwrapper", new Class[]{Function.class});
                }
                case DOUBLE: {
                    return new MethodReference(JS.class, "doubleArrayUnwrapper", new Class[]{Function.class});
                }
            }
        } else if (itemType.isObject(String.class)) {
            return new MethodReference(JS.class, "stringArrayUnwrapper", new Class[]{Function.class});
        }
        return new MethodReference(JS.class, "arrayUnwrapper", new Class[]{Class.class, Function.class});
    }

    private Variable unwrap(Variable var, String methodName, ValueType argType, ValueType resultType, TextLocation location) {
        if (!argType.isObject(JSObject.class.getName())) {
            Variable castValue = this.program.createVariable();
            CastInstruction castInsn = new CastInstruction();
            castInsn.setValue(var);
            castInsn.setReceiver(castValue);
            castInsn.setLocation(location);
            castInsn.setTargetType(argType);
            this.replacement.add((Instruction)castInsn);
            var = castValue;
        }
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(JS.class.getName(), methodName, new ValueType[]{argType, resultType}));
        insn.getArguments().add(var);
        insn.setReceiver(result);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
        return result;
    }

    private Variable unwrapFunctor(CallLocation location, Variable var, ClassReader type) {
        if (!this.isProperFunctor(type)) {
            this.diagnostics.error(location, "Wrong functor: {{c0}}", new Object[]{type.getName()});
            return var;
        }
        String name = type.getMethods().stream().filter(method -> method.hasModifier(ElementModifier.ABSTRACT)).findFirst().get().getName();
        Variable functor = this.program.createVariable();
        Variable nameVar = this.addStringWrap(this.addString(name, location.getSourceLocation()), location.getSourceLocation());
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "functionAsObject", new Class[]{JSObject.class, JSObject.class, JSObject.class}));
        insn.setReceiver(functor);
        insn.getArguments().add(var);
        insn.getArguments().add(nameVar);
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return functor;
    }

    Variable addStringWrap(Variable var, TextLocation location) {
        return this.wrap(var, ValueType.object((String)"java.lang.String"), location, false);
    }

    Variable addString(String str, TextLocation location) {
        Variable var = this.program.createVariable();
        StringConstantInstruction nameInsn = new StringConstantInstruction();
        nameInsn.setReceiver(var);
        nameInsn.setConstant(str);
        nameInsn.setLocation(location);
        this.replacement.add((Instruction)nameInsn);
        return var;
    }
}

