/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.Set;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSMethodToExpose;
import org.teavm.model.AnnotationReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

class JSDependencyListener
extends AbstractDependencyListener {
    private JSBodyRepository repository;

    JSDependencyListener(JSBodyRepository repository) {
        this.repository = repository;
    }

    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        MethodReference ref = method.getReference();
        Set<MethodReference> callbackMethods = this.repository.callbackMethods.get(ref);
        if (callbackMethods != null) {
            for (MethodReference callbackMethod : callbackMethods) {
                agent.linkMethod(callbackMethod, new CallLocation(ref)).use();
            }
        }
    }

    public void classReached(DependencyAgent agent, String className, CallLocation location) {
        ClassReader cls = agent.getClassSource().get(className);
        for (MethodReader method : cls.getMethods()) {
            AnnotationReader exposeAnnot = method.getAnnotations().get(JSMethodToExpose.class.getName());
            if (exposeAnnot == null) continue;
            MethodDependency methodDep = agent.linkMethod(method.getReference(), null);
            methodDep.getVariable(0).propagate(agent.getType(className));
            methodDep.use();
        }
    }
}

