/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.FunctionNode;
import org.teavm.cache.NoCache;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.javascript.spi.GeneratedBy;
import org.teavm.javascript.spi.InjectedBy;
import org.teavm.javascript.spi.Sync;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSIndexer;
import org.teavm.jso.JSMethod;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSArrayReader;
import org.teavm.jso.impl.FunctorImpl;
import org.teavm.jso.impl.JS;
import org.teavm.jso.impl.JSBodyAstEmitter;
import org.teavm.jso.impl.JSBodyBloatedEmitter;
import org.teavm.jso.impl.JSBodyGenerator;
import org.teavm.jso.impl.JSBodyInlineUtil;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSParser;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.jso.impl.JavaInvocationProcessor;
import org.teavm.jso.impl.TeaVMErrorReporter;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.ProgramReader;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.util.InstructionVariableMapper;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;

class JSClassProcessor {
    private ClassReaderSource classSource;
    private JSBodyRepository repository;
    private JavaInvocationProcessor javaInvocationProcessor;
    private Program program;
    private List<Instruction> replacement = new ArrayList<Instruction>();
    private JSTypeHelper typeHelper;
    private Diagnostics diagnostics;
    private int methodIndexGenerator;
    private Map<MethodReference, MethodReader> overridenMethodCache = new HashMap<MethodReference, MethodReader>();

    public JSClassProcessor(ClassReaderSource classSource, JSBodyRepository repository, Diagnostics diagnostics) {
        this.classSource = classSource;
        this.repository = repository;
        this.diagnostics = diagnostics;
        this.typeHelper = new JSTypeHelper(classSource);
        this.javaInvocationProcessor = new JavaInvocationProcessor(this.typeHelper, repository, classSource, diagnostics);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public boolean isNative(String className) {
        return this.typeHelper.isJavaScriptClass(className);
    }

    public boolean isNativeImplementation(String className) {
        return this.typeHelper.isJavaScriptImplementation(className);
    }

    public MethodReference isFunctor(String className) {
        if (!this.typeHelper.isJavaScriptImplementation(className)) {
            return null;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        HashMap<MethodDescriptor, MethodReference> methods = new HashMap<MethodDescriptor, MethodReference>();
        this.getFunctorMethods(className, methods);
        if (methods.size() == 1) {
            return (MethodReference)methods.values().iterator().next();
        }
        return null;
    }

    private void getFunctorMethods(String className, Map<MethodDescriptor, MethodReference> methods) {
        this.classSource.getAncestors(className).forEach(cls -> {
            MethodReference method;
            if (cls.getAnnotations().get(JSFunctor.class.getName()) != null && this.isProperFunctor((ClassReader)cls) && !methods.containsKey((method = ((MethodReader)cls.getMethods().iterator().next()).getReference()).getDescriptor())) {
                methods.put(method.getDescriptor(), method);
            }
        });
    }

    public void processClass(ClassHolder cls) {
        HashSet<MethodDescriptor> preservedMethods = new HashSet<MethodDescriptor>();
        for (String iface : cls.getInterfaces()) {
            if (!this.typeHelper.isJavaScriptClass(iface)) continue;
            this.addPreservedMethods(iface, preservedMethods);
        }
    }

    private void addPreservedMethods(String ifaceName, Set<MethodDescriptor> methods) {
        ClassReader iface = this.classSource.get(ifaceName);
        for (MethodReader method : iface.getMethods()) {
            methods.add(method.getDescriptor());
        }
        for (String superIfaceName : iface.getInterfaces()) {
            this.addPreservedMethods(superIfaceName, methods);
        }
    }

    public void processMemberMethods(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            int i;
            if (method.hasModifier(ElementModifier.STATIC) || method.getProgram() == null || method.getProgram().basicBlockCount() <= 0) continue;
            ValueType[] staticSignature = JSClassProcessor.getStaticSignature(method.getReference());
            MethodHolder callerMethod = new MethodHolder(new MethodDescriptor(method.getName() + "$static", staticSignature));
            callerMethod.getModifiers().add(ElementModifier.STATIC);
            final Program program = ProgramUtils.copy((ProgramReader)method.getProgram());
            program.createVariable();
            InstructionVariableMapper variableMapper = new InstructionVariableMapper(){

                protected Variable map(Variable var) {
                    return program.variableAt(var.getIndex() + 1);
                }
            };
            for (i = program.variableCount() - 1; i > 0; --i) {
                program.variableAt(i).getDebugNames().addAll(program.variableAt(i - 1).getDebugNames());
                program.variableAt(i - 1).getDebugNames().clear();
            }
            for (i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                for (Instruction insn : block.getInstructions()) {
                    insn.acceptVisitor((InstructionVisitor)variableMapper);
                }
                for (Phi phi : block.getPhis()) {
                    phi.setReceiver(program.variableAt(phi.getReceiver().getIndex() + 1));
                    for (Incoming incoming : phi.getIncomings()) {
                        incoming.setValue(program.variableAt(incoming.getValue().getIndex() + 1));
                    }
                }
                for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                    if (tryCatch.getExceptionVariable() == null) continue;
                    tryCatch.setExceptionVariable(program.variableAt(tryCatch.getExceptionVariable().getIndex() + 1));
                }
            }
            callerMethod.setProgram(program);
            ModelUtils.copyAnnotations((AnnotationContainerReader)method.getAnnotations(), (AnnotationContainer)callerMethod.getAnnotations());
            cls.addMethod(callerMethod);
        }
    }

    private MethodReader getOverridenMethod(MethodReader finalMethod) {
        MethodReference ref = finalMethod.getReference();
        if (!this.overridenMethodCache.containsKey(ref)) {
            this.overridenMethodCache.put(ref, this.findOverridenMethod(finalMethod.getOwnerName(), finalMethod));
        }
        return this.overridenMethodCache.get(ref);
    }

    private MethodReader findOverridenMethod(String className, MethodReader finalMethod) {
        if (finalMethod.getName().equals("<init>")) {
            return null;
        }
        return this.classSource.getAncestors(className).skip(1L).map(cls -> cls.getMethod(finalMethod.getDescriptor())).filter(method -> method != null).findFirst().orElse(null);
    }

    public void addFunctorField(ClassHolder cls, MethodReference method) {
        if (cls.getAnnotations().get(FunctorImpl.class.getName()) != null) {
            return;
        }
        FieldHolder field = new FieldHolder("$$jso_functor$$");
        field.setLevel(AccessLevel.PUBLIC);
        field.setType(ValueType.parse(JSObject.class));
        cls.addField(field);
        AnnotationHolder annot = new AnnotationHolder(FunctorImpl.class.getName());
        annot.getValues().put("value", new AnnotationValue(method.getDescriptor().toString()));
        cls.getAnnotations().add(annot);
    }

    public void makeSync(ClassHolder cls) {
        HashSet<MethodDescriptor> methods = new HashSet<MethodDescriptor>();
        this.findInheritedMethods((ClassReader)cls, methods, new HashSet<String>());
        for (MethodHolder method : cls.getMethods()) {
            if (!methods.contains(method.getDescriptor()) || method.getAnnotations().get(Sync.class.getName()) != null) continue;
            AnnotationHolder annot = new AnnotationHolder(Sync.class.getName());
            method.getAnnotations().add(annot);
        }
    }

    private void findInheritedMethods(ClassReader cls, Set<MethodDescriptor> methods, Set<String> visited) {
        block5: {
            ClassReader parentCls;
            block4: {
                if (!visited.add(cls.getName())) {
                    return;
                }
                if (!this.isNative(cls.getName())) break block4;
                for (MethodReader method : cls.getMethods()) {
                    if (method.hasModifier(ElementModifier.STATIC) || method.hasModifier(ElementModifier.FINAL) || method.getLevel() == AccessLevel.PRIVATE) continue;
                    methods.add(method.getDescriptor());
                }
                break block5;
            }
            if (!this.isNativeImplementation(cls.getName())) break block5;
            if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && (parentCls = this.classSource.get(cls.getParent())) != null) {
                this.findInheritedMethods(parentCls, methods, visited);
            }
            for (String iface : cls.getInterfaces()) {
                ClassReader parentCls2 = this.classSource.get(iface);
                if (parentCls2 == null) continue;
                this.findInheritedMethods(parentCls2, methods, visited);
            }
        }
    }

    static ValueType[] getStaticSignature(MethodReference method) {
        ValueType[] signature = method.getSignature();
        ValueType[] staticSignature = new ValueType[signature.length + 1];
        for (int i = 0; i < signature.length; ++i) {
            staticSignature[i + 1] = signature[i];
        }
        staticSignature[0] = ValueType.object((String)method.getClassName());
        return staticSignature;
    }

    public void processProgram(MethodHolder methodToProcess) {
        this.program = methodToProcess.getProgram();
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            List instructions = block.getInstructions();
            for (int j = 0; j < instructions.size(); ++j) {
                InvokeInstruction invoke;
                MethodReader method;
                Instruction insn = (Instruction)instructions.get(j);
                if (!(insn instanceof InvokeInstruction) || (method = this.getMethod((invoke = (InvokeInstruction)insn).getMethod())) == null) continue;
                CallLocation callLocation = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                this.replacement.clear();
                if (!this.processInvocation(method, callLocation, invoke, methodToProcess)) continue;
                block.getInstructions().set(j, this.replacement.get(0));
                block.getInstructions().addAll(j + 1, this.replacement.subList(1, this.replacement.size()));
                j += this.replacement.size() - 1;
            }
        }
    }

    private boolean processInvocation(MethodReader method, CallLocation callLocation, InvokeInstruction invoke, MethodHolder methodToProcess) {
        if (method.getAnnotations().get(JSBody.class.getName()) != null) {
            return this.processJSBodyInvocation(method, callLocation, invoke, methodToProcess);
        }
        if (!this.typeHelper.isJavaScriptClass(invoke.getMethod().getClassName())) {
            return false;
        }
        if (method.hasModifier(ElementModifier.STATIC)) {
            return false;
        }
        if (method.getProgram() != null && method.getProgram().basicBlockCount() > 0) {
            MethodReader overriden = this.getOverridenMethod(method);
            if (overriden != null) {
                this.diagnostics.error(callLocation, "JS final method {{m0}} overrides {{m1}}. Overriding final method of overlay types is prohibited.", new Object[]{method.getReference(), overriden.getReference()});
            }
            if (method.getProgram() != null && method.getProgram().basicBlockCount() > 0) {
                invoke.setMethod(new MethodReference(method.getOwnerName(), method.getName() + "$static", JSClassProcessor.getStaticSignature(method.getReference())));
                invoke.getArguments().add(0, invoke.getInstance());
                invoke.setInstance(null);
            }
            invoke.setType(InvocationType.SPECIAL);
            return false;
        }
        if (method.getAnnotations().get(JSProperty.class.getName()) != null) {
            return this.processProperty(method, callLocation, invoke);
        }
        if (method.getAnnotations().get(JSIndexer.class.getName()) != null) {
            return this.processIndexer(method, callLocation, invoke);
        }
        return this.processMethod(method, callLocation, invoke);
    }

    private boolean processJSBodyInvocation(MethodReader method, CallLocation callLocation, InvokeInstruction invoke, MethodHolder methodToProcess) {
        boolean valid = true;
        for (int i = 0; i < method.parameterCount(); ++i) {
            ValueType arg = method.parameterType(i);
            if (this.typeHelper.isSupportedType(arg)) continue;
            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method  declaration. Its parameter #" + (i + 1) + " has invalid type {{t1}}", new Object[]{invoke.getMethod(), arg});
            valid = false;
        }
        if (invoke.getInstance() != null && !this.typeHelper.isSupportedType(ValueType.object((String)method.getOwnerName()))) {
            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method  declaration. It is non-static and declared on a non-overlay class {{c1}}", new Object[]{invoke.getMethod(), method.getOwnerName()});
            valid = false;
        }
        if (method.getResultType() != ValueType.VOID && !this.typeHelper.isSupportedType(method.getResultType())) {
            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method  declaration, since it returns invalid type {{t1}}", new Object[]{invoke.getMethod(), method.getResultType()});
            valid = false;
        }
        if (!valid) {
            return false;
        }
        this.requireJSBody(this.diagnostics, method);
        MethodReference delegate = this.repository.methodMap.get(method.getReference());
        if (delegate == null) {
            return false;
        }
        Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
        InvokeInstruction newInvoke = new InvokeInstruction();
        Object[] signature = new ValueType[method.parameterCount() + 3];
        Arrays.fill(signature, ValueType.object((String)JSObject.class.getName()));
        newInvoke.setMethod(delegate);
        newInvoke.setType(InvocationType.SPECIAL);
        newInvoke.setReceiver(result);
        newInvoke.setLocation(invoke.getLocation());
        if (invoke.getInstance() != null) {
            Variable arg = this.wrapArgument(callLocation, invoke.getInstance(), ValueType.object((String)method.getOwnerName()));
            newInvoke.getArguments().add(arg);
        }
        for (int k = 0; k < invoke.getArguments().size(); ++k) {
            Variable arg = this.wrapArgument(callLocation, (Variable)invoke.getArguments().get(k), method.parameterType(k));
            newInvoke.getArguments().add(arg);
        }
        this.replacement.add((Instruction)newInvoke);
        if (result != null) {
            result = this.unwrap(callLocation, result, method.getResultType());
            this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
        }
        if (methodToProcess.getAnnotations().get(NoCache.class.getName()) == null) {
            methodToProcess.getAnnotations().add(new AnnotationHolder(NoCache.class.getName()));
        }
        return true;
    }

    private boolean processProperty(MethodReader method, CallLocation callLocation, InvokeInstruction invoke) {
        if (this.isProperGetter(method.getDescriptor())) {
            AnnotationReader annot = method.getAnnotations().get(JSProperty.class.getName());
            String propertyName = annot.getValue("value") != null ? annot.getValue("value").getString() : (method.getName().charAt(0) == 'i' ? this.cutPrefix(method.getName(), 2) : this.cutPrefix(method.getName(), 3));
            Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
            this.addPropertyGet(propertyName, invoke.getInstance(), result, invoke.getLocation());
            if (result != null) {
                result = this.unwrap(callLocation, result, method.getResultType());
                this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
            }
            return true;
        }
        if (this.isProperSetter(method.getDescriptor())) {
            AnnotationReader annot = method.getAnnotations().get(JSProperty.class.getName());
            String propertyName = annot.getValue("value") != null ? annot.getValue("value").getString() : this.cutPrefix(method.getName(), 3);
            Variable wrapped = this.wrapArgument(callLocation, (Variable)invoke.getArguments().get(0), method.parameterType(0));
            this.addPropertySet(propertyName, invoke.getInstance(), wrapped, invoke.getLocation());
            return true;
        }
        this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript property declaration", new Object[]{invoke.getMethod()});
        return false;
    }

    private boolean processIndexer(MethodReader method, CallLocation callLocation, InvokeInstruction invoke) {
        if (this.isProperGetIndexer(method.getDescriptor())) {
            Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
            this.addIndexerGet(invoke.getInstance(), this.wrap((Variable)invoke.getArguments().get(0), method.parameterType(0), invoke.getLocation()), result, invoke.getLocation());
            if (result != null) {
                result = this.unwrap(callLocation, result, method.getResultType());
                this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
            }
            return true;
        }
        if (this.isProperSetIndexer(method.getDescriptor())) {
            Variable index = this.wrap((Variable)invoke.getArguments().get(0), method.parameterType(0), invoke.getLocation());
            Variable value = this.wrap((Variable)invoke.getArguments().get(1), method.parameterType(1), invoke.getLocation());
            this.addIndexerSet(invoke.getInstance(), index, value, invoke.getLocation());
            return true;
        }
        this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript indexer declaration", new Object[]{invoke.getMethod()});
        return false;
    }

    private boolean processMethod(MethodReader method, CallLocation callLocation, InvokeInstruction invoke) {
        ValueType[] redefinedMethodName;
        String name = method.getName();
        AnnotationReader methodAnnot = method.getAnnotations().get(JSMethod.class.getName());
        if (methodAnnot != null && (redefinedMethodName = methodAnnot.getValue("value")) != null) {
            name = redefinedMethodName.getString();
        }
        if (method.getResultType() != ValueType.VOID && !this.typeHelper.isSupportedType(method.getResultType())) {
            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method declaration", new Object[]{invoke.getMethod()});
            return false;
        }
        for (ValueType arg : method.getParameterTypes()) {
            if (this.typeHelper.isSupportedType(arg)) continue;
            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method  declaration", new Object[]{invoke.getMethod()});
            return false;
        }
        Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
        InvokeInstruction newInvoke = new InvokeInstruction();
        Object[] signature = new ValueType[method.parameterCount() + 3];
        Arrays.fill(signature, ValueType.object((String)JSObject.class.getName()));
        newInvoke.setMethod(new MethodReference(JS.class.getName(), "invoke", (ValueType[])signature));
        newInvoke.setType(InvocationType.SPECIAL);
        newInvoke.setReceiver(result);
        newInvoke.getArguments().add(invoke.getInstance());
        newInvoke.getArguments().add(this.addStringWrap(this.addString(name, invoke.getLocation()), invoke.getLocation()));
        newInvoke.setLocation(invoke.getLocation());
        for (int k = 0; k < invoke.getArguments().size(); ++k) {
            Variable arg = this.wrapArgument(callLocation, (Variable)invoke.getArguments().get(k), method.parameterType(k));
            newInvoke.getArguments().add(arg);
        }
        this.replacement.add((Instruction)newInvoke);
        if (result != null) {
            result = this.unwrap(callLocation, result, method.getResultType());
            this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
        }
        return true;
    }

    private void requireJSBody(Diagnostics diagnostics, MethodReader methodToProcess) {
        if (!this.repository.processedMethods.add(methodToProcess.getReference())) {
            return;
        }
        this.processJSBody(diagnostics, methodToProcess);
    }

    private void processJSBody(Diagnostics diagnostics, MethodReader methodToProcess) {
        AstRoot rootNode;
        CallLocation location = new CallLocation(methodToProcess.getReference());
        boolean isStatic = methodToProcess.hasModifier(ElementModifier.STATIC);
        AnnotationReader bodyAnnot = methodToProcess.getAnnotations().get(JSBody.class.getName());
        int jsParamCount = bodyAnnot.getValue("params").getList().size();
        if (methodToProcess.parameterCount() != jsParamCount) {
            diagnostics.error(location, "JSBody method {{m0}} declares " + methodToProcess.parameterCount() + " parameters, but annotation specifies " + jsParamCount, new Object[]{methodToProcess});
            return;
        }
        int paramCount = methodToProcess.parameterCount();
        if (!isStatic) {
            ++paramCount;
        }
        ValueType[] paramTypes = new ValueType[paramCount];
        int offset = 0;
        if (!isStatic) {
            ValueType paramType = ValueType.object((String)methodToProcess.getOwnerName());
            paramTypes[offset++] = paramType;
            if (!this.typeHelper.isSupportedType(paramType)) {
                diagnostics.error(location, "Non-static JSBody method {{m0}} is owned by non-JS class {{c1}}", new Object[]{methodToProcess.getReference(), methodToProcess.getOwnerName()});
            }
        }
        if (methodToProcess.getResultType() != ValueType.VOID && !this.typeHelper.isSupportedType(methodToProcess.getResultType())) {
            diagnostics.error(location, "JSBody method {{m0}} returns unsupported type {{t1}}", new Object[]{methodToProcess.getReference(), methodToProcess.getResultType()});
        }
        for (int i = 0; i < methodToProcess.parameterCount(); ++i) {
            paramTypes[offset++] = methodToProcess.parameterType(i);
        }
        ValueType[] proxyParamTypes = new ValueType[paramCount + 1];
        for (int i = 0; i < paramCount; ++i) {
            proxyParamTypes[i] = ValueType.parse(JSObject.class);
        }
        proxyParamTypes[paramCount] = methodToProcess.getResultType() == ValueType.VOID ? ValueType.VOID : ValueType.parse(JSObject.class);
        MethodReference proxyMethod = new MethodReference(methodToProcess.getOwnerName(), methodToProcess.getName() + "$js_body$_" + this.methodIndexGenerator++, proxyParamTypes);
        String script = bodyAnnot.getValue("script").getString();
        String[] parameterNames = (String[])bodyAnnot.getValue("params").getList().stream().map(ann -> ann.getString()).toArray(String[]::new);
        TeaVMErrorReporter errorReporter = new TeaVMErrorReporter(diagnostics, new CallLocation(methodToProcess.getReference()));
        CompilerEnvirons env = new CompilerEnvirons();
        env.setRecoverFromErrors(true);
        env.setLanguageVersion(180);
        env.setIdeMode(true);
        JSParser parser = new JSParser(env, errorReporter);
        try {
            rootNode = parser.parse(new StringReader("function(){" + script + "}"), null, 0);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error occured", e);
        }
        AstNode body = ((FunctionNode)rootNode.getFirstChild()).getBody();
        this.repository.methodMap.put(methodToProcess.getReference(), proxyMethod);
        if (errorReporter.hasErrors()) {
            this.repository.emitters.put(proxyMethod, new JSBodyBloatedEmitter(isStatic, proxyMethod, script, parameterNames));
        } else {
            AstNode expr = JSBodyInlineUtil.isSuitableForInlining(methodToProcess.getReference(), parameterNames, body);
            if (expr != null) {
                this.repository.inlineMethods.add(methodToProcess.getReference());
            } else {
                expr = body;
            }
            this.javaInvocationProcessor.process(location, expr);
            this.repository.emitters.put(proxyMethod, new JSBodyAstEmitter(isStatic, expr, parameterNames));
        }
    }

    public void createJSMethods(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            MethodReference methodRef = method.getReference();
            if (method.getAnnotations().get(JSBody.class.getName()) == null) continue;
            this.requireJSBody(this.diagnostics, (MethodReader)method);
            if (!this.repository.methodMap.containsKey(method.getReference())) continue;
            MethodReference proxyRef = this.repository.methodMap.get(methodRef);
            MethodHolder proxyMethod = new MethodHolder(proxyRef.getDescriptor());
            proxyMethod.getModifiers().add(ElementModifier.NATIVE);
            proxyMethod.getModifiers().add(ElementModifier.STATIC);
            boolean inline = this.repository.inlineMethods.contains(methodRef);
            AnnotationHolder generatorAnnot = new AnnotationHolder(inline ? InjectedBy.class.getName() : GeneratedBy.class.getName());
            generatorAnnot.getValues().put("value", new AnnotationValue(ValueType.parse(JSBodyGenerator.class)));
            proxyMethod.getAnnotations().add(generatorAnnot);
            cls.addMethod(proxyMethod);
            Set<MethodReference> callbacks = this.repository.callbackMethods.get(proxyRef);
            if (callbacks == null) continue;
            for (MethodReference callback : callbacks) {
                this.generateCallbackCaller(cls, callback);
            }
        }
    }

    private void generateCallbackCaller(ClassHolder cls, MethodReference callback) {
        MethodReference calleeRef = this.repository.callbackCallees.get(callback);
        MethodReader callee = this.classSource.resolve(calleeRef);
        MethodHolder callerMethod = new MethodHolder(callback.getDescriptor());
        callerMethod.getModifiers().add(ElementModifier.STATIC);
        CallLocation location = new CallLocation(callback);
        this.program = new Program();
        for (int i = 0; i <= callback.parameterCount(); ++i) {
            this.program.createVariable();
        }
        BasicBlock block = this.program.createBasicBlock();
        int paramIndex = 1;
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(calleeRef);
        this.replacement.clear();
        if (!callee.hasModifier(ElementModifier.STATIC)) {
            insn.setInstance(this.unwrap(location, this.program.variableAt(paramIndex++), ValueType.object((String)calleeRef.getClassName())));
        }
        for (int i = 0; i < callee.parameterCount(); ++i) {
            insn.getArguments().add(this.unwrap(location, this.program.variableAt(paramIndex++), callee.parameterType(i)));
        }
        if (callee.getResultType() != ValueType.VOID) {
            insn.setReceiver(this.program.createVariable());
        }
        block.getInstructions().addAll(this.replacement);
        block.getInstructions().add(insn);
        ExitInstruction exit = new ExitInstruction();
        if (insn.getReceiver() != null) {
            this.replacement.clear();
            exit.setValueToReturn(this.wrap(insn.getReceiver(), callee.getResultType(), null));
            block.getInstructions().addAll(this.replacement);
        }
        block.getInstructions().add(exit);
        callerMethod.setProgram(this.program);
        cls.addMethod(callerMethod);
        this.processProgram(callerMethod);
    }

    private void addPropertyGet(String propertyName, Variable instance, Variable receiver, InstructionLocation location) {
        Variable nameVar = this.addStringWrap(this.addString(propertyName, location), location);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "get", new Class[]{JSObject.class, JSObject.class, JSObject.class}));
        insn.setReceiver(receiver);
        insn.getArguments().add(instance);
        insn.getArguments().add(nameVar);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addPropertySet(String propertyName, Variable instance, Variable value, InstructionLocation location) {
        Variable nameVar = this.addStringWrap(this.addString(propertyName, location), location);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "set", new Class[]{JSObject.class, JSObject.class, JSObject.class, Void.TYPE}));
        insn.getArguments().add(instance);
        insn.getArguments().add(nameVar);
        insn.getArguments().add(value);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addIndexerGet(Variable array, Variable index, Variable receiver, InstructionLocation location) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "get", new Class[]{JSObject.class, JSObject.class, JSObject.class}));
        insn.setReceiver(receiver);
        insn.getArguments().add(array);
        insn.getArguments().add(index);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addIndexerSet(Variable array, Variable index, Variable value, InstructionLocation location) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "set", new Class[]{JSObject.class, JSObject.class, JSObject.class, Void.TYPE}));
        insn.getArguments().add(array);
        insn.getArguments().add(index);
        insn.getArguments().add(value);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void copyVar(Variable a, Variable b, InstructionLocation location) {
        AssignInstruction insn = new AssignInstruction();
        insn.setAssignee(a);
        insn.setReceiver(b);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private Variable addStringWrap(Variable var, InstructionLocation location) {
        return this.wrap(var, ValueType.object((String)"java.lang.String"), location);
    }

    private Variable addString(String str, InstructionLocation location) {
        Variable var = this.program.createVariable();
        StringConstantInstruction nameInsn = new StringConstantInstruction();
        nameInsn.setReceiver(var);
        nameInsn.setConstant(str);
        nameInsn.setLocation(location);
        this.replacement.add((Instruction)nameInsn);
        return var;
    }

    private Variable unwrap(CallLocation location, Variable var, ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return this.unwrap(var, "unwrapBoolean", ValueType.parse(JSObject.class), (ValueType)ValueType.BOOLEAN, location.getSourceLocation());
                }
                case BYTE: {
                    return this.unwrap(var, "unwrapByte", ValueType.parse(JSObject.class), (ValueType)ValueType.BYTE, location.getSourceLocation());
                }
                case SHORT: {
                    return this.unwrap(var, "unwrapShort", ValueType.parse(JSObject.class), (ValueType)ValueType.SHORT, location.getSourceLocation());
                }
                case INTEGER: {
                    return this.unwrap(var, "unwrapInt", ValueType.parse(JSObject.class), (ValueType)ValueType.INTEGER, location.getSourceLocation());
                }
                case CHARACTER: {
                    return this.unwrap(var, "unwrapCharacter", ValueType.parse(JSObject.class), (ValueType)ValueType.CHARACTER, location.getSourceLocation());
                }
                case DOUBLE: {
                    return this.unwrap(var, "unwrapDouble", ValueType.parse(JSObject.class), (ValueType)ValueType.DOUBLE, location.getSourceLocation());
                }
                case FLOAT: {
                    return this.unwrap(var, "unwrapFloat", ValueType.parse(JSObject.class), (ValueType)ValueType.FLOAT, location.getSourceLocation());
                }
            }
        } else if (type instanceof ValueType.Object) {
            String className = ((ValueType.Object)type).getClassName();
            if (className.equals(JSObject.class.getName())) {
                return var;
            }
            if (className.equals("java.lang.String")) {
                return this.unwrap(var, "unwrapString", ValueType.parse(JSObject.class), ValueType.parse(String.class), location.getSourceLocation());
            }
            if (this.isNative(className)) {
                Variable result = this.program.createVariable();
                CastInstruction castInsn = new CastInstruction();
                castInsn.setReceiver(result);
                castInsn.setValue(var);
                castInsn.setTargetType(type);
                castInsn.setLocation(location.getSourceLocation());
                this.replacement.add((Instruction)castInsn);
                return result;
            }
        } else if (type instanceof ValueType.Array) {
            return this.unwrapArray(location, var, (ValueType.Array)type);
        }
        this.diagnostics.error(location, "Unsupported type: {{t0}}", new Object[]{type});
        return var;
    }

    private Variable unwrapArray(CallLocation location, Variable var, ValueType.Array type) {
        ValueType.Array itemType = type;
        int degree = 0;
        while (itemType instanceof ValueType.Array) {
            ++degree;
            itemType = itemType.getItemType();
        }
        CastInstruction castInsn = new CastInstruction();
        castInsn.setValue(var);
        castInsn.setTargetType(ValueType.parse(JSArrayReader.class));
        var = this.program.createVariable();
        castInsn.setReceiver(var);
        castInsn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)castInsn);
        var = degree == 1 ? this.unwrapSingleDimensionArray(location, var, (ValueType)itemType) : this.unwrapMultiDimensionArray(location, var, (ValueType)itemType, degree);
        return var;
    }

    private Variable unwrapSingleDimensionArray(CallLocation location, Variable var, ValueType type) {
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(this.singleDimensionArrayUnwrapper(type));
        insn.setType(InvocationType.SPECIAL);
        if (insn.getMethod().parameterCount() == 2) {
            Variable cls = this.program.createVariable();
            ClassConstantInstruction clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            insn.getArguments().add(cls);
        }
        insn.getArguments().add(var);
        insn.setReceiver(result);
        this.replacement.add((Instruction)insn);
        return result;
    }

    private Variable unwrapMultiDimensionArray(CallLocation location, Variable var, ValueType type, int degree) {
        ClassConstantInstruction clsInsn;
        Variable cls;
        Variable function = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(this.multipleDimensionArrayUnwrapper(type));
        insn.setType(InvocationType.SPECIAL);
        if (insn.getMethod().parameterCount() == 1) {
            cls = this.program.createVariable();
            clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            insn.getArguments().add(cls);
        }
        insn.setReceiver(function);
        this.replacement.add((Instruction)insn);
        while (--degree > 1) {
            type = ValueType.arrayOf((ValueType)type);
            cls = this.program.createVariable();
            clsInsn = new ClassConstantInstruction();
            clsInsn.setConstant(type);
            clsInsn.setLocation(location.getSourceLocation());
            clsInsn.setReceiver(cls);
            this.replacement.add((Instruction)clsInsn);
            insn = new InvokeInstruction();
            insn.setMethod(new MethodReference(JS.class, "arrayUnmapper", new Class[]{Class.class, Function.class, Function.class}));
            insn.setType(InvocationType.SPECIAL);
            insn.getArguments().add(cls);
            insn.getArguments().add(function);
            function = this.program.createVariable();
            insn.setReceiver(function);
            this.replacement.add((Instruction)insn);
        }
        cls = this.program.createVariable();
        clsInsn = new ClassConstantInstruction();
        clsInsn.setConstant(ValueType.arrayOf((ValueType)type));
        clsInsn.setLocation(location.getSourceLocation());
        clsInsn.setReceiver(cls);
        this.replacement.add((Instruction)clsInsn);
        insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(JS.class, "unmapArray", new Class[]{Class.class, JSArrayReader.class, Function.class, Object[].class}));
        insn.getArguments().add(cls);
        insn.getArguments().add(var);
        insn.getArguments().add(function);
        insn.setReceiver(var);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return var;
    }

    private MethodReference singleDimensionArrayUnwrapper(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BOOLEAN: {
                    return new MethodReference(JS.class, "unwrapBooleanArray", new Class[]{JSArrayReader.class, boolean[].class});
                }
                case BYTE: {
                    return new MethodReference(JS.class, "unwrapByteArray", new Class[]{JSArrayReader.class, byte[].class});
                }
                case SHORT: {
                    return new MethodReference(JS.class, "unwrapShortArray", new Class[]{JSArrayReader.class, short[].class});
                }
                case CHARACTER: {
                    return new MethodReference(JS.class, "unwrapCharArray", new Class[]{JSArrayReader.class, char[].class});
                }
                case INTEGER: {
                    return new MethodReference(JS.class, "unwrapIntArray", new Class[]{JSArrayReader.class, int[].class});
                }
                case FLOAT: {
                    return new MethodReference(JS.class, "unwrapFloatArray", new Class[]{JSArrayReader.class, float[].class});
                }
                case DOUBLE: {
                    return new MethodReference(JS.class, "unwrapDoubleArray", new Class[]{JSArrayReader.class, double[].class});
                }
            }
        } else if (itemType.isObject(String.class)) {
            return new MethodReference(JS.class, "unwrapStringArray", new Class[]{JSArrayReader.class, String[].class});
        }
        return new MethodReference(JS.class, "unwrapArray", new Class[]{Class.class, JSArrayReader.class, JSObject[].class});
    }

    private MethodReference multipleDimensionArrayUnwrapper(ValueType itemType) {
        if (itemType instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)itemType).getKind()) {
                case BOOLEAN: {
                    return new MethodReference(JS.class, "booleanArrayUnwrapper", new Class[]{Function.class});
                }
                case BYTE: {
                    return new MethodReference(JS.class, "byteArrayUnwrapper", new Class[]{Function.class});
                }
                case SHORT: {
                    return new MethodReference(JS.class, "shortArrayUnwrapper", new Class[]{Function.class});
                }
                case CHARACTER: {
                    return new MethodReference(JS.class, "charArrayUnwrapper", new Class[]{Function.class});
                }
                case INTEGER: {
                    return new MethodReference(JS.class, "intArrayUnwrapper", new Class[]{Function.class});
                }
                case FLOAT: {
                    return new MethodReference(JS.class, "floatArrayUnwrapper", new Class[]{Function.class});
                }
                case DOUBLE: {
                    return new MethodReference(JS.class, "doubleArrayUnwrapper", new Class[]{Function.class});
                }
            }
        } else if (itemType.isObject(String.class)) {
            return new MethodReference(JS.class, "stringArrayUnwrapper", new Class[]{Function.class});
        }
        return new MethodReference(JS.class, "arrayUnwrapper", new Class[]{Class.class, Function.class});
    }

    private Variable unwrap(Variable var, String methodName, ValueType argType, ValueType resultType, InstructionLocation location) {
        if (!argType.isObject(JSObject.class.getName())) {
            Variable castValue = this.program.createVariable();
            CastInstruction castInsn = new CastInstruction();
            castInsn.setValue(var);
            castInsn.setReceiver(castValue);
            castInsn.setLocation(location);
            castInsn.setTargetType(argType);
            this.replacement.add((Instruction)castInsn);
            var = castValue;
        }
        Variable result = this.program.createVariable();
        InvokeInstruction insn = new InvokeInstruction();
        insn.setMethod(new MethodReference(JS.class.getName(), methodName, new ValueType[]{argType, resultType}));
        insn.getArguments().add(var);
        insn.setReceiver(result);
        insn.setType(InvocationType.SPECIAL);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
        return result;
    }

    private Variable wrapArgument(CallLocation location, Variable var, ValueType type) {
        String className;
        ClassReader cls;
        if (type instanceof ValueType.Object && (cls = this.classSource.get(className = ((ValueType.Object)type).getClassName())).getAnnotations().get(JSFunctor.class.getName()) != null) {
            return this.wrapFunctor(location, var, cls);
        }
        return this.wrap(var, type, location.getSourceLocation());
    }

    private boolean isProperFunctor(ClassReader type) {
        return type.hasModifier(ElementModifier.INTERFACE) && type.getMethods().size() == 1;
    }

    private Variable wrapFunctor(CallLocation location, Variable var, ClassReader type) {
        if (!this.isProperFunctor(type)) {
            this.diagnostics.error(location, "Wrong functor: {{c0}}", new Object[]{type.getName()});
            return var;
        }
        String name = ((MethodReader)type.getMethods().iterator().next()).getName();
        Variable functor = this.program.createVariable();
        Variable nameVar = this.addStringWrap(this.addString(name, location.getSourceLocation()), location.getSourceLocation());
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(new MethodReference(JS.class, "function", new Class[]{JSObject.class, JSObject.class, JSObject.class}));
        insn.setReceiver(functor);
        insn.getArguments().add(var);
        insn.getArguments().add(nameVar);
        insn.setLocation(location.getSourceLocation());
        this.replacement.add((Instruction)insn);
        return functor;
    }

    private Variable wrap(Variable var, ValueType type, InstructionLocation location) {
        String className;
        if (type instanceof ValueType.Object && !(className = ((ValueType.Object)type).getClassName()).equals("java.lang.String")) {
            return var;
        }
        Variable result = this.program.createVariable();
        ValueType itemType = type;
        int degree = 0;
        while (itemType instanceof ValueType.Array) {
            itemType = ((ValueType.Array)itemType).getItemType();
            ++degree;
        }
        if (degree <= 1) {
            InvokeInstruction insn = new InvokeInstruction();
            insn.setMethod(new MethodReference(JS.class.getName(), "wrap", new ValueType[]{this.getWrappedType(type), this.getWrapperType(type)}));
            insn.getArguments().add(var);
            insn.setReceiver(result);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
        } else {
            Variable function = this.program.createVariable();
            InvokeInstruction insn = new InvokeInstruction();
            insn.setMethod(this.getWrapperFunction(itemType));
            insn.setReceiver(function);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
            while (--degree > 1) {
                insn = new InvokeInstruction();
                insn.setMethod(new MethodReference(JS.class, "arrayMapper", new Class[]{Function.class, Function.class}));
                insn.getArguments().add(function);
                function = this.program.createVariable();
                insn.setReceiver(function);
                insn.setType(InvocationType.SPECIAL);
                insn.setLocation(location);
                this.replacement.add((Instruction)insn);
            }
            insn = new InvokeInstruction();
            insn.setMethod(new MethodReference(JS.class.getName(), "map", new ValueType[]{this.getWrappedType(type), ValueType.parse(Function.class), this.getWrapperType(type)}));
            insn.getArguments().add(var);
            insn.getArguments().add(function);
            insn.setReceiver(result);
            insn.setType(InvocationType.SPECIAL);
            insn.setLocation(location);
            this.replacement.add((Instruction)insn);
        }
        return result;
    }

    private MethodReference getWrapperFunction(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return new MethodReference(JS.class, "booleanArrayWrapper", new Class[]{Function.class});
                }
                case BYTE: {
                    return new MethodReference(JS.class, "byteArrayWrapper", new Class[]{Function.class});
                }
                case SHORT: {
                    return new MethodReference(JS.class, "shortArrayWrapper", new Class[]{Function.class});
                }
                case CHARACTER: {
                    return new MethodReference(JS.class, "charArrayWrapper", new Class[]{Function.class});
                }
                case INTEGER: {
                    return new MethodReference(JS.class, "intArrayWrapper", new Class[]{Function.class});
                }
                case FLOAT: {
                    return new MethodReference(JS.class, "floatArrayWrapper", new Class[]{Function.class});
                }
                case DOUBLE: {
                    return new MethodReference(JS.class, "doubleArrayWrapper", new Class[]{Function.class});
                }
            }
        } else if (type.isObject(String.class)) {
            return new MethodReference(JS.class, "stringArrayWrapper", new Class[]{Function.class});
        }
        return new MethodReference(JS.class, "arrayWrapper", new Class[]{Function.class});
    }

    private ValueType getWrappedType(ValueType type) {
        if (type instanceof ValueType.Array) {
            ValueType itemType = ((ValueType.Array)type).getItemType();
            if (itemType instanceof ValueType.Array) {
                return ValueType.parse(Object[].class);
            }
            return ValueType.arrayOf((ValueType)this.getWrappedType(itemType));
        }
        if (type instanceof ValueType.Object) {
            if (type.isObject(String.class)) {
                return type;
            }
            return ValueType.parse(JSObject.class);
        }
        return type;
    }

    private ValueType getWrapperType(ValueType type) {
        if (type instanceof ValueType.Array) {
            return ValueType.parse(JSArray.class);
        }
        return ValueType.parse(JSObject.class);
    }

    private MethodReader getMethod(MethodReference ref) {
        ClassReader cls = this.classSource.get(ref.getClassName());
        if (cls == null) {
            return null;
        }
        MethodReader method = cls.getMethod(ref.getDescriptor());
        if (method != null) {
            return method;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && !cls.getParent().equals("java.lang.Object") && (method = this.getMethod(new MethodReference(cls.getParent(), ref.getDescriptor()))) != null) {
            return method;
        }
        for (String iface : cls.getInterfaces()) {
            method = this.getMethod(new MethodReference(iface, ref.getDescriptor()));
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private boolean isProperGetter(MethodDescriptor desc) {
        if (desc.parameterCount() > 0 || !this.typeHelper.isSupportedType(desc.getResultType())) {
            return false;
        }
        if (desc.getResultType().equals((Object)ValueType.BOOLEAN) && this.isProperPrefix(desc.getName(), "is")) {
            return true;
        }
        return this.isProperPrefix(desc.getName(), "get");
    }

    private boolean isProperSetter(MethodDescriptor desc) {
        if (desc.parameterCount() != 1 || !this.typeHelper.isSupportedType(desc.parameterType(0)) || desc.getResultType() != ValueType.VOID) {
            return false;
        }
        return this.isProperPrefix(desc.getName(), "set");
    }

    private boolean isProperPrefix(String name, String prefix) {
        if (!name.startsWith(prefix) || name.length() == prefix.length()) {
            return false;
        }
        char c = name.charAt(prefix.length());
        return Character.isUpperCase(c);
    }

    private boolean isProperGetIndexer(MethodDescriptor desc) {
        return desc.parameterCount() == 1 && this.typeHelper.isSupportedType(desc.parameterType(0)) && this.typeHelper.isSupportedType(desc.getResultType());
    }

    private boolean isProperSetIndexer(MethodDescriptor desc) {
        return desc.parameterCount() == 2 && this.typeHelper.isSupportedType(desc.parameterType(0)) && this.typeHelper.isSupportedType(desc.parameterType(0)) && desc.getResultType() == ValueType.VOID;
    }

    private String cutPrefix(String name, int prefixLength) {
        if (name.length() == prefixLength + 1) {
            return name.substring(prefixLength).toLowerCase();
        }
        char c = name.charAt(prefixLength + 1);
        if (Character.isUpperCase(c)) {
            return name.substring(prefixLength);
        }
        return Character.toLowerCase(name.charAt(prefixLength)) + name.substring(prefixLength + 1);
    }
}

