/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import java.util.Map;
import org.teavm.codegen.SourceWriter;
import org.teavm.javascript.RenderingContext;
import org.teavm.jso.impl.JSDependencyListener;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.spi.RendererListener;

class JSAliasRenderer
implements RendererListener {
    private static String variableChars = "abcdefghijklmnopqrstuvwxyz";
    private JSDependencyListener dependencyListener;
    private SourceWriter writer;
    private ClassReaderSource classSource;

    public JSAliasRenderer(JSDependencyListener dependencyListener) {
        this.dependencyListener = dependencyListener;
    }

    public void begin(RenderingContext context, BuildTarget buildTarget) throws IOException {
        this.writer = context.getWriter();
        this.classSource = context.getClassSource();
    }

    public void complete() throws IOException {
        if (!this.dependencyListener.isAnyAliasExists()) {
            return;
        }
        this.writer.append("(function()").ws().append("{").softNewLine().indent();
        this.writer.append("var c;").softNewLine();
        for (Map.Entry<String, JSDependencyListener.ExposedClass> entry : this.dependencyListener.getExposedClasses().entrySet()) {
            JSDependencyListener.ExposedClass cls = entry.getValue();
            ClassReader classReader = this.classSource.get(entry.getKey());
            if (classReader == null || cls.methods.isEmpty()) continue;
            boolean first = true;
            for (Map.Entry<MethodDescriptor, String> aliasEntry : cls.methods.entrySet()) {
                if (classReader.getMethod(aliasEntry.getKey()) == null) continue;
                if (first) {
                    this.writer.append("c").ws().append("=").ws().appendClass(entry.getKey()).append(".prototype;").softNewLine();
                    first = false;
                }
                if (this.isKeyword(aliasEntry.getValue())) {
                    this.writer.append("c[\"").append(aliasEntry.getValue()).append("\"]");
                } else {
                    this.writer.append("c.").append(aliasEntry.getValue());
                }
                this.writer.ws().append("=").ws().append("c.").appendMethod(aliasEntry.getKey()).append(";").softNewLine();
            }
            if (cls.functorField == null) continue;
            this.writeFunctor(cls);
        }
        this.writer.outdent().append("})();").newLine();
    }

    private boolean isKeyword(String id) {
        switch (id) {
            case "with": 
            case "delete": 
            case "in": 
            case "undefined": 
            case "debugger": 
            case "export": 
            case "function": 
            case "let": 
            case "var": 
            case "typeof": 
            case "yield": {
                return true;
            }
        }
        return false;
    }

    private void writeFunctor(JSDependencyListener.ExposedClass cls) throws IOException {
        String alias = cls.methods.get(cls.functorMethod);
        if (alias == null) {
            return;
        }
        this.writer.append("c.jso$functor$").append(alias).ws().append("=").ws().append("function()").ws().append("{").indent().softNewLine();
        this.writer.append("if").ws().append("(!this.").appendField(cls.functorField).append(")").ws().append("{").indent().softNewLine();
        this.writer.append("var self").ws().append('=').ws().append("this;").softNewLine();
        this.writer.append("this.").appendField(cls.functorField).ws().append('=').ws().append("function(");
        this.appendArguments(cls.functorMethod.parameterCount());
        this.writer.append(")").ws().append('{').indent().softNewLine();
        this.writer.append("return self.").appendMethod(cls.functorMethod).append('(');
        this.appendArguments(cls.functorMethod.parameterCount());
        this.writer.append(");").softNewLine();
        this.writer.outdent().append("};").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return this.").appendField(cls.functorField).append(';').softNewLine();
        this.writer.outdent().append("};").softNewLine();
    }

    private void appendArguments(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.writer.append(',').ws();
            }
            this.writer.append(this.variableName(i));
        }
    }

    private String variableName(int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(variableChars.charAt(index % variableChars.length()));
        if ((index /= variableChars.length()) > 0) {
            sb.append(index);
        }
        return sb.toString();
    }
}

