/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.HashMap;
import java.util.Map;
import org.teavm.jso.JSObject;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.ValueType;

class JSTypeHelper {
    private ClassReaderSource classSource;
    private Map<String, Boolean> knownJavaScriptClasses = new HashMap<String, Boolean>();
    private Map<String, Boolean> knownJavaScriptImplementations = new HashMap<String, Boolean>();

    public JSTypeHelper(ClassReaderSource classSource) {
        this.classSource = classSource;
        this.knownJavaScriptClasses.put(JSObject.class.getName(), true);
    }

    public boolean isJavaScriptClass(String className) {
        Boolean known = this.knownJavaScriptClasses.get(className);
        if (known == null) {
            known = this.examineIfJavaScriptClass(className);
            this.knownJavaScriptClasses.put(className, known);
        }
        return known;
    }

    public boolean isJavaScriptImplementation(String className) {
        Boolean known = this.knownJavaScriptImplementations.get(className);
        if (known == null) {
            known = this.examineIfJavaScriptImplementation(className);
            this.knownJavaScriptImplementations.put(className, known);
        }
        return known;
    }

    private boolean examineIfJavaScriptClass(String className) {
        ClassReader cls = this.classSource.get(className);
        if (cls == null || !cls.hasModifier(ElementModifier.INTERFACE) && !cls.hasModifier(ElementModifier.ABSTRACT)) {
            return false;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && this.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        return cls.getInterfaces().stream().anyMatch(iface -> this.isJavaScriptClass((String)iface));
    }

    private boolean examineIfJavaScriptImplementation(String className) {
        if (this.isJavaScriptClass(className)) {
            return false;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return false;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && this.isJavaScriptClass(cls.getParent())) {
            return true;
        }
        return cls.getInterfaces().stream().anyMatch(iface -> this.isJavaScriptClass((String)iface));
    }

    public boolean isSupportedType(ValueType type) {
        if (type == ValueType.VOID) {
            return false;
        }
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case LONG: {
                    return false;
                }
            }
            return true;
        }
        if (type instanceof ValueType.Array) {
            return this.isSupportedType(((ValueType.Array)type).getItemType());
        }
        if (type instanceof ValueType.Object) {
            String typeName = ((ValueType.Object)type).getClassName();
            return typeName.equals("java.lang.String") || this.isJavaScriptClass(typeName);
        }
        return false;
    }
}

