/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.jso.JSMethod;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.FunctorImpl;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

class JSDependencyListener
extends AbstractDependencyListener {
    private Map<String, ExposedClass> exposedClasses = new HashMap<String, ExposedClass>();
    private ClassReaderSource classSource;
    private DependencyAgent agent;
    private JSBodyRepository repository;
    private boolean anyAliasExists;

    public JSDependencyListener(JSBodyRepository repository) {
        this.repository = repository;
    }

    public void started(DependencyAgent agent) {
        this.agent = agent;
        this.classSource = agent.getClassSource();
    }

    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        MethodReference ref = method.getReference();
        Set<MethodReference> callbackMethods = this.repository.callbackMethods.get(ref);
        if (callbackMethods != null) {
            for (MethodReference callbackMethod : callbackMethods) {
                agent.linkMethod(callbackMethod, new CallLocation(ref)).use();
            }
        }
    }

    public void classReached(DependencyAgent agent, String className, CallLocation location) {
        this.getExposedClass(className);
    }

    boolean isAnyAliasExists() {
        return this.anyAliasExists;
    }

    Map<String, ExposedClass> getExposedClasses() {
        return this.exposedClasses;
    }

    private ExposedClass getExposedClass(String name) {
        ExposedClass cls = this.exposedClasses.get(name);
        if (cls == null) {
            cls = this.createExposedClass(name);
            this.exposedClasses.put(name, cls);
        }
        return cls;
    }

    private ExposedClass createExposedClass(String name) {
        FieldReader functorField;
        ClassReader cls = this.classSource.get(name);
        ExposedClass exposedCls = new ExposedClass();
        if (cls == null) {
            return exposedCls;
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName())) {
            ExposedClass parent = this.getExposedClass(cls.getParent());
            exposedCls.inheritedMethods.putAll(parent.inheritedMethods);
            exposedCls.inheritedMethods.putAll(parent.methods);
            exposedCls.implementedInterfaces.addAll(parent.implementedInterfaces);
        }
        this.addInterfaces(exposedCls, cls);
        for (MethodReader method : cls.getMethods()) {
            if (method.getName().equals("<init>") || !exposedCls.inheritedMethods.containsKey(method.getDescriptor()) && !exposedCls.methods.containsKey(method.getDescriptor())) continue;
            MethodDependency methodDep = this.agent.linkMethod(method.getReference(), null);
            methodDep.getVariable(0).propagate(this.agent.getType(name));
            methodDep.use();
        }
        if (exposedCls.functorField == null && (functorField = cls.getField("$$jso_functor$$")) != null) {
            exposedCls.functorField = functorField.getReference();
            AnnotationReader annot = cls.getAnnotations().get(FunctorImpl.class.getName());
            exposedCls.functorMethod = MethodDescriptor.parse((String)annot.getValue("value").getString());
        }
        return exposedCls;
    }

    private boolean addInterfaces(ExposedClass exposedCls, ClassReader cls) {
        boolean added = false;
        for (String ifaceName : cls.getInterfaces()) {
            ClassReader iface;
            if (exposedCls.implementedInterfaces.contains(ifaceName) || (iface = this.classSource.get(ifaceName)) == null || !this.addInterface(exposedCls, iface)) continue;
            added = true;
            for (MethodReader method : iface.getMethods()) {
                String nameStr;
                AnnotationValue nameVal;
                if (method.hasModifier(ElementModifier.STATIC) || exposedCls.inheritedMethods.containsKey(method.getDescriptor())) continue;
                String name = method.getName();
                AnnotationReader methodAnnot = method.getAnnotations().get(JSMethod.class.getName());
                if (methodAnnot != null && (nameVal = methodAnnot.getValue("value")) != null && !(nameStr = nameVal.getString()).isEmpty()) {
                    name = nameStr;
                }
                exposedCls.methods.put(method.getDescriptor(), name);
                this.anyAliasExists = true;
            }
        }
        return added;
    }

    private boolean addInterface(ExposedClass exposedCls, ClassReader cls) {
        if (cls.getName().equals(JSObject.class.getName())) {
            return true;
        }
        return this.addInterfaces(exposedCls, cls);
    }

    static class ExposedClass {
        Map<MethodDescriptor, String> inheritedMethods = new HashMap<MethodDescriptor, String>();
        Map<MethodDescriptor, String> methods = new HashMap<MethodDescriptor, String>();
        Set<String> implementedInterfaces = new HashSet<String>();
        FieldReference functorField;
        MethodDescriptor functorMethod;

        ExposedClass() {
        }
    }
}

