/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.teavm.backend.javascript.rendering.JSParser;
import org.teavm.cache.IncrementalDependencyRegistration;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSBuffer;
import org.teavm.jso.JSBufferType;
import org.teavm.jso.JSByRef;
import org.teavm.jso.JSClass;
import org.teavm.jso.JSFunctor;
import org.teavm.jso.JSPrimitiveType;
import org.teavm.jso.JSProperty;
import org.teavm.jso.JSTopLevel;
import org.teavm.jso.impl.DynamicGenerator;
import org.teavm.jso.impl.DynamicInjector;
import org.teavm.jso.impl.JSBodyAstEmitter;
import org.teavm.jso.impl.JSBodyBloatedEmitter;
import org.teavm.jso.impl.JSBodyDelegate;
import org.teavm.jso.impl.JSBodyInlineUtil;
import org.teavm.jso.impl.JSBodyRepository;
import org.teavm.jso.impl.JSImportAnnotationCache;
import org.teavm.jso.impl.JSImportDescriptor;
import org.teavm.jso.impl.JSMethods;
import org.teavm.jso.impl.JSType;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.jso.impl.JSTypeInference;
import org.teavm.jso.impl.JSValueMarshaller;
import org.teavm.jso.impl.JavaInvocationProcessor;
import org.teavm.jso.impl.JsBodyImportInfo;
import org.teavm.jso.impl.TeaVMErrorReporter;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.BasicBlock;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHierarchy;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.ProgramReader;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.util.InstructionVariableMapper;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;
import org.teavm.rhino.javascript.CompilerEnvirons;
import org.teavm.rhino.javascript.ErrorReporter;
import org.teavm.rhino.javascript.ast.AstNode;
import org.teavm.rhino.javascript.ast.AstRoot;
import org.teavm.rhino.javascript.ast.FunctionNode;

class JSClassProcessor {
    private static final String NO_SIDE_EFFECTS = NoSideEffects.class.getName();
    private final ClassReaderSource classSource;
    private final ClassHierarchy hierarchy;
    private final JSBodyRepository repository;
    private final JavaInvocationProcessor javaInvocationProcessor;
    private Program program;
    private int[] variableAliases;
    private boolean[] nativeConstructedObjects;
    private JSTypeInference types;
    private final List<Instruction> replacement = new ArrayList<Instruction>();
    private final JSTypeHelper typeHelper;
    private final Diagnostics diagnostics;
    private final Map<MethodReference, MethodReader> overriddenMethodCache = new HashMap<MethodReference, MethodReader>();
    private final boolean strict;
    private JSValueMarshaller marshaller;
    private IncrementalDependencyRegistration incrementalCache;
    private JSImportAnnotationCache annotationCache;
    private ClassReader objectClass;
    private Predicate<String> classFilter = n -> true;
    private boolean wasmGC;

    JSClassProcessor(ClassReaderSource classSource, ClassHierarchy hierarchy, JSTypeHelper typeHelper, JSBodyRepository repository, Diagnostics diagnostics, IncrementalDependencyRegistration incrementalCache, boolean strict) {
        this.classSource = classSource;
        this.hierarchy = hierarchy;
        this.typeHelper = typeHelper;
        this.repository = repository;
        this.diagnostics = diagnostics;
        this.incrementalCache = incrementalCache;
        this.strict = strict;
        this.javaInvocationProcessor = new JavaInvocationProcessor(typeHelper, repository, classSource, diagnostics);
        this.annotationCache = new JSImportAnnotationCache(classSource, diagnostics);
    }

    void setWasmGC(boolean wasmGC) {
        this.wasmGC = wasmGC;
    }

    void setClassFilter(Predicate<String> classFilter) {
        this.classFilter = classFilter;
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    MethodReference isFunctor(String className) {
        if (!this.typeHelper.isJavaScriptImplementation(className)) {
            return null;
        }
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        HashMap<MethodDescriptor, MethodReference> methods = new HashMap<MethodDescriptor, MethodReference>();
        this.getFunctorMethods(className, methods);
        if (methods.size() == 1) {
            return (MethodReference)methods.values().iterator().next();
        }
        return null;
    }

    private void getFunctorMethods(String className, Map<MethodDescriptor, MethodReference> methods) {
        this.classSource.getAncestors(className).forEach(cls -> {
            MethodReference method;
            if (cls.getAnnotations().get(JSFunctor.class.getName()) != null && this.marshaller.isProperFunctor((ClassReader)cls) && !methods.containsKey((method = ((MethodReader)cls.getMethods().iterator().next()).getReference()).getDescriptor())) {
                methods.put(method.getDescriptor(), method);
            }
        });
    }

    void processClass(ClassHolder cls) {
        HashSet<MethodDescriptor> preservedMethods = new HashSet<MethodDescriptor>();
        for (String iface : cls.getInterfaces()) {
            if (!this.typeHelper.isJavaScriptClass(iface)) continue;
            this.addPreservedMethods(iface, preservedMethods);
        }
    }

    private void addPreservedMethods(String ifaceName, Set<MethodDescriptor> methods) {
        ClassReader iface = this.classSource.get(ifaceName);
        for (MethodReader method : iface.getMethods()) {
            methods.add(method.getDescriptor());
        }
        for (String superIfaceName : iface.getInterfaces()) {
            this.addPreservedMethods(superIfaceName, methods);
        }
    }

    void processMemberMethods(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            int i;
            if (method.hasModifier(ElementModifier.STATIC) || method.getProgram() == null || method.getProgram().basicBlockCount() <= 0) continue;
            ValueType[] staticSignature = JSClassProcessor.getStaticSignature(method.getReference());
            MethodHolder callerMethod = new MethodHolder(new MethodDescriptor(method.getName() + "$static", staticSignature));
            callerMethod.getModifiers().add(ElementModifier.STATIC);
            Program program = ProgramUtils.copy((ProgramReader)method.getProgram());
            program.createVariable();
            InstructionVariableMapper variableMapper = new InstructionVariableMapper(var -> program.variableAt(var.getIndex() + 1));
            for (i = program.variableCount() - 1; i > 0; --i) {
                program.variableAt(i).setDebugName(program.variableAt(i - 1).getDebugName());
                program.variableAt(i).setLabel(program.variableAt(i - 1).getLabel());
            }
            for (i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                variableMapper.apply(block);
            }
            callerMethod.setProgram(program);
            ModelUtils.copyAnnotations((AnnotationContainerReader)method.getAnnotations(), (AnnotationContainer)callerMethod.getAnnotations());
            cls.addMethod(callerMethod);
        }
    }

    private MethodReader getOverriddenMethod(MethodReader finalMethod) {
        MethodReference ref = finalMethod.getReference();
        if (!this.overriddenMethodCache.containsKey(ref)) {
            this.overriddenMethodCache.put(ref, this.findOverriddenMethod(finalMethod.getOwnerName(), finalMethod));
        }
        return this.overriddenMethodCache.get(ref);
    }

    private MethodReader findOverriddenMethod(String className, MethodReader finalMethod) {
        if (finalMethod.getName().equals("<init>")) {
            return null;
        }
        return this.classSource.getAncestors(className).skip(1L).map(cls -> cls.getMethod(finalMethod.getDescriptor())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static ValueType[] getStaticSignature(MethodReference method) {
        ValueType[] signature = method.getSignature();
        ValueType[] staticSignature = new ValueType[signature.length + 1];
        for (int i = 0; i < signature.length; ++i) {
            staticSignature[i + 1] = signature[i];
        }
        staticSignature[0] = JSMethods.JS_OBJECT;
        return staticSignature;
    }

    private void setCurrentProgram(Program program) {
        this.program = program;
        this.marshaller = new JSValueMarshaller(this.diagnostics, this.typeHelper, this.classSource, this.hierarchy, program, this.replacement);
        this.findVariableAliases();
    }

    private void findVariableAliases() {
        if (this.program == null) {
            return;
        }
        this.variableAliases = new int[this.program.variableCount()];
        this.nativeConstructedObjects = new boolean[this.program.variableCount()];
        boolean[] resolved = new boolean[this.program.variableCount()];
        Arrays.fill(resolved, true);
        for (int i = 0; i < this.variableAliases.length; ++i) {
            this.variableAliases[i] = i;
        }
        for (BasicBlock block : this.program.getBasicBlocks()) {
            for (Instruction instruction : block) {
                ConstructInstruction construct;
                if (instruction instanceof AssignInstruction) {
                    AssignInstruction assign = (AssignInstruction)instruction;
                    int from = assign.getAssignee().getIndex();
                    int to = assign.getReceiver().getIndex();
                    this.variableAliases[to] = from;
                    resolved[assign.getAssignee().getIndex()] = true;
                    continue;
                }
                if (!(instruction instanceof ConstructInstruction) || !this.typeHelper.isJavaScriptClass((construct = (ConstructInstruction)instruction).getType())) continue;
                this.nativeConstructedObjects[construct.getReceiver().getIndex()] = true;
            }
        }
        for (int i = 0; i < this.variableAliases.length; ++i) {
            this.getVariableAlias(i, resolved);
        }
    }

    private int getVariableAlias(int index, boolean[] resolved) {
        if (resolved[index]) {
            return this.variableAliases[index];
        }
        resolved[index] = true;
        this.variableAliases[index] = this.getVariableAlias(this.variableAliases[index], resolved);
        return this.variableAliases[index];
    }

    void processProgram(MethodHolder methodToProcess) {
        this.setCurrentProgram(methodToProcess.getProgram());
        this.types = new JSTypeInference(this.typeHelper, this.classSource, this.program, methodToProcess.getReference(), this.wasmGC);
        this.types.ensure();
        if (this.wasmGC) {
            this.wrapJsPhis(methodToProcess.getReference());
        }
        for (int i = 0; i < this.program.basicBlockCount(); ++i) {
            BasicBlock block = this.program.basicBlockAt(i);
            for (Instruction insn : block) {
                CallLocation callLocation;
                if (insn instanceof CastInstruction) {
                    this.replacement.clear();
                    callLocation = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                    if (!this.processCast((CastInstruction)insn, callLocation)) continue;
                    insn.insertNextAll(this.replacement);
                    insn.delete();
                    continue;
                }
                if (insn instanceof IsInstanceInstruction) {
                    this.processIsInstance((IsInstanceInstruction)insn);
                    continue;
                }
                if (insn instanceof InvokeInstruction) {
                    InvokeInstruction invoke = (InvokeInstruction)insn;
                    CallLocation callLocation2 = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                    if (this.processToString(invoke, callLocation2)) continue;
                    MethodReader method = this.getMethod(invoke.getMethod().getClassName(), invoke.getMethod().getDescriptor());
                    this.processInvokeArgs(invoke, method);
                    if (method == null) continue;
                    this.replacement.clear();
                    if (!this.processInvocation(method, callLocation2, invoke, methodToProcess)) continue;
                    insn.insertNextAll(this.replacement);
                    insn.delete();
                    continue;
                }
                if (insn instanceof GetFieldInstruction) {
                    callLocation = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                    this.processGetField((GetFieldInstruction)insn, callLocation);
                    continue;
                }
                if (insn instanceof PutFieldInstruction) {
                    callLocation = new CallLocation(methodToProcess.getReference(), insn.getLocation());
                    this.processPutField((PutFieldInstruction)insn, callLocation);
                    continue;
                }
                if (insn instanceof GetElementInstruction) {
                    this.processGetFromArray((GetElementInstruction)insn);
                    continue;
                }
                if (insn instanceof PutElementInstruction) {
                    this.processPutIntoArray((PutElementInstruction)insn);
                    continue;
                }
                if (insn instanceof ConstructArrayInstruction) {
                    this.processConstructArray((ConstructArrayInstruction)insn);
                    continue;
                }
                if (insn instanceof ExitInstruction) {
                    ExitInstruction exit = (ExitInstruction)insn;
                    exit.setValueToReturn(this.convertValue(insn, exit.getValueToReturn(), methodToProcess.getResultType()));
                    continue;
                }
                if (insn instanceof ClassConstantInstruction) {
                    this.processClassConstant((ClassConstantInstruction)insn);
                    continue;
                }
                if (insn instanceof ConstructInstruction) {
                    this.processConstructObject((ConstructInstruction)insn);
                    continue;
                }
                if (insn instanceof AssignInstruction) {
                    AssignInstruction assign = (AssignInstruction)insn;
                    int index = this.variableAliases[assign.getReceiver().getIndex()];
                    if (!this.nativeConstructedObjects[index]) continue;
                    assign.delete();
                    continue;
                }
                if (insn instanceof BinaryBranchingInstruction) {
                    this.processReferenceEquality((BinaryBranchingInstruction)insn);
                    continue;
                }
                if (!(insn instanceof BranchingInstruction)) continue;
                this.processReferenceEquality((BranchingInstruction)insn);
            }
        }
        InstructionVariableMapper varMapper = new InstructionVariableMapper(v -> {
            if (v.getIndex() < this.nativeConstructedObjects.length && this.nativeConstructedObjects[this.variableAliases[v.getIndex()]]) {
                return this.program.variableAt(this.variableAliases[v.getIndex()]);
            }
            return v;
        });
        for (BasicBlock block : this.program.getBasicBlocks()) {
            varMapper.apply(block);
        }
    }

    private void wrapJsPhis(MethodReference methodReference) {
        boolean changed = false;
        for (BasicBlock block : this.program.getBasicBlocks()) {
            for (Phi phi : block.getPhis()) {
                if (this.types.typeOf(phi.getReceiver()) != JSType.MIXED) continue;
                for (Incoming incoming : phi.getIncomings()) {
                    if (this.types.typeOf(incoming.getValue()) != JSType.JS) continue;
                    changed = true;
                    InvokeInstruction wrap = new InvokeInstruction();
                    wrap.setType(InvocationType.SPECIAL);
                    wrap.setMethod(new MethodReference("org.teavm.jso.impl.JSWrapper", "wrap", new ValueType[]{JSMethods.JS_OBJECT, JSMethods.OBJECT}));
                    wrap.setArguments(new Variable[]{incoming.getValue()});
                    wrap.setReceiver(this.program.createVariable());
                    incoming.getSource().getLastInstruction().insertPrevious((Instruction)wrap);
                    incoming.setValue(wrap.getReceiver());
                }
            }
        }
        if (changed) {
            this.types = new JSTypeInference(this.typeHelper, this.classSource, this.program, methodReference, this.wasmGC);
            this.types.ensure();
        }
    }

    private void processInvokeArgs(InvokeInstruction invoke, MethodReader methodToInvoke) {
        if (methodToInvoke != null && methodToInvoke.getAnnotations().get(JSBody.class.getName()) != null) {
            return;
        }
        String className = invoke.getMethod().getClassName();
        if (this.typeHelper.isJavaScriptClass(invoke.getMethod().getClassName())) {
            if (invoke.getMethod().getName().equals("<init>") || this.getObjectClass().getMethod(invoke.getMethod().getDescriptor()) == null) {
                return;
            }
            className = "java.lang.Object";
        }
        this.convertInvokeArgs(invoke, className);
    }

    private void convertInvokeArgs(InvokeInstruction invoke, String className) {
        Variable[] newArgs = null;
        for (int i = 0; i < invoke.getArguments().size(); ++i) {
            ValueType type = invoke.getMethod().parameterType(i);
            Variable arg = (Variable)invoke.getArguments().get(i);
            Variable newArg = this.convertValue((Instruction)invoke, arg, type);
            if (newArg == arg) continue;
            if (newArgs == null) {
                newArgs = invoke.getArguments().toArray(new Variable[0]);
            }
            newArgs[i] = newArg;
        }
        if (newArgs != null) {
            invoke.setArguments(newArgs);
        }
        if (invoke.getInstance() != null) {
            invoke.setInstance(this.convertValue((Instruction)invoke, invoke.getInstance(), (ValueType)ValueType.object((String)className)));
        }
    }

    private void processGetField(GetFieldInstruction insn, CallLocation callLocation) {
        if (!this.isJsField(insn.getField(), insn.getInstance() == null)) {
            return;
        }
        this.replacement.clear();
        String propertyName = this.getPropertyName(insn.getField());
        Variable result = insn.getReceiver() != null ? this.program.createVariable() : null;
        Variable instance = this.getCallTarget(insn.getInstance(), insn.getField(), insn.getLocation());
        this.addPropertyGet(propertyName, instance, result, insn.getLocation(), true);
        if (result != null) {
            result = this.marshaller.unwrapReturnValue(callLocation, result, insn.getFieldType(), false, this.canBeOnlyJava(insn.getReceiver()));
            this.copyVar(result, insn.getReceiver(), insn.getLocation());
        }
        insn.insertNextAll(this.replacement);
        insn.delete();
    }

    private void processPutField(PutFieldInstruction insn, CallLocation callLocation) {
        if (!this.isJsField(insn.getField(), insn.getInstance() == null)) {
            insn.setValue(this.convertValue((Instruction)insn, insn.getValue(), insn.getFieldType()));
            return;
        }
        this.replacement.clear();
        String propertyName = this.getPropertyName(insn.getField());
        Variable instance = this.getCallTarget(insn.getInstance(), insn.getField(), insn.getLocation());
        Variable value = insn.getValue();
        value = this.marshaller.wrapArgument(callLocation, value, insn.getFieldType(), (JSType)this.types.typeOf(value), false, null);
        this.addPropertySet(propertyName, instance, value, insn.getLocation(), true);
        insn.insertNextAll(this.replacement);
        insn.delete();
    }

    private boolean isJsField(FieldReference fieldRef, boolean isStatic) {
        if (!this.typeHelper.isJavaScriptClass(fieldRef.getClassName())) {
            return false;
        }
        if (!isStatic) {
            return true;
        }
        ClassReader cls = this.classSource.get(fieldRef.getClassName());
        if (cls == null) {
            return false;
        }
        FieldReader field = cls.getField(fieldRef.getFieldName());
        return field != null && field.getAnnotations().get(JSProperty.class.getName()) != null;
    }

    private String getPropertyName(FieldReference fieldRef) {
        AnnotationValue value;
        AnnotationReader annot;
        FieldReader field;
        ClassReader cls = this.classSource.get(fieldRef.getClassName());
        if (cls != null && (field = cls.getField(fieldRef.getFieldName())) != null && (annot = field.getAnnotations().get(JSProperty.class.getName())) != null && (value = annot.getValue("value")) != null) {
            return value.getString();
        }
        return fieldRef.getFieldName();
    }

    private void processGetFromArray(GetElementInstruction insn) {
        if (insn.getType() != ArrayElementType.OBJECT) {
            return;
        }
        JSType type = (JSType)this.types.typeOf(insn.getReceiver());
        if (type == JSType.JS || type == JSType.MIXED) {
            InvokeInstruction unwrap = new InvokeInstruction();
            unwrap.setType(InvocationType.SPECIAL);
            unwrap.setMethod(type == JSType.MIXED ? JSMethods.MAYBE_UNWRAP : JSMethods.UNWRAP);
            unwrap.setArguments(new Variable[]{this.program.createVariable()});
            unwrap.setReceiver(insn.getReceiver());
            unwrap.setLocation(insn.getLocation());
            insn.setReceiver((Variable)unwrap.getArguments().get(0));
            insn.insertNext((Instruction)unwrap);
            if (this.wasmGC) {
                InvokeInstruction invoke = new InvokeInstruction();
                invoke.setType(InvocationType.SPECIAL);
                invoke.setMethod(new MethodReference("org.teavm.jso.impl.JS", "jsArrayItem", new ValueType[]{JSMethods.OBJECT, ValueType.INTEGER, JSMethods.OBJECT}));
                invoke.setReceiver(insn.getReceiver());
                invoke.setArguments(new Variable[]{insn.getArray(), insn.getIndex()});
                invoke.setLocation(insn.getLocation());
                insn.replace((Instruction)invoke);
            }
        }
    }

    private void processPutIntoArray(PutElementInstruction insn) {
        if (insn.getType() != ArrayElementType.OBJECT) {
            return;
        }
        JSType type = (JSType)this.types.typeOf(insn.getValue());
        if (type == JSType.JS || type == JSType.MIXED) {
            InvokeInstruction wrap = new InvokeInstruction();
            wrap.setType(InvocationType.SPECIAL);
            wrap.setMethod(type == JSType.MIXED ? JSMethods.MAYBE_WRAP : JSMethods.WRAP);
            wrap.setArguments(new Variable[]{insn.getValue()});
            wrap.setReceiver(this.program.createVariable());
            wrap.setLocation(insn.getLocation());
            insn.setValue(wrap.getReceiver());
            insn.insertPrevious((Instruction)wrap);
        }
    }

    private void processConstructArray(ConstructArrayInstruction insn) {
        ValueType arrayType = this.processType((ValueType)ValueType.arrayOf((ValueType)insn.getItemType()));
        insn.setItemType(((ValueType.Array)arrayType).getItemType());
    }

    private void processClassConstant(ClassConstantInstruction insn) {
        insn.setConstant(this.processType(insn.getConstant()));
    }

    private void processConstructObject(ConstructInstruction insn) {
        if (this.nativeConstructedObjects[insn.getReceiver().getIndex()]) {
            insn.delete();
        }
    }

    private void processReferenceEquality(BinaryBranchingInstruction instruction) {
        boolean equal;
        if (!this.wasmGC) {
            return;
        }
        switch (instruction.getCondition()) {
            case REFERENCE_EQUAL: {
                equal = true;
                break;
            }
            case REFERENCE_NOT_EQUAL: {
                equal = false;
                break;
            }
            default: {
                return;
            }
        }
        JSType first = (JSType)this.types.typeOf(instruction.getFirstOperand());
        JSType second = (JSType)this.types.typeOf(instruction.getSecondOperand());
        if (first == JSType.JS || second == JSType.JS) {
            InvokeInstruction call = new InvokeInstruction();
            call.setType(InvocationType.SPECIAL);
            call.setLocation(instruction.getLocation());
            Variable conditionVar = this.program.createVariable();
            if (first == JSType.NULL || second == JSType.NULL) {
                call.setMethod(new MethodReference("org.teavm.jso.impl.JS", "isNull", new ValueType[]{JSMethods.JS_OBJECT, ValueType.BOOLEAN}));
                call.setArguments(new Variable[]{first == JSType.NULL ? instruction.getSecondOperand() : instruction.getFirstOperand()});
                call.setReceiver(conditionVar);
                instruction.insertPrevious((Instruction)call);
            } else {
                Variable firstOperand = instruction.getFirstOperand();
                Variable secondOperand = instruction.getSecondOperand();
                if (first != JSType.JS) {
                    firstOperand = this.convertToJs(firstOperand, (Instruction)instruction);
                }
                if (second != JSType.JS) {
                    secondOperand = this.convertToJs(secondOperand, (Instruction)instruction);
                }
                call.setMethod(new MethodReference("org.teavm.jso.impl.JS", "sameRef", new ValueType[]{JSMethods.JS_OBJECT, JSMethods.JS_OBJECT, ValueType.BOOLEAN}));
                call.setArguments(new Variable[]{firstOperand, secondOperand});
                call.setReceiver(conditionVar);
                instruction.insertPrevious((Instruction)call);
            }
            BranchingInstruction newCondition = new BranchingInstruction(equal ? BranchingCondition.NOT_EQUAL : BranchingCondition.EQUAL);
            newCondition.setOperand(call.getReceiver());
            newCondition.setConsequent(instruction.getConsequent());
            newCondition.setAlternative(instruction.getAlternative());
            newCondition.setLocation(instruction.getLocation());
            instruction.replace((Instruction)newCondition);
        }
    }

    private void processReferenceEquality(BranchingInstruction instruction) {
        boolean equal;
        if (!this.wasmGC) {
            return;
        }
        switch (instruction.getCondition()) {
            case NULL: {
                equal = true;
                break;
            }
            case NOT_NULL: {
                equal = false;
                break;
            }
            default: {
                return;
            }
        }
        JSType type = (JSType)this.types.typeOf(instruction.getOperand());
        if (type == JSType.JS) {
            InvokeInstruction call = new InvokeInstruction();
            call.setType(InvocationType.SPECIAL);
            call.setLocation(instruction.getLocation());
            call.setMethod(new MethodReference("org.teavm.jso.impl.JS", "isNull", new ValueType[]{JSMethods.JS_OBJECT, ValueType.BOOLEAN}));
            call.setArguments(new Variable[]{instruction.getOperand()});
            call.setReceiver(this.program.createVariable());
            instruction.insertPrevious((Instruction)call);
            instruction.setOperand(call.getReceiver());
            instruction.setCondition(equal ? BranchingCondition.NOT_EQUAL : BranchingCondition.EQUAL);
        }
    }

    private Variable convertToJs(Variable value, Instruction instruction) {
        InvokeInstruction call = new InvokeInstruction();
        call.setType(InvocationType.SPECIAL);
        call.setMethod(new MethodReference("org.teavm.jso.impl.JS", "directJavaToJs", new ValueType[]{JSMethods.OBJECT, JSMethods.JS_OBJECT}));
        call.setArguments(new Variable[]{value});
        call.setReceiver(this.program.createVariable());
        call.setLocation(instruction.getLocation());
        instruction.insertPrevious((Instruction)call);
        return call.getReceiver();
    }

    private ValueType processType(ValueType type) {
        return JSClassProcessor.processType(this.typeHelper, type);
    }

    static ValueType processType(JSTypeHelper typeHelper, ValueType type) {
        ValueType originalType = type;
        int degree = 0;
        while (type instanceof ValueType.Array) {
            ++degree;
            type = ((ValueType.Array)type).getItemType();
        }
        if (!(type instanceof ValueType.Object)) {
            return originalType;
        }
        String className = ((ValueType.Object)type).getClassName();
        if (!typeHelper.isJavaScriptClass(className)) {
            return originalType;
        }
        Object object = type = degree > 0 ? JSMethods.OBJECT : ValueType.object((String)"org.teavm.jso.impl.JSWrapper");
        while (degree-- > 0) {
            type = ValueType.arrayOf((ValueType)type);
        }
        return type;
    }

    private boolean processCast(CastInstruction cast, CallLocation location) {
        if (cast.isWeak()) {
            return false;
        }
        if (!(cast.getTargetType() instanceof ValueType.Object)) {
            cast.setTargetType(this.processType(cast.getTargetType()));
            return false;
        }
        String targetClassName = ((ValueType.Object)cast.getTargetType()).getClassName();
        if (!this.typeHelper.isJavaScriptClass(targetClassName)) {
            return false;
        }
        cast.setValue(this.unwrapJavaToJs((Instruction)cast, cast.getValue()));
        ClassReader targetClass = this.classSource.get(targetClassName);
        if (targetClass.getAnnotations().get(JSFunctor.class.getName()) == null) {
            if (!this.strict || this.isTransparent(targetClassName)) {
                AssignInstruction assign = new AssignInstruction();
                assign.setLocation(location.getSourceLocation());
                assign.setAssignee(cast.getValue());
                assign.setReceiver(cast.getReceiver());
                this.replacement.add((Instruction)assign);
            } else {
                Variable instanceOfResult = this.program.createVariable();
                this.processIsInstanceUnwrapped(cast.getLocation(), cast.getValue(), targetClassName, instanceOfResult);
                InvokeInstruction invoke = new InvokeInstruction();
                invoke.setType(InvocationType.SPECIAL);
                invoke.setMethod(JSMethods.THROW_CCE_IF_FALSE);
                invoke.setArguments(new Variable[]{instanceOfResult, cast.getValue()});
                invoke.setReceiver(cast.getReceiver());
                this.replacement.add((Instruction)invoke);
            }
            return true;
        }
        Variable result = this.marshaller.unwrapFunctor(location, cast.getValue(), targetClass);
        AssignInstruction assign = new AssignInstruction();
        assign.setLocation(location.getSourceLocation());
        assign.setAssignee(result);
        assign.setReceiver(cast.getReceiver());
        this.replacement.add((Instruction)assign);
        return true;
    }

    private void processIsInstance(IsInstanceInstruction isInstance) {
        if (!(isInstance.getType() instanceof ValueType.Object)) {
            isInstance.setType(this.processType(isInstance.getType()));
            return;
        }
        String targetClassName = ((ValueType.Object)isInstance.getType()).getClassName();
        if (!this.typeHelper.isJavaScriptClass(targetClassName)) {
            return;
        }
        this.replacement.clear();
        this.processIsInstance(isInstance.getLocation(), (JSType)this.types.typeOf(isInstance.getValue()), isInstance.getValue(), targetClassName, isInstance.getReceiver());
        isInstance.insertPreviousAll(this.replacement);
        isInstance.delete();
        this.replacement.clear();
    }

    private void processIsInstance(TextLocation location, JSType type, Variable value, String targetClassName, Variable receiver) {
        if (type == JSType.JS) {
            if (this.isTransparent(targetClassName)) {
                IntegerConstantInstruction cst = new IntegerConstantInstruction();
                cst.setConstant(1);
                cst.setReceiver(receiver);
                cst.setLocation(location);
                this.replacement.add((Instruction)cst);
            } else {
                String primitiveType = this.getPrimitiveType(targetClassName);
                InvokeInstruction invoke = new InvokeInstruction();
                invoke.setType(InvocationType.SPECIAL);
                invoke.setMethod(primitiveType != null ? JSMethods.IS_PRIMITIVE : JSMethods.INSTANCE_OF);
                Variable secondArg = primitiveType != null ? this.marshaller.addJsString(primitiveType, location) : this.marshaller.classRef(targetClassName, location);
                invoke.setArguments(new Variable[]{value, secondArg});
                invoke.setReceiver(receiver);
                invoke.setLocation(location);
                this.replacement.add((Instruction)invoke);
            }
        } else if (this.isTransparent(targetClassName)) {
            InvokeInstruction invoke = new InvokeInstruction();
            invoke.setType(InvocationType.SPECIAL);
            invoke.setMethod(JSMethods.IS_JS);
            invoke.setArguments(new Variable[]{value});
            invoke.setReceiver(receiver);
            invoke.setLocation(location);
            this.replacement.add((Instruction)invoke);
        } else {
            String primitiveType = this.getPrimitiveType(targetClassName);
            InvokeInstruction invoke = new InvokeInstruction();
            invoke.setType(InvocationType.SPECIAL);
            invoke.setMethod(primitiveType != null ? JSMethods.WRAPPER_IS_PRIMITIVE : JSMethods.WRAPPER_INSTANCE_OF);
            Variable secondArg = primitiveType != null ? this.marshaller.addJsString(primitiveType, location) : this.marshaller.classRef(targetClassName, location);
            invoke.setArguments(new Variable[]{value, secondArg});
            invoke.setReceiver(receiver);
            invoke.setLocation(location);
            this.replacement.add((Instruction)invoke);
        }
    }

    private void processIsInstanceUnwrapped(TextLocation location, Variable value, String targetClassName, Variable receiver) {
        String primitiveType = this.getPrimitiveType(targetClassName);
        InvokeInstruction invoke = new InvokeInstruction();
        invoke.setType(InvocationType.SPECIAL);
        invoke.setMethod(primitiveType != null ? JSMethods.IS_PRIMITIVE : JSMethods.INSTANCE_OF_OR_NULL);
        Variable secondArg = primitiveType != null ? this.marshaller.addJsString(primitiveType, location) : this.marshaller.classRef(targetClassName, location);
        invoke.setArguments(new Variable[]{value, secondArg});
        invoke.setReceiver(receiver);
        invoke.setLocation(location);
        this.replacement.add((Instruction)invoke);
    }

    private boolean isTransparent(String className) {
        AnnotationValue transparent;
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return true;
        }
        if (cls.hasModifier(ElementModifier.INTERFACE)) {
            return true;
        }
        AnnotationReader clsAnnot = cls.getAnnotations().get(JSClass.class.getName());
        if (clsAnnot != null && (transparent = clsAnnot.getValue("transparent")) != null) {
            return transparent.getBoolean();
        }
        return false;
    }

    private String getPrimitiveType(String className) {
        AnnotationValue value;
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        AnnotationReader clsAnnot = cls.getAnnotations().get(JSPrimitiveType.class.getName());
        if (clsAnnot != null && (value = clsAnnot.getValue("value")) != null) {
            return value.getString();
        }
        return null;
    }

    private Variable convertValue(Instruction instruction, Variable var, ValueType type) {
        if (!(type instanceof ValueType.Object)) {
            return var;
        }
        String cls = ((ValueType.Object)type).getClassName();
        if (this.typeHelper.isJavaScriptClass(cls)) {
            return this.convertJavaValueToJs(instruction, var);
        }
        return this.convertJsValueToJava(instruction, var);
    }

    private Variable convertJsValueToJava(Instruction instruction, Variable var) {
        JSType varType = (JSType)this.types.typeOf(var);
        if (varType != JSType.JS && varType != JSType.MIXED) {
            return var;
        }
        InvokeInstruction wrap = new InvokeInstruction();
        wrap.setType(InvocationType.SPECIAL);
        wrap.setMethod(varType == JSType.JS ? JSMethods.WRAP : JSMethods.MAYBE_WRAP);
        wrap.setArguments(new Variable[]{var});
        wrap.setReceiver(this.program.createVariable());
        wrap.setLocation(instruction.getLocation());
        instruction.insertPrevious((Instruction)wrap);
        return wrap.getReceiver();
    }

    private Variable convertJavaValueToJs(Instruction instruction, Variable var) {
        JSType varType = (JSType)this.types.typeOf(var);
        if (varType == JSType.JS || varType == JSType.MIXED || varType == JSType.NULL) {
            return var;
        }
        InvokeInstruction wrap = new InvokeInstruction();
        wrap.setType(InvocationType.SPECIAL);
        wrap.setMethod(JSMethods.UNWRAP);
        wrap.setArguments(new Variable[]{var});
        wrap.setReceiver(this.program.createVariable());
        wrap.setLocation(instruction.getLocation());
        instruction.insertPrevious((Instruction)wrap);
        return wrap.getReceiver();
    }

    private Variable unwrapJavaToJs(Instruction instruction, Variable var) {
        JSType varType = (JSType)this.types.typeOf(var);
        if (varType != JSType.JAVA && varType != JSType.MIXED) {
            return var;
        }
        InvokeInstruction unwrap = new InvokeInstruction();
        unwrap.setType(InvocationType.SPECIAL);
        unwrap.setMethod(varType == JSType.JAVA ? JSMethods.UNWRAP : JSMethods.MAYBE_UNWRAP);
        unwrap.setArguments(new Variable[]{var});
        unwrap.setReceiver(this.program.createVariable());
        unwrap.setLocation(instruction.getLocation());
        instruction.insertPrevious((Instruction)unwrap);
        return unwrap.getReceiver();
    }

    private boolean processToString(InvokeInstruction invoke, CallLocation location) {
        if (!(invoke.getMethod().getName().equals("toString") && invoke.getArguments().isEmpty() && invoke.getInstance() != null && invoke.getMethod().getReturnType().isObject(String.class) && this.types.typeOf(invoke.getInstance()) == JSType.JS)) {
            return false;
        }
        this.replacement.clear();
        Variable methodName = this.marshaller.addStringWrap(this.marshaller.addString("toString", invoke.getLocation()), invoke.getLocation());
        InvokeInstruction jsInvoke = new InvokeInstruction();
        jsInvoke.setType(InvocationType.SPECIAL);
        jsInvoke.setMethod(JSMethods.invoke(0));
        jsInvoke.setReceiver(this.program.createVariable());
        jsInvoke.setLocation(invoke.getLocation());
        jsInvoke.setArguments(new Variable[]{invoke.getInstance(), methodName});
        this.replacement.add((Instruction)jsInvoke);
        AssignInstruction assign = new AssignInstruction();
        assign.setAssignee(this.marshaller.unwrapReturnValue(location, jsInvoke.getReceiver(), invoke.getMethod().getReturnType(), false, this.canBeOnlyJava(invoke.getReceiver())));
        assign.setReceiver(invoke.getReceiver());
        assign.setLocation(invoke.getLocation());
        this.replacement.add((Instruction)assign);
        invoke.insertNextAll(this.replacement);
        this.replacement.clear();
        invoke.delete();
        return true;
    }

    private boolean processInvocation(MethodReader method, CallLocation callLocation, InvokeInstruction invoke, MethodHolder methodToProcess) {
        if (method.getAnnotations().get(JSBody.class.getName()) != null) {
            return this.processJSBodyInvocation(method, callLocation, invoke, methodToProcess);
        }
        if (!this.typeHelper.isJavaScriptClass(invoke.getMethod().getClassName())) {
            return false;
        }
        if (method.getName().equals("<init>")) {
            return this.processConstructor(method, callLocation, invoke);
        }
        boolean isStatic = method.hasModifier(ElementModifier.STATIC);
        if (method.getProgram() != null && method.getProgram().basicBlockCount() > 0) {
            if (isStatic) {
                this.convertInvokeArgs(invoke, method.getOwnerName());
                return false;
            }
            MethodReader overridden = this.getOverriddenMethod(method);
            if (overridden != null) {
                this.diagnostics.error(callLocation, "JS final method {{m0}} overrides {{m1}}. Overriding final method of overlay types is prohibited.", new Object[]{method.getReference(), overridden.getReference()});
            }
            if (method.getProgram() != null && method.getProgram().basicBlockCount() > 0) {
                invoke.setMethod(new MethodReference(method.getOwnerName(), method.getName() + "$static", JSClassProcessor.getStaticSignature(method.getReference())));
                Variable[] newArguments = new Variable[invoke.getArguments().size() + 1];
                newArguments[0] = invoke.getInstance();
                for (int i = 0; i < invoke.getArguments().size(); ++i) {
                    newArguments[i + 1] = this.convertValue((Instruction)invoke, (Variable)invoke.getArguments().get(i), invoke.getMethod().parameterType(i + 1));
                }
                invoke.setArguments(newArguments);
                invoke.setInstance(null);
            }
            invoke.setType(InvocationType.SPECIAL);
            return false;
        }
        JSImportDescriptor annot = (JSImportDescriptor)this.annotationCache.get(method.getReference(), callLocation);
        if (annot != null) {
            switch (annot.kind) {
                case PROPERTY: {
                    return this.processProperty(method, annot.name, callLocation, invoke);
                }
                case INDEXER: {
                    return this.processIndexer(method, callLocation, invoke);
                }
                case METHOD: {
                    return this.processMethod(method, annot.name, callLocation, invoke);
                }
            }
        }
        return this.processMethod(method, null, callLocation, invoke);
    }

    private boolean processJSBodyInvocation(MethodReader method, CallLocation callLocation, InvokeInstruction invoke, MethodHolder methodToProcess) {
        if (!this.classFilter.test(method.getOwnerName())) {
            return false;
        }
        boolean[] byRefParams = new boolean[method.parameterCount()];
        this.validateSignature(method, callLocation, byRefParams);
        if (invoke.getInstance() != null && !this.typeHelper.isJavaScriptClass(method.getOwnerName())) {
            this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method declaration. It is non-static and declared on a non-overlay class {{c1}}", new Object[]{invoke.getMethod(), method.getOwnerName()});
        }
        boolean returnByRef = false;
        AnnotationReader byRef = method.getAnnotations().get(JSByRef.class.getName());
        if (byRef != null) {
            if (!this.typeHelper.isSupportedByRefType(method.getResultType())) {
                this.diagnostics.error(callLocation, "Method {{m0}} is marked with @JSByRef, but does not return valid array type", new Object[]{method.getReference()});
                return false;
            }
            if (this.wasmGC) {
                AnnotationValue optionalValue = byRef.getValue("optional");
                if (optionalValue == null || !optionalValue.getBoolean()) {
                    this.diagnostics.error(callLocation, "Method {{m0}} is marked with @JSByRef, which is not supported in Wasm GC", new Object[]{method.getReference()});
                    return false;
                }
            } else {
                returnByRef = true;
            }
        }
        this.requireJSBody(this.diagnostics, method);
        MethodReference delegate = this.repository.methodMap.get(method.getReference());
        if (delegate == null) {
            return false;
        }
        Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
        InvokeInstruction newInvoke = new InvokeInstruction();
        newInvoke.setMethod(delegate);
        newInvoke.setType(InvocationType.SPECIAL);
        newInvoke.setReceiver(result);
        newInvoke.setLocation(invoke.getLocation());
        ArrayList<Variable> newArgs = new ArrayList<Variable>();
        if (invoke.getInstance() != null) {
            Variable arg = invoke.getInstance();
            arg = this.marshaller.wrapArgument(callLocation, arg, (ValueType)ValueType.object((String)method.getOwnerName()), (JSType)this.types.typeOf(arg), false, null);
            newArgs.add(arg);
        }
        for (int i = 0; i < invoke.getArguments().size(); ++i) {
            Variable arg = (Variable)invoke.getArguments().get(i);
            JSBufferType bufferType = this.extractBufferType(method.parameterAnnotation(i), method.parameterType(i), "parameter" + (i + 1), method.getReference(), callLocation);
            arg = this.marshaller.wrapArgument(callLocation, (Variable)invoke.getArguments().get(i), method.parameterType(i), (JSType)this.types.typeOf(arg), byRefParams[i], bufferType);
            newArgs.add(arg);
        }
        newInvoke.setArguments(newArgs.toArray(new Variable[0]));
        this.replacement.add((Instruction)newInvoke);
        if (result != null) {
            result = this.marshaller.unwrapReturnValue(callLocation, result, method.getResultType(), returnByRef, this.canBeOnlyJava(invoke.getReceiver()));
            this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
        }
        this.incrementalCache.addDependencies(methodToProcess.getReference(), new String[]{method.getOwnerName()});
        return true;
    }

    private JSBufferType extractBufferType(AnnotationContainerReader annotations, ValueType type, String subject, MethodReference method, CallLocation callLocation) {
        AnnotationReader annot = annotations.get(JSBuffer.class.getName());
        if (annot == null) {
            return null;
        }
        if (!this.isBufferType(type)) {
            this.diagnostics.error(callLocation, subject + " of {{m0}} is marked with @JSBuffer, but is not valid java.nio.Buffer", new Object[]{method});
            return null;
        }
        return JSBufferType.valueOf((String)annot.getValue("value").getEnumValue().getFieldName());
    }

    private boolean isBufferType(ValueType type) {
        if (!(type instanceof ValueType.Object)) {
            return false;
        }
        String className = ((ValueType.Object)type).getClassName();
        return this.hierarchy.isSuperType("java.nio.Buffer", className, false);
    }

    private boolean processProperty(MethodReader method, String suggestedName, CallLocation callLocation, InvokeInstruction invoke) {
        boolean pure;
        boolean bl = pure = method.getAnnotations().get(NO_SIDE_EFFECTS) != null;
        if (this.isProperGetter(method, suggestedName)) {
            String propertyName = suggestedName;
            if (propertyName == null) {
                propertyName = method.getName().charAt(0) == 'i' ? JSClassProcessor.cutPrefix(method.getName(), 2) : JSClassProcessor.cutPrefix(method.getName(), 3);
            }
            Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
            this.addPropertyGet(propertyName, this.getCallTarget(invoke), result, invoke.getLocation(), pure);
            if (result != null) {
                result = this.marshaller.unwrapReturnValue(callLocation, result, method.getResultType(), false, this.canBeOnlyJava(invoke.getReceiver()));
                this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
            }
            return true;
        }
        if (this.isProperSetter(method, suggestedName)) {
            String propertyName = suggestedName;
            if (propertyName == null) {
                propertyName = JSClassProcessor.cutPrefix(method.getName(), 3);
            }
            Variable value = (Variable)invoke.getArguments().get(0);
            value = this.marshaller.wrapArgument(callLocation, value, method.parameterType(0), (JSType)this.types.typeOf(value), false, null);
            this.addPropertySet(propertyName, this.getCallTarget(invoke), value, invoke.getLocation(), pure);
            return true;
        }
        this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript property declaration", new Object[]{invoke.getMethod()});
        return false;
    }

    private boolean processIndexer(MethodReader method, CallLocation callLocation, InvokeInstruction invoke) {
        if (this.isProperGetIndexer(method.getDescriptor())) {
            Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
            Variable index = (Variable)invoke.getArguments().get(0);
            this.addIndexerGet(this.getCallTarget(invoke), this.marshaller.wrapArgument(callLocation, index, method.parameterType(0), (JSType)this.types.typeOf(index), false, null), result, invoke.getLocation());
            if (result != null) {
                result = this.marshaller.unwrapReturnValue(callLocation, result, method.getResultType(), false, this.canBeOnlyJava(invoke.getReceiver()));
                this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
            }
            return true;
        }
        if (this.isProperSetIndexer(method.getDescriptor())) {
            Variable index = (Variable)invoke.getArguments().get(0);
            index = this.marshaller.wrapArgument(callLocation, index, method.parameterType(0), (JSType)this.types.typeOf(index), false, null);
            Variable value = (Variable)invoke.getArguments().get(1);
            value = this.marshaller.wrapArgument(callLocation, value, method.parameterType(1), (JSType)this.types.typeOf(value), false, null);
            this.addIndexerSet(this.getCallTarget(invoke), index, value, invoke.getLocation());
            return true;
        }
        this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript indexer declaration", new Object[]{invoke.getMethod()});
        return false;
    }

    private boolean validateSignature(MethodReader method, CallLocation callLocation, boolean[] byRefParams) {
        ValueType[] parameterTypes = method.getParameterTypes();
        AnnotationContainerReader[] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            ValueType paramType = parameterTypes[i];
            AnnotationReader byRef = parameterAnnotations[i].get(JSByRef.class.getName());
            if (byRef == null) continue;
            if (!this.typeHelper.isSupportedByRefType(paramType)) {
                this.diagnostics.error(callLocation, "Method {{m0}} is not a proper native JavaScript method declaration: its " + (i + 1) + "th parameter is declared as JSByRef, which has incompatible type", new Object[]{method.getReference()});
                return false;
            }
            if (this.wasmGC) {
                AnnotationValue optionalValue = byRef.getValue("optional");
                if (optionalValue != null && optionalValue.getBoolean()) continue;
                this.diagnostics.error(callLocation, "Parameter " + (i + 1) + " of method {{m0}} is marked with @JSByRef, which is not supported in Wasm GC", new Object[]{method.getReference()});
                return false;
            }
            byRefParams[i] = true;
        }
        return true;
    }

    private boolean canBeOnlyJava(Variable variable) {
        JSType type = (JSType)this.types.typeOf(variable);
        return type != JSType.JS && type != JSType.MIXED;
    }

    private boolean processMethod(MethodReader method, String name, CallLocation callLocation, InvokeInstruction invoke) {
        boolean[] byRefParams;
        if (name == null) {
            name = method.getName();
        }
        if (!this.validateSignature(method, callLocation, byRefParams = new boolean[method.parameterCount() + 1])) {
            return false;
        }
        boolean vararg = method.hasModifier(ElementModifier.VARARGS);
        Variable result = invoke.getReceiver() != null ? this.program.createVariable() : null;
        InvokeInstruction newInvoke = new InvokeInstruction();
        newInvoke.setMethod(vararg ? JSMethods.APPLY : JSMethods.invoke(method.parameterCount()));
        newInvoke.setType(InvocationType.SPECIAL);
        newInvoke.setReceiver(result);
        ArrayList<Object> newArguments = new ArrayList<Object>();
        newArguments.add(this.getCallTarget(invoke));
        newArguments.add(this.marshaller.addStringWrap(this.marshaller.addString(name, invoke.getLocation()), invoke.getLocation()));
        newInvoke.setLocation(invoke.getLocation());
        ArrayList<Variable> callArguments = new ArrayList<Variable>();
        for (int i = 0; i < invoke.getArguments().size(); ++i) {
            Variable arg = (Variable)invoke.getArguments().get(i);
            boolean byRef = byRefParams[i];
            if (vararg && i == invoke.getArguments().size() - 1 && this.typeHelper.isSupportedByRefType(method.parameterType(i)) && !this.wasmGC) {
                byRef = true;
            }
            JSBufferType bufferType = this.extractBufferType(method.parameterAnnotation(i), method.parameterType(i), "Parameter " + (i + 1), method.getReference(), callLocation);
            arg = this.marshaller.wrapArgument(callLocation, arg, method.parameterType(i), (JSType)this.types.typeOf(arg), byRef, bufferType);
            callArguments.add(arg);
        }
        if (vararg) {
            Variable prefixArg = null;
            if (callArguments.size() > 1) {
                InvokeInstruction arrayOfInvocation = new InvokeInstruction();
                arrayOfInvocation.setType(InvocationType.SPECIAL);
                arrayOfInvocation.setArguments(callArguments.subList(0, callArguments.size() - 1).toArray(new Variable[0]));
                arrayOfInvocation.setMethod(JSMethods.arrayOf(callArguments.size() - 1));
                arrayOfInvocation.setReceiver(this.program.createVariable());
                arrayOfInvocation.setLocation(invoke.getLocation());
                this.replacement.add((Instruction)arrayOfInvocation);
                prefixArg = arrayOfInvocation.getReceiver();
            }
            Variable arrayArg = (Variable)callArguments.get(callArguments.size() - 1);
            if (prefixArg != null) {
                InvokeInstruction concat = new InvokeInstruction();
                concat.setType(InvocationType.SPECIAL);
                concat.setArguments(new Variable[]{prefixArg, arrayArg});
                concat.setMethod(JSMethods.CONCAT_ARRAY);
                concat.setReceiver(this.program.createVariable());
                concat.setLocation(invoke.getLocation());
                this.replacement.add((Instruction)concat);
                arrayArg = concat.getReceiver();
            }
            newArguments.add(arrayArg);
        } else {
            newArguments.addAll(callArguments);
        }
        newInvoke.setArguments(newArguments.toArray(new Variable[0]));
        this.replacement.add((Instruction)newInvoke);
        if (result != null) {
            result = this.marshaller.unwrapReturnValue(callLocation, result, method.getResultType(), false, this.canBeOnlyJava(invoke.getReceiver()));
            this.copyVar(result, invoke.getReceiver(), invoke.getLocation());
        }
        return true;
    }

    private ClassReader getObjectClass() {
        if (this.objectClass == null) {
            this.objectClass = this.classSource.get("java.lang.Object");
        }
        return this.objectClass;
    }

    private Variable getCallTarget(InvokeInstruction invoke) {
        boolean isTopLevel;
        if (invoke.getInstance() != null) {
            return invoke.getInstance();
        }
        ClassReader cls = this.classSource.get(invoke.getMethod().getClassName());
        MethodReader method = cls != null ? cls.getMethod(invoke.getMethod().getDescriptor()) : null;
        boolean bl = isTopLevel = cls != null && cls.getAnnotations().get(JSTopLevel.class.getName()) != null || method != null && method.getAnnotations().get(JSTopLevel.class.getName()) != null;
        if (isTopLevel) {
            AnnotationContainerReader methodAnnotations = method != null ? method.getAnnotations() : null;
            return this.marshaller.moduleRef(invoke.getMethod().getClassName(), methodAnnotations, invoke.getLocation());
        }
        return this.marshaller.classRef(invoke.getMethod().getClassName(), invoke.getLocation());
    }

    private Variable getCallTarget(Variable instance, FieldReference fieldRef, TextLocation location) {
        boolean isTopLevel;
        if (instance != null) {
            return instance;
        }
        ClassReader cls = this.classSource.get(fieldRef.getClassName());
        FieldReader field = cls != null ? cls.getField(fieldRef.getFieldName()) : null;
        boolean bl = isTopLevel = cls != null && cls.getAnnotations().get(JSTopLevel.class.getName()) != null || field != null && field.getAnnotations().get(JSTopLevel.class.getName()) != null;
        if (isTopLevel) {
            AnnotationContainerReader fieldAnnotations = field != null ? field.getAnnotations() : null;
            return this.marshaller.moduleRef(fieldRef.getClassName(), fieldAnnotations, location);
        }
        return this.marshaller.classRef(fieldRef.getClassName(), location);
    }

    private boolean processConstructor(MethodReader method, CallLocation callLocation, InvokeInstruction invoke) {
        boolean[] byRefParams = new boolean[method.parameterCount() + 1];
        if (!this.validateSignature(method, callLocation, byRefParams)) {
            return false;
        }
        Variable result = this.program.variableAt(this.variableAliases[invoke.getInstance().getIndex()]);
        InvokeInstruction newInvoke = new InvokeInstruction();
        newInvoke.setMethod(JSMethods.construct(method.parameterCount()));
        newInvoke.setType(InvocationType.SPECIAL);
        newInvoke.setReceiver(result);
        ArrayList<Variable> newArguments = new ArrayList<Variable>();
        newArguments.add(this.marshaller.classRef(invoke.getMethod().getClassName(), invoke.getLocation()));
        newInvoke.setLocation(invoke.getLocation());
        for (int i = 0; i < invoke.getArguments().size(); ++i) {
            Variable arg = (Variable)invoke.getArguments().get(i);
            JSBufferType bufferType = this.extractBufferType(method.parameterAnnotation(i), method.parameterType(i), "Parameter " + (i + 1), method.getReference(), callLocation);
            arg = this.marshaller.wrapArgument(callLocation, arg, method.parameterType(i), (JSType)this.types.typeOf(arg), byRefParams[i], bufferType);
            newArguments.add(arg);
        }
        newInvoke.setArguments(newArguments.toArray(new Variable[0]));
        this.replacement.add((Instruction)newInvoke);
        return true;
    }

    private void requireJSBody(Diagnostics diagnostics, MethodReader methodToProcess) {
        if (!this.repository.processedMethods.add(methodToProcess.getReference())) {
            return;
        }
        this.processJSBody(diagnostics, methodToProcess);
    }

    private void processJSBody(Diagnostics diagnostics, MethodReader methodToProcess) {
        JsBodyImportInfo[] imports;
        AstRoot rootNode;
        int jsParamCount;
        CallLocation location = new CallLocation(methodToProcess.getReference());
        boolean isStatic = methodToProcess.hasModifier(ElementModifier.STATIC);
        AnnotationReader bodyAnnot = methodToProcess.getAnnotations().get(JSBody.class.getName());
        AnnotationValue paramsValue = bodyAnnot.getValue("params");
        int n = jsParamCount = paramsValue != null ? paramsValue.getList().size() : 0;
        if (methodToProcess.parameterCount() != jsParamCount) {
            diagnostics.error(location, "JSBody method {{m0}} declares " + methodToProcess.parameterCount() + " parameters, but annotation specifies " + jsParamCount, new Object[]{methodToProcess.getReference()});
            return;
        }
        int paramCount = methodToProcess.parameterCount();
        if (!isStatic) {
            ++paramCount;
        }
        if (!isStatic && !this.typeHelper.isJavaScriptClass(methodToProcess.getOwnerName())) {
            diagnostics.error(location, "Non-static JSBody method {{m0}} is owned by non-JS class {{c1}}", new Object[]{methodToProcess.getReference(), methodToProcess.getOwnerName()});
        }
        ValueType[] proxyParamTypes = new ValueType[paramCount + 1];
        for (int i = 0; i < paramCount; ++i) {
            proxyParamTypes[i] = JSMethods.JS_OBJECT;
        }
        proxyParamTypes[paramCount] = methodToProcess.getResultType() == ValueType.VOID ? ValueType.VOID : JSMethods.JS_OBJECT;
        ClassReader ownerClass = this.classSource.get(methodToProcess.getOwnerName());
        int methodIndex = this.indexOfMethod(ownerClass, methodToProcess);
        MethodReference proxyMethod = new MethodReference(methodToProcess.getOwnerName(), methodToProcess.getName() + "$js_body$_" + methodIndex, proxyParamTypes);
        String script = bodyAnnot.getValue("script").getString();
        String[] parameterNames = paramsValue != null ? (String[])paramsValue.getList().stream().map(AnnotationValue::getString).toArray(String[]::new) : new String[]{};
        TeaVMErrorReporter errorReporter = new TeaVMErrorReporter(diagnostics, new CallLocation(methodToProcess.getReference()));
        CompilerEnvirons env = new CompilerEnvirons();
        env.setRecoverFromErrors(true);
        env.setLanguageVersion(180);
        env.setIdeMode(true);
        JSParser parser = new JSParser(env, (ErrorReporter)errorReporter);
        try {
            rootNode = (AstRoot)parser.parseAsObject((Reader)new StringReader("function(){" + script + "}"), null, 0);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Error occurred", e);
        }
        AstNode body = ((FunctionNode)rootNode.getFirstChild()).getBody();
        AnnotationValue importsValue = bodyAnnot.getValue("imports");
        if (importsValue != null) {
            List importsList = importsValue.getList();
            imports = new JsBodyImportInfo[importsList.size()];
            for (int i = 0; i < importsList.size(); ++i) {
                AnnotationReader importAnnot = ((AnnotationValue)importsList.get(0)).getAnnotation();
                imports[i] = new JsBodyImportInfo(importAnnot.getValue("alias").getString(), importAnnot.getValue("fromModule").getString());
            }
        } else {
            imports = new JsBodyImportInfo[]{};
        }
        this.repository.methodMap.put(methodToProcess.getReference(), proxyMethod);
        if (errorReporter.hasErrors()) {
            this.repository.emitters.put(proxyMethod, new JSBodyBloatedEmitter(isStatic, proxyMethod, script, parameterNames, imports));
        } else {
            AstNode expr = JSBodyInlineUtil.isSuitableForInlining(methodToProcess.getReference(), parameterNames, body);
            if (expr != null) {
                this.repository.inlineMethods.add(methodToProcess.getReference());
            } else {
                expr = body;
            }
            this.javaInvocationProcessor.process(location, expr);
            JSBodyAstEmitter emitter = new JSBodyAstEmitter(isStatic, methodToProcess.getReference(), expr, (AstNode)rootNode, parameterNames, imports);
            this.repository.emitters.put(proxyMethod, emitter);
        }
        if (imports.length > 0) {
            this.repository.imports.put(proxyMethod, imports);
        }
    }

    private int indexOfMethod(ClassReader cls, MethodReader method) {
        int index = 0;
        for (MethodReader m : cls.getMethods()) {
            if (m.getDescriptor().equals((Object)method.getDescriptor())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    void createJSMethods(ClassHolder cls) {
        for (MethodHolder method : cls.getMethods().toArray(new MethodHolder[0])) {
            MethodReference methodRef = method.getReference();
            if (method.getAnnotations().get(JSBody.class.getName()) == null) continue;
            this.requireJSBody(this.diagnostics, (MethodReader)method);
            if (!this.repository.methodMap.containsKey(method.getReference())) continue;
            MethodReference proxyRef = this.repository.methodMap.get(methodRef);
            MethodHolder proxyMethod = new MethodHolder(proxyRef.getDescriptor());
            proxyMethod.getModifiers().add(ElementModifier.NATIVE);
            proxyMethod.getModifiers().add(ElementModifier.STATIC);
            if (method.getAnnotations().get(NoSideEffects.class.getName()) != null) {
                proxyMethod.getAnnotations().add(new AnnotationHolder(NoSideEffects.class.getName()));
            }
            proxyMethod.getAnnotations().add(new AnnotationHolder(JSBodyDelegate.class.getName()));
            boolean inline = this.repository.inlineMethods.contains(methodRef);
            AnnotationHolder generatorAnnot = new AnnotationHolder(inline ? DynamicInjector.class.getName() : DynamicGenerator.class.getName());
            proxyMethod.getAnnotations().add(generatorAnnot);
            cls.addMethod(proxyMethod);
            Set<MethodReference> callbacks = this.repository.callbackMethods.get(proxyRef);
            if (callbacks == null) continue;
            for (MethodReference callback : callbacks) {
                this.generateCallbackCaller(cls, callback);
            }
        }
    }

    private void generateCallbackCaller(ClassHolder cls, MethodReference callback) {
        MethodReference calleeRef = this.repository.callbackCallees.get(callback);
        MethodReader callee = this.classSource.resolve(calleeRef);
        MethodHolder callerMethod = new MethodHolder(callback.getDescriptor());
        callerMethod.getModifiers().add(ElementModifier.STATIC);
        CallLocation location = new CallLocation(callback);
        this.setCurrentProgram(new Program());
        for (int i = 0; i <= callback.parameterCount(); ++i) {
            this.program.createVariable();
        }
        BasicBlock block = this.program.createBasicBlock();
        int paramIndex = 1;
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(calleeRef);
        this.replacement.clear();
        if (!callee.hasModifier(ElementModifier.STATIC)) {
            insn.setInstance(this.marshaller.unwrapReturnValue(location, this.program.variableAt(paramIndex++), (ValueType)ValueType.object((String)calleeRef.getClassName()), false, true));
        }
        Variable[] args = new Variable[callee.parameterCount()];
        for (int i = 0; i < callee.parameterCount(); ++i) {
            args[i] = this.marshaller.unwrapReturnValue(location, this.program.variableAt(paramIndex++), callee.parameterType(i), false, true);
        }
        insn.setArguments(args);
        if (callee.getResultType() != ValueType.VOID) {
            insn.setReceiver(this.program.createVariable());
        }
        block.addAll(this.replacement);
        block.add((Instruction)insn);
        ExitInstruction exit = new ExitInstruction();
        if (insn.getReceiver() != null) {
            this.replacement.clear();
            exit.setValueToReturn(this.marshaller.wrap(insn.getReceiver(), callee.getResultType(), JSType.MIXED, null, false, null));
            block.addAll(this.replacement);
        }
        block.add((Instruction)exit);
        callerMethod.setProgram(this.program);
        cls.addMethod(callerMethod);
        this.processProgram(callerMethod);
    }

    private void addPropertyGet(String propertyName, Variable instance, Variable receiver, TextLocation location, boolean pure) {
        Variable nameVar = this.marshaller.addStringWrap(this.marshaller.addString(propertyName, location), location);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(pure ? JSMethods.GET_PURE : JSMethods.GET);
        insn.setReceiver(receiver);
        insn.setArguments(new Variable[]{instance, nameVar});
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addPropertySet(String propertyName, Variable instance, Variable value, TextLocation location, boolean pure) {
        Variable nameVar = this.marshaller.addStringWrap(this.marshaller.addString(propertyName, location), location);
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(pure ? JSMethods.SET_PURE : JSMethods.SET);
        insn.setArguments(new Variable[]{instance, nameVar, value});
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addIndexerGet(Variable array, Variable index, Variable receiver, TextLocation location) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(JSMethods.GET);
        insn.setReceiver(receiver);
        insn.setArguments(new Variable[]{array, index});
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void addIndexerSet(Variable array, Variable index, Variable value, TextLocation location) {
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(JSMethods.SET);
        insn.setArguments(new Variable[]{array, index, value});
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private void copyVar(Variable a, Variable b, TextLocation location) {
        AssignInstruction insn = new AssignInstruction();
        insn.setAssignee(a);
        insn.setReceiver(b);
        insn.setLocation(location);
        this.replacement.add((Instruction)insn);
    }

    private MethodReader getMethod(String className, MethodDescriptor descriptor) {
        ClassReader cls = this.classSource.get(className);
        if (cls == null) {
            return null;
        }
        MethodReader method = cls.getMethod(descriptor);
        if (method != null) {
            return method;
        }
        if (cls.getParent() != null && !cls.getParent().equals("java.lang.Object") && (method = this.getMethod(cls.getParent(), descriptor)) != null) {
            return method;
        }
        for (String iface : cls.getInterfaces()) {
            method = this.getMethod(iface, descriptor);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private boolean isProperGetter(MethodReader method, String suggestedName) {
        if (method.parameterCount() > 0) {
            return false;
        }
        if (suggestedName != null) {
            return true;
        }
        if (method.getResultType().equals(ValueType.BOOLEAN) && this.isProperPrefix(method.getName(), "is")) {
            return true;
        }
        return this.isProperPrefix(method.getName(), "get");
    }

    private boolean isProperSetter(MethodReader method, String suggestedName) {
        if (method.parameterCount() != 1 || method.getResultType() != ValueType.VOID) {
            return false;
        }
        return suggestedName != null || this.isProperPrefix(method.getName(), "set");
    }

    private boolean isProperPrefix(String name, String prefix) {
        if (!name.startsWith(prefix) || name.length() == prefix.length()) {
            return false;
        }
        char c = name.charAt(prefix.length());
        return Character.isUpperCase(c) || !Character.isAlphabetic(c) && Character.isJavaIdentifierStart(c);
    }

    private boolean isProperGetIndexer(MethodDescriptor desc) {
        return desc.parameterCount() == 1;
    }

    private boolean isProperSetIndexer(MethodDescriptor desc) {
        return desc.parameterCount() == 2 && desc.getResultType() == ValueType.VOID;
    }

    private static String cutPrefix(String name, int prefixLength) {
        if (name.length() == prefixLength + 1) {
            return name.substring(prefixLength).toLowerCase();
        }
        char c = name.charAt(prefixLength + 1);
        if (Character.isUpperCase(c)) {
            return name.substring(prefixLength);
        }
        return Character.toLowerCase(name.charAt(prefixLength)) + name.substring(prefixLength + 1);
    }
}

