/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.AccessLevel;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

abstract class JSAnnotationCache<T> {
    private ClassReaderSource classes;
    protected Diagnostics diagnostics;
    private Map<MethodReference, Value<T>> data = new HashMap<MethodReference, Value<T>>();

    JSAnnotationCache(ClassReaderSource classes, Diagnostics diagnostics) {
        this.classes = classes;
        this.diagnostics = diagnostics;
    }

    T get(MethodReference methodReference, CallLocation location) {
        Value<T> result = this.getValue(methodReference, location);
        return result != null ? (T)result.annotation : null;
    }

    private Value<T> getValue(MethodReference methodReference, CallLocation location) {
        Value<T> result = this.data.get(methodReference);
        if (result == null) {
            result = this.extract(methodReference, location);
            this.data.put(methodReference, result);
        }
        return result;
    }

    private Value<T> extract(MethodReference methodReference, CallLocation location) {
        ClassReader cls = this.classes.get(methodReference.getClassName());
        if (cls == null) {
            return new Value<Object>(null, methodReference);
        }
        MethodReader method = cls.getMethod(methodReference.getDescriptor());
        if (method == null || method.hasModifier(ElementModifier.STATIC) || method.getLevel() == AccessLevel.PRIVATE) {
            for (MethodReader candidateMethod : cls.getMethods()) {
                if (!candidateMethod.getName().equals(methodReference.getName()) || candidateMethod.hasModifier(ElementModifier.STATIC) || candidateMethod.hasModifier(ElementModifier.FINAL) || candidateMethod.getLevel() == AccessLevel.PRIVATE || !Arrays.equals(candidateMethod.getParameterTypes(), methodReference.getParameterTypes())) continue;
                method = candidateMethod;
                break;
            }
        }
        if (method != null) {
            methodReference = method.getReference();
            T annotation = this.take(method, location);
            if (annotation != null) {
                return new Value<T>(annotation, methodReference);
            }
        }
        HashMap candidates = new HashMap();
        if (cls.getParent() != null) {
            Value<T> value = this.getValue(new MethodReference(cls.getParent(), methodReference.getDescriptor()), location);
            if (value.annotation != null) {
                candidates.put(value.source, value.annotation);
            }
        }
        for (String itf : cls.getInterfaces()) {
            Value<T> value = this.getValue(new MethodReference(itf, methodReference.getDescriptor()), location);
            if (value == null) continue;
            candidates.put(value.source, value.annotation);
        }
        if (candidates.isEmpty()) {
            return new Value<Object>(null, methodReference);
        }
        if (candidates.size() == 1) {
            Map.Entry entry = candidates.entrySet().iterator().next();
            return new Value(entry.getValue(), (MethodReference)entry.getKey());
        }
        Object annot = null;
        MethodReference lastMethod = null;
        for (Map.Entry entry : candidates.entrySet()) {
            if (annot != null && !annot.equals(entry.getValue())) {
                this.diagnostics.error(location, "Method '{{m0}}' has inconsistent JS annotations from overridden methods '{{m1}}' and '{{m2}}', so it should be annotated explicitly", new Object[]{methodReference, lastMethod, entry.getKey()});
                return new Value<Object>(null, methodReference);
            }
            annot = entry.getValue();
            lastMethod = (MethodReference)entry.getKey();
        }
        return new Value<Object>(annot, methodReference);
    }

    protected abstract T take(MethodReader var1, CallLocation var2);

    private static class Value<T> {
        final T annotation;
        final MethodReference source;

        Value(T annotation, MethodReference source) {
            this.annotation = annotation;
            this.source = source;
        }
    }
}

