/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfo;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCClassInfoProvider;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapper;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapperFactory;
import org.teavm.backend.wasm.generate.gc.classes.WasmGCCustomTypeMapperFactoryContext;
import org.teavm.backend.wasm.model.WasmField;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.jso.impl.wasmgc.WasmGCJSRuntime;
import org.teavm.model.ValueType;

class WasmGCJSTypeMapper
implements WasmGCCustomTypeMapper,
WasmGCCustomTypeMapperFactory {
    private JSTypeHelper typeHelper;
    private WasmGCClassInfoProvider classInfoProvider;

    WasmGCJSTypeMapper() {
    }

    public WasmType map(String className) {
        if (this.typeHelper.isJavaScriptClass(className)) {
            return WasmType.Reference.EXTERN;
        }
        if (className.equals(WasmGCJSRuntime.CharArrayData.class.getName())) {
            WasmGCClassInfo cls = this.classInfoProvider.getClassInfo((ValueType)ValueType.arrayOf((ValueType)ValueType.CHARACTER));
            WasmField field = (WasmField)cls.getStructure().getFields().get(2);
            WasmType.CompositeReference ref = (WasmType.CompositeReference)field.getType().asUnpackedType();
            return ref.composite.getReference();
        }
        if (className.equals(WasmGCJSRuntime.NonNullExternal.class.getName())) {
            return WasmType.SpecialReferenceKind.EXTERN.asNonNullType();
        }
        return null;
    }

    public WasmGCCustomTypeMapper createTypeMapper(WasmGCCustomTypeMapperFactoryContext context) {
        this.typeHelper = new JSTypeHelper(context.originalClasses());
        this.classInfoProvider = context.classInfoProvider();
        return this;
    }
}

