/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl.wasmgc;

import org.teavm.interop.Import;
import org.teavm.jso.JSObject;
import org.teavm.jso.impl.wasmgc.WasmGCExceptionWrapper;

final class WasmGCJSRuntime {
    private static boolean stringBuiltinsSupported = WasmGCJSRuntime.stringBuiltinsSupported();

    private WasmGCJSRuntime() {
    }

    static JSObject stringToJs(String str) {
        if (str == null) {
            return null;
        }
        if (stringBuiltinsSupported) {
            return WasmGCJSRuntime.stringFromCharArray(CharArrayData.of(str), 0, str.length()).toNullable();
        }
        if (str.isEmpty()) {
            return WasmGCJSRuntime.substring(WasmGCJSRuntime.stringFromCharCode(32).toNullable(), 0, 0).toNullable();
        }
        JSObject result = WasmGCJSRuntime.stringFromCharCode(str.charAt(0)).toNullable();
        for (int i = 1; i < str.length(); ++i) {
            result = WasmGCJSRuntime.concatStrings(result, WasmGCJSRuntime.stringFromCharCode(str.charAt(i)).toNullable()).toNullable();
        }
        return result;
    }

    static String jsToString(JSObject obj) {
        if (obj == null || WasmGCJSRuntime.isUndefined(obj)) {
            return null;
        }
        int length = WasmGCJSRuntime.stringLength(obj);
        CharArrayData chars = CharArrayData.create(length);
        if (stringBuiltinsSupported) {
            WasmGCJSRuntime.stringIntoCharArray(obj, chars, 0);
        } else {
            for (int i = 0; i < length; ++i) {
                char code = (char)WasmGCJSRuntime.charCodeAt(obj, i);
                chars.put(i, code);
            }
        }
        return chars.asString();
    }

    @Import(name="length", module="wasm:js-string")
    static native int stringLength(JSObject var0);

    @Import(name="fromCharCodeArray", module="wasm:js-string")
    static native NonNullExternal stringFromCharArray(CharArrayData var0, int var1, int var2);

    @Import(name="fromCharCode", module="wasm:js-string")
    static native NonNullExternal stringFromCharCode(int var0);

    @Import(name="intoCharCodeArray", module="wasm:js-string")
    static native int stringIntoCharArray(JSObject var0, CharArrayData var1, int var2);

    @Import(name="concat", module="wasm:js-string")
    static native NonNullExternal concatStrings(JSObject var0, JSObject var1);

    @Import(name="substring", module="wasm:js-string")
    static native NonNullExternal substring(JSObject var0, int var1, int var2);

    @Import(name="charCodeAt", module="wasm:js-string")
    static native int charCodeAt(JSObject var0, int var1);

    @Import(name="stringBuiltinsSupported", module="teavmJso")
    static native boolean stringBuiltinsSupported();

    @Import(name="isUndefined", module="teavmJso")
    static native boolean isUndefined(JSObject var0);

    @Import(name="emptyArray", module="teavmJso")
    static native JSObject emptyArray();

    @Import(name="appendToArray", module="teavmJso")
    static native JSObject appendToArray(JSObject var0, JSObject var1);

    static native JSObject wrapObject(Object var0);

    static Throwable wrapException(JSObject obj) {
        return new WasmGCExceptionWrapper(obj);
    }

    static JSObject extractException(Throwable e) {
        return e instanceof WasmGCExceptionWrapper ? ((WasmGCExceptionWrapper)e).jsException : null;
    }

    static final class CharArrayData {
        CharArrayData() {
        }

        static native CharArrayData of(String var0);

        native String asString();

        static native CharArrayData create(int var0);

        native void put(int var1, char var2);
    }

    static final class NonNullExternal {
        NonNullExternal() {
        }

        native JSObject toNullable();
    }
}

