/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.impl;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.RenderingManager;
import org.teavm.backend.javascript.spi.MethodContributor;
import org.teavm.backend.javascript.spi.MethodContributorContext;
import org.teavm.jso.JSClass;
import org.teavm.jso.impl.FunctorImpl;
import org.teavm.jso.impl.JSConstructorToExpose;
import org.teavm.jso.impl.JSGetterToExpose;
import org.teavm.jso.impl.JSMethodToExpose;
import org.teavm.jso.impl.JSSetterToExpose;
import org.teavm.jso.impl.JSTypeHelper;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.spi.RendererListener;

class JSAliasRenderer
implements RendererListener,
MethodContributor {
    private static String variableChars = "abcdefghijklmnopqrstuvwxyz";
    private SourceWriter writer;
    private ListableClassReaderSource classSource;
    private JSTypeHelper typeHelper;
    private RenderingManager context;
    private int lastExportIndex;

    JSAliasRenderer() {
    }

    public void begin(RenderingManager context, BuildTarget buildTarget) {
        this.writer = context.getWriter();
        this.classSource = context.getClassSource();
        this.typeHelper = new JSTypeHelper((ClassReaderSource)context.getClassSource());
        this.context = context;
    }

    public void complete() {
        this.exportClasses();
        this.exportModule();
    }

    private void exportClasses() {
        ClassReader classReader;
        if (!this.hasClassesToExpose()) {
            return;
        }
        this.writer.startVariableDeclaration().appendFunction("$rt_jso_marker").appendGlobal("Symbol").append("('jsoClass')").endDeclaration();
        this.writer.append("(()").sameLineWs().append("=>").ws().append("{").softNewLine().indent();
        this.writer.append("let c;").softNewLine();
        HashMap<String, CallSite> exportedNamesByClass = new HashMap<String, CallSite>();
        for (String className : this.classSource.getClassNames()) {
            String name;
            classReader = this.classSource.get(className);
            boolean hasExportedMembers = false;
            hasExportedMembers |= this.exportClassInstanceMembers(classReader);
            if (className.equals(this.context.getEntryPoint()) || !(hasExportedMembers |= this.exportClassStaticMembers(classReader, name = "$rt_export_class_ " + this.getClassAliasName(classReader) + "_" + this.lastExportIndex++))) continue;
            exportedNamesByClass.put(className, (CallSite)((Object)name));
        }
        this.writer.outdent().append("})();").newLine();
        for (String className : this.classSource.getClassNames()) {
            classReader = this.classSource.get(className);
            String name = (String)exportedNamesByClass.get(className);
            if (name == null || this.typeHelper.isJavaScriptClass(className) || this.typeHelper.isJavaScriptImplementation(className)) continue;
            this.exportClassFromModule(classReader, name);
        }
    }

    private boolean exportClassInstanceMembers(ClassReader classReader) {
        Members members = this.collectMembers(classReader, method -> !method.hasModifier(ElementModifier.STATIC));
        boolean isJsClassImpl = this.typeHelper.isJavaScriptImplementation(classReader.getName());
        if (members.methods.isEmpty() && members.properties.isEmpty() && !isJsClassImpl) {
            return false;
        }
        this.writer.append("c").ws().append("=").ws().appendClass(classReader.getName()).append(".prototype;").softNewLine();
        if (isJsClassImpl) {
            this.writer.append("c[").appendFunction("$rt_jso_marker").append("]").ws().append("=").ws().append("true;").softNewLine();
        }
        for (Map.Entry<String, MethodDescriptor> entry : members.methods.entrySet()) {
            if (classReader.getMethod(entry.getValue()) == null) continue;
            this.appendMethodAlias(entry.getKey());
            this.writer.ws().append("=").ws().append("c.").appendVirtualMethod(entry.getValue()).append(";").softNewLine();
        }
        for (Map.Entry<String, Object> entry : members.properties.entrySet()) {
            PropertyInfo propInfo = (PropertyInfo)entry.getValue();
            if (propInfo.getter == null || classReader.getMethod(propInfo.getter) == null) continue;
            this.appendPropertyAlias(entry.getKey());
            this.writer.append("get:").ws().append("c.").appendVirtualMethod(propInfo.getter);
            if (propInfo.setter != null && classReader.getMethod(propInfo.setter) != null) {
                this.writer.append(",").softNewLine();
                this.writer.append("set:").ws().append("c.").appendVirtualMethod(propInfo.setter);
            }
            this.writer.softNewLine().outdent().append("});").softNewLine();
        }
        FieldReader functorField = this.getFunctorField(classReader);
        if (functorField != null) {
            this.writeFunctor(classReader, functorField.getReference());
        }
        return true;
    }

    private boolean exportClassStaticMembers(ClassReader classReader, String name) {
        Members members = this.collectMembers(classReader, c -> c.hasModifier(ElementModifier.STATIC));
        if (members.methods.isEmpty() && members.properties.isEmpty()) {
            return false;
        }
        this.writer.append("c").ws().append("=").ws().appendFunction(name).append(";").softNewLine();
        for (Map.Entry<String, MethodDescriptor> entry : members.methods.entrySet()) {
            this.appendMethodAlias(entry.getKey());
            MethodReference fullRef = new MethodReference(classReader.getName(), entry.getValue());
            this.writer.ws().append("=").ws().appendMethod(fullRef).append(";").softNewLine();
        }
        for (Map.Entry<String, Object> entry : members.properties.entrySet()) {
            PropertyInfo propInfo = (PropertyInfo)entry.getValue();
            if (propInfo.getter == null) continue;
            this.appendPropertyAlias(entry.getKey());
            MethodReference fullGetter = new MethodReference(classReader.getName(), propInfo.getter);
            this.writer.append("get:").ws().appendMethod(fullGetter);
            if (propInfo.setter != null) {
                this.writer.append(",").softNewLine();
                MethodReference fullSetter = new MethodReference(classReader.getName(), propInfo.setter);
                this.writer.append("set:").ws().appendMethod(fullSetter);
            }
            this.writer.softNewLine().outdent().append("});").softNewLine();
        }
        return true;
    }

    private void appendMethodAlias(String name) {
        if (this.isKeyword(name)) {
            this.writer.append("c[\"").append(name).append("\"]");
        } else {
            this.writer.append("c.").append(name);
        }
    }

    private void appendPropertyAlias(String name) {
        this.writer.append("Object.defineProperty(c,").ws().append("\"").append(name).append("\",").ws().append("{").indent().softNewLine();
    }

    private Members collectMembers(ClassReader classReader, Predicate<MethodReader> filter) {
        HashMap<String, MethodDescriptor> methods = new HashMap<String, MethodDescriptor>();
        HashMap<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
        MethodDescriptor constructor = null;
        for (MethodReader method : classReader.getMethods()) {
            Alias methodAlias;
            if (!filter.test(method) || (methodAlias = this.getPublicAlias(method)) == null) continue;
            switch (methodAlias.kind) {
                case METHOD: {
                    methods.put(methodAlias.name, method.getDescriptor());
                    break;
                }
                case GETTER: {
                    PropertyInfo propInfo = properties.computeIfAbsent(methodAlias.name, k -> new PropertyInfo());
                    propInfo.getter = method.getDescriptor();
                    break;
                }
                case SETTER: {
                    PropertyInfo propInfo = properties.computeIfAbsent(methodAlias.name, k -> new PropertyInfo());
                    propInfo.setter = method.getDescriptor();
                    break;
                }
                case CONSTRUCTOR: {
                    constructor = method.getDescriptor();
                }
            }
        }
        return new Members(methods, properties, constructor);
    }

    private void exportModule() {
        ClassReader cls = this.classSource.get(this.context.getEntryPoint());
        for (MethodReader method : cls.getMethods()) {
            Alias methodAlias;
            if (!method.hasModifier(ElementModifier.STATIC) || (methodAlias = this.getPublicAlias(method)) == null || methodAlias.kind != AliasKind.METHOD) continue;
            this.context.exportMethod(method.getReference(), methodAlias.name);
        }
    }

    private void exportClassFromModule(ClassReader cls, String functionName) {
        int i;
        String name = this.getClassAliasName(cls);
        Members constructors = this.collectMembers(cls, method -> !method.hasModifier(ElementModifier.STATIC));
        MethodDescriptor method2 = constructors.constructor;
        this.writer.append("function ").appendFunction(functionName).append("(");
        if (method2 != null) {
            for (i = 0; i < method2.parameterCount(); ++i) {
                if (i > 0) {
                    this.writer.append(",").ws();
                }
                this.writer.append("p" + i);
            }
        }
        this.writer.append(")").ws().appendBlockStart();
        if (method2 != null) {
            this.writer.appendClass(cls.getName()).append(".call(this);").softNewLine();
            this.writer.appendMethod(new MethodReference(cls.getName(), method2)).append("(this");
            for (i = 0; i < method2.parameterCount(); ++i) {
                this.writer.append(",").ws().append("p" + i);
            }
            this.writer.append(");").softNewLine();
        } else {
            this.writer.append("throw new Error(\"Can't instantiate this class directly\");").softNewLine();
        }
        this.writer.outdent().append("}").append(";").softNewLine();
        this.writer.appendFunction(functionName).append(".prototype").ws().append("=").ws().appendClass(cls.getName()).append(".prototype;").softNewLine();
        this.context.exportFunction(functionName, name);
    }

    private String getClassAliasName(ClassReader cls) {
        String nameValueString;
        AnnotationValue nameValue;
        AnnotationReader jsExport;
        String name = cls.getSimpleName();
        if (name == null) {
            name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
        }
        if ((jsExport = cls.getAnnotations().get(JSClass.class.getName())) != null && (nameValue = jsExport.getValue("name")) != null && !(nameValueString = nameValue.getString()).isEmpty()) {
            name = nameValueString;
        }
        return name;
    }

    private boolean hasClassesToExpose() {
        for (String className : this.classSource.getClassNames()) {
            ClassReader cls = this.classSource.get(className);
            if (this.typeHelper.isJavaScriptImplementation(className)) {
                return true;
            }
            for (MethodReader method : cls.getMethods()) {
                if (this.getPublicAlias(method) == null) continue;
                return true;
            }
        }
        return false;
    }

    private Alias getPublicAlias(MethodReader method) {
        AnnotationReader annot = method.getAnnotations().get(JSMethodToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.METHOD);
        }
        annot = method.getAnnotations().get(JSGetterToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.GETTER);
        }
        annot = method.getAnnotations().get(JSSetterToExpose.class.getName());
        if (annot != null) {
            return new Alias(annot.getValue("name").getString(), AliasKind.SETTER);
        }
        annot = method.getAnnotations().get(JSConstructorToExpose.class.getName());
        if (annot != null) {
            return new Alias(null, AliasKind.CONSTRUCTOR);
        }
        return null;
    }

    private FieldReader getFunctorField(ClassReader cls) {
        return cls.getField("$$jso_functor$$");
    }

    private boolean isKeyword(String id) {
        switch (id) {
            case "with": 
            case "delete": 
            case "in": 
            case "undefined": 
            case "debugger": 
            case "export": 
            case "function": 
            case "let": 
            case "var": 
            case "typeof": 
            case "yield": {
                return true;
            }
        }
        return false;
    }

    private void writeFunctor(ClassReader cls, FieldReference functorField) {
        AnnotationReader implAnnot = cls.getAnnotations().get(FunctorImpl.class.getName());
        MethodDescriptor functorMethod = MethodDescriptor.parse((String)implAnnot.getValue("value").getString());
        String alias = cls.getMethod(functorMethod).getAnnotations().get(JSMethodToExpose.class.getName()).getValue("name").getString();
        if (alias == null) {
            return;
        }
        this.writer.append("c.jso$functor$").append(alias).ws().append("=").ws().append("function()").ws().append("{").indent().softNewLine();
        this.writer.append("if").ws().append("(!this.").appendField(functorField).append(")").ws().append("{").indent().softNewLine();
        this.writer.append("var self").ws().append('=').ws().append("this;").softNewLine();
        this.writer.append("this.").appendField(functorField).ws().append('=').ws().append("function(");
        this.appendArguments(functorMethod.parameterCount());
        this.writer.append(")").ws().append('{').indent().softNewLine();
        this.writer.append("return self.").appendVirtualMethod(functorMethod).append('(');
        this.appendArguments(functorMethod.parameterCount());
        this.writer.append(");").softNewLine();
        this.writer.outdent().append("};").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return this.").appendField(functorField).append(';').softNewLine();
        this.writer.outdent().append("};").softNewLine();
    }

    private void appendArguments(int count) {
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                this.writer.append(',').ws();
            }
            this.writer.append(this.variableName(i));
        }
    }

    private String variableName(int index) {
        StringBuilder sb = new StringBuilder();
        sb.append(variableChars.charAt(index % variableChars.length()));
        if ((index /= variableChars.length()) > 0) {
            sb.append(index);
        }
        return sb.toString();
    }

    public boolean isContributing(MethodContributorContext context, MethodReference methodRef) {
        ClassReader classReader = context.getClassSource().get(methodRef.getClassName());
        if (classReader == null) {
            return false;
        }
        if (this.getFunctorField(classReader) != null) {
            return true;
        }
        MethodReader methodReader = classReader.getMethod(methodRef.getDescriptor());
        return methodReader != null && this.getPublicAlias(methodReader) != null;
    }

    private static class Members {
        final Map<String, MethodDescriptor> methods;
        final Map<String, PropertyInfo> properties;
        final MethodDescriptor constructor;

        Members(Map<String, MethodDescriptor> methods, Map<String, PropertyInfo> properties, MethodDescriptor constructor) {
            this.methods = methods;
            this.properties = properties;
            this.constructor = constructor;
        }
    }

    private static class PropertyInfo {
        MethodDescriptor getter;
        MethodDescriptor setter;

        private PropertyInfo() {
        }
    }

    private static class Alias {
        final String name;
        final AliasKind kind;

        Alias(String name, AliasKind kind) {
            this.name = name;
            this.kind = kind;
        }
    }

    private static enum AliasKind {
        METHOD,
        GETTER,
        SETTER,
        CONSTRUCTOR;

    }
}

