/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.browser;

import org.teavm.jso.JSBody;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.browser.AnimationFrameCallback;
import org.teavm.jso.browser.History;
import org.teavm.jso.browser.Location;
import org.teavm.jso.browser.Screen;
import org.teavm.jso.browser.StorageProvider;
import org.teavm.jso.browser.TimerHandler;
import org.teavm.jso.browser.WindowEventTarget;
import org.teavm.jso.browser.WindowFeatures;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSArrayReader;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLIFrameElement;

public abstract class Window
implements JSObject,
WindowEventTarget,
StorageProvider,
JSArrayReader<HTMLIFrameElement> {
    private static Window cachedInstance;

    private Window() {
    }

    @JSProperty
    public abstract HTMLDocument getDocument();

    @JSProperty
    public abstract Screen getScreen();

    @JSProperty
    public abstract int getScreenX();

    @JSProperty
    public abstract int getScreenY();

    @JSProperty
    public abstract Location getLocation();

    @JSProperty
    public abstract History getHistory();

    @JSProperty
    public abstract HTMLElement getFrameElement();

    @JSProperty
    public abstract JSArrayReader<HTMLIFrameElement> getFrames();

    @JSProperty
    public abstract int getInnerWidth();

    @JSProperty
    public abstract int getInnerHeight();

    @JSProperty
    public abstract int getOuterWidth();

    @JSProperty
    public abstract int getOuterHeight();

    @JSProperty
    public abstract int getScrollY();

    @JSProperty
    public abstract String getName();

    @JSProperty
    public abstract void setName(String var1);

    @JSProperty
    public abstract Window getParent();

    @JSProperty
    public abstract Window getTop();

    @JSBody(params={"message"}, script="alert(message);")
    public static native void alert(JSObject var0);

    @JSBody(params={"message"}, script="alert(message);")
    public static native void alert(String var0);

    @JSBody(params={"message"}, script="return confirm(message);")
    public static native boolean confirm(JSObject var0);

    @JSBody(params={"message"}, script="return confirm(message);")
    public static native boolean confirm(String var0);

    public static String prompt(String message) {
        return Window.prompt(message, "");
    }

    @JSBody(params={"message", "defaultValue"}, script="return prompt(message, defaultValue);")
    public static native String prompt(String var0, String var1);

    @JSBody(params={"handler", "delay"}, script="return setTimeout(handler, delay);")
    public static native int setTimeout(TimerHandler var0, int var1);

    @JSBody(params={"handler", "delay"}, script="return setTimeout(handler, delay);")
    public static native int setTimeout(TimerHandler var0, double var1);

    @JSBody(params={"timeoutId"}, script="clearTimeout(timeoutId);")
    public static native void clearTimeout(int var0);

    @JSBody(params={"handler", "delay"}, script="return setInterval(handler, delay);")
    public static native int setInterval(TimerHandler var0, int var1);

    @JSBody(params={"handler", "delay"}, script="return setInterval(handler, delay);")
    public static native int setInterval(TimerHandler var0, double var1);

    @JSBody(params={"timeoutId"}, script="clearInterval(timeoutId);")
    public static native void clearInterval(int var0);

    @JSBody(params={"callback"}, script="return requestAnimationFrame(callback);")
    public static native int requestAnimationFrame(AnimationFrameCallback var0);

    @JSBody(params={"requestId"}, script="cancelAnimationFrame(requestId);")
    public static native void cancelAnimationFrame(int var0);

    public abstract void blur();

    public abstract void focus();

    public abstract void close();

    public abstract void moveBy(int var1, int var2);

    public abstract void moveTo(int var1, int var2);

    public abstract void resizeBy(int var1, int var2);

    public abstract void resizeTo(int var1, int var2);

    public abstract void scrollBy(int var1, int var2);

    public abstract void scrollTo(int var1, int var2);

    public abstract Window open(String var1, String var2);

    public final Window open(String url, String name, WindowFeatures features) {
        return this.open(url, name, features.sb.toString());
    }

    public abstract Window open(String var1, String var2, String var3);

    public abstract void print();

    public abstract void stop();

    public abstract void postMessage(JSObject var1);

    public abstract void postMessage(JSObject var1, String var2);

    public abstract void postMessage(JSObject var1, String var2, JSArrayReader<JSObject> var3);

    public final void postMessage(JSObject message, String targetOrigin, JSObject ... transfer) {
        this.postMessage(message, targetOrigin, (JSArrayReader<JSObject>)JSArray.of(transfer));
    }

    @JSBody(script="return window;")
    public static native Window current();

    @JSBody(script="return self;")
    public static native Window worker();

    @JSBody(params={"uri"}, script="return encodeURI(uri);")
    public static native String encodeURI(String var0);

    @JSBody(params={"uri"}, script="return encodeURIComponent(uri);")
    public static native String encodeURIComponent(String var0);

    @JSBody(params={"uri"}, script="return decodeURI(uri);")
    public static native String decodeURI(String var0);

    @JSBody(params={"uri"}, script="return decodeURIComponent(uri);")
    public static native String decodeURIComponent(String var0);

    @JSProperty
    public abstract double getDevicePixelRatio();

    @JSBody(params={"s"}, script="return window.atob(s);")
    public static native String atob(String var0);

    @JSBody(params={"s"}, script="return window.btoa(s);")
    public static native String btoa(String var0);
}

