/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.jso.core;

import org.teavm.interop.NoSideEffects;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSClass;
import org.teavm.jso.JSObject;
import org.teavm.jso.JSProperty;
import org.teavm.jso.core.JSArray;
import org.teavm.jso.core.JSRegExpFlag;
import org.teavm.jso.core.JSString;

@JSClass(name="RegExp")
public class JSRegExp
implements JSObject {
    public JSRegExp(String pattern) {
    }

    public JSRegExp(String pattern, String flags) {
    }

    @JSBody(params={"pattern"}, script="return new RegExp(pattern);")
    @NoSideEffects
    @Deprecated
    public static native JSRegExp create(String var0);

    @JSBody(params={"pattern", "flags"}, script="return new RegExp(pattern, flags);")
    @NoSideEffects
    @Deprecated
    public static native JSRegExp create(String var0, String var1);

    public static JSRegExp create(String pattern, JSRegExpFlag ... flags) {
        boolean global = false;
        boolean ignoreCase = false;
        boolean multiline = false;
        block5: for (JSRegExpFlag flag : flags) {
            switch (flag) {
                case GLOBAL: {
                    global = true;
                    continue block5;
                }
                case IGNORE_CASE: {
                    ignoreCase = true;
                    continue block5;
                }
                case MULTILINE: {
                    multiline = true;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        if (global) {
            sb.append('g');
        }
        if (ignoreCase) {
            sb.append('i');
        }
        if (multiline) {
            sb.append('m');
        }
        return JSRegExp.create(pattern, sb.toString());
    }

    @JSProperty
    public native boolean isGlobal();

    @JSProperty
    public native boolean isIgnoreCase();

    @JSProperty
    public native boolean isMultiline();

    @JSProperty
    public native int getLastIndex();

    @JSProperty
    public native JSString getSource();

    public native JSArray<JSString> exec(JSString var1);

    public native boolean test(JSString var1);

    public native boolean test(String var1);
}

